/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAppInstanceBotRequest extends ChimeSdkIdentityRequest implements
        ToCopyableBuilder<UpdateAppInstanceBotRequest.Builder, UpdateAppInstanceBotRequest> {
    private static final SdkField<String> APP_INSTANCE_BOT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceBotArn").getter(getter(UpdateAppInstanceBotRequest::appInstanceBotArn))
            .setter(setter(Builder::appInstanceBotArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appInstanceBotArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateAppInstanceBotRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata").getter(getter(UpdateAppInstanceBotRequest::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<Configuration> CONFIGURATION_FIELD = SdkField.<Configuration> builder(MarshallingType.SDK_POJO)
            .memberName("Configuration").getter(getter(UpdateAppInstanceBotRequest::configuration))
            .setter(setter(Builder::configuration)).constructor(Configuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_BOT_ARN_FIELD,
            NAME_FIELD, METADATA_FIELD, CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appInstanceBotArn;

    private final String name;

    private final String metadata;

    private final Configuration configuration;

    private UpdateAppInstanceBotRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceBotArn = builder.appInstanceBotArn;
        this.name = builder.name;
        this.metadata = builder.metadata;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstanceBot</code>.
     * </p>
     * 
     * @return The ARN of the <code>AppInstanceBot</code>.
     */
    public final String appInstanceBotArn() {
        return appInstanceBotArn;
    }

    /**
     * <p>
     * The name of the <code>AppInstanceBot</code>.
     * </p>
     * 
     * @return The name of the <code>AppInstanceBot</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The metadata of the <code>AppInstanceBot</code>.
     * </p>
     * 
     * @return The metadata of the <code>AppInstanceBot</code>.
     */
    public final String metadata() {
        return metadata;
    }

    /**
     * <p>
     * The configuration for the bot update.
     * </p>
     * 
     * @return The configuration for the bot update.
     */
    public final Configuration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceBotArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppInstanceBotRequest)) {
            return false;
        }
        UpdateAppInstanceBotRequest other = (UpdateAppInstanceBotRequest) obj;
        return Objects.equals(appInstanceBotArn(), other.appInstanceBotArn()) && Objects.equals(name(), other.name())
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAppInstanceBotRequest").add("AppInstanceBotArn", appInstanceBotArn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceBotArn":
            return Optional.ofNullable(clazz.cast(appInstanceBotArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appInstanceBotArn", APP_INSTANCE_BOT_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Metadata", METADATA_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppInstanceBotRequest, T> g) {
        return obj -> g.apply((UpdateAppInstanceBotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkIdentityRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAppInstanceBotRequest> {
        /**
         * <p>
         * The ARN of the <code>AppInstanceBot</code>.
         * </p>
         * 
         * @param appInstanceBotArn
         *        The ARN of the <code>AppInstanceBot</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceBotArn(String appInstanceBotArn);

        /**
         * <p>
         * The name of the <code>AppInstanceBot</code>.
         * </p>
         * 
         * @param name
         *        The name of the <code>AppInstanceBot</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The metadata of the <code>AppInstanceBot</code>.
         * </p>
         * 
         * @param metadata
         *        The metadata of the <code>AppInstanceBot</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);

        /**
         * <p>
         * The configuration for the bot update.
         * </p>
         * 
         * @param configuration
         *        The configuration for the bot update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Configuration configuration);

        /**
         * <p>
         * The configuration for the bot update.
         * </p>
         * This is a convenience method that creates an instance of the {@link Configuration.Builder} avoiding the need
         * to create one manually via {@link Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Configuration.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(Configuration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(Configuration)
         */
        default Builder configuration(Consumer<Configuration.Builder> configuration) {
            return configuration(Configuration.builder().applyMutation(configuration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkIdentityRequest.BuilderImpl implements Builder {
        private String appInstanceBotArn;

        private String name;

        private String metadata;

        private Configuration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppInstanceBotRequest model) {
            super(model);
            appInstanceBotArn(model.appInstanceBotArn);
            name(model.name);
            metadata(model.metadata);
            configuration(model.configuration);
        }

        public final String getAppInstanceBotArn() {
            return appInstanceBotArn;
        }

        public final void setAppInstanceBotArn(String appInstanceBotArn) {
            this.appInstanceBotArn = appInstanceBotArn;
        }

        @Override
        public final Builder appInstanceBotArn(String appInstanceBotArn) {
            this.appInstanceBotArn = appInstanceBotArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMetadata() {
            return metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Configuration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(Configuration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAppInstanceBotRequest build() {
            return new UpdateAppInstanceBotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
