/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppInstanceBotsResponse extends ChimeSdkIdentityResponse implements
        ToCopyableBuilder<ListAppInstanceBotsResponse.Builder, ListAppInstanceBotsResponse> {
    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceArn").getter(getter(ListAppInstanceBotsResponse::appInstanceArn))
            .setter(setter(Builder::appInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceArn").build()).build();

    private static final SdkField<List<AppInstanceBotSummary>> APP_INSTANCE_BOTS_FIELD = SdkField
            .<List<AppInstanceBotSummary>> builder(MarshallingType.LIST)
            .memberName("AppInstanceBots")
            .getter(getter(ListAppInstanceBotsResponse::appInstanceBots))
            .setter(setter(Builder::appInstanceBots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceBots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppInstanceBotSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppInstanceBotSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAppInstanceBotsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_ARN_FIELD,
            APP_INSTANCE_BOTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appInstanceArn;

    private final List<AppInstanceBotSummary> appInstanceBots;

    private final String nextToken;

    private ListAppInstanceBotsResponse(BuilderImpl builder) {
        super(builder);
        this.appInstanceArn = builder.appInstanceArn;
        this.appInstanceBots = builder.appInstanceBots;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ARN of the AppInstance.
     * </p>
     * 
     * @return The ARN of the AppInstance.
     */
    public final String appInstanceArn() {
        return appInstanceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppInstanceBots property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAppInstanceBots() {
        return appInstanceBots != null && !(appInstanceBots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information for each requested <code>AppInstanceBot</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppInstanceBots} method.
     * </p>
     * 
     * @return The information for each requested <code>AppInstanceBot</code>.
     */
    public final List<AppInstanceBotSummary> appInstanceBots() {
        return appInstanceBots;
    }

    /**
     * <p>
     * The token passed by previous API calls until all requested bots are returned.
     * </p>
     * 
     * @return The token passed by previous API calls until all requested bots are returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppInstanceBots() ? appInstanceBots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppInstanceBotsResponse)) {
            return false;
        }
        ListAppInstanceBotsResponse other = (ListAppInstanceBotsResponse) obj;
        return Objects.equals(appInstanceArn(), other.appInstanceArn()) && hasAppInstanceBots() == other.hasAppInstanceBots()
                && Objects.equals(appInstanceBots(), other.appInstanceBots()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAppInstanceBotsResponse").add("AppInstanceArn", appInstanceArn())
                .add("AppInstanceBots", hasAppInstanceBots() ? appInstanceBots() : null)
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceArn":
            return Optional.ofNullable(clazz.cast(appInstanceArn()));
        case "AppInstanceBots":
            return Optional.ofNullable(clazz.cast(appInstanceBots()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppInstanceArn", APP_INSTANCE_ARN_FIELD);
        map.put("AppInstanceBots", APP_INSTANCE_BOTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAppInstanceBotsResponse, T> g) {
        return obj -> g.apply((ListAppInstanceBotsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkIdentityResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAppInstanceBotsResponse> {
        /**
         * <p>
         * The ARN of the AppInstance.
         * </p>
         * 
         * @param appInstanceArn
         *        The ARN of the AppInstance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceArn(String appInstanceArn);

        /**
         * <p>
         * The information for each requested <code>AppInstanceBot</code>.
         * </p>
         * 
         * @param appInstanceBots
         *        The information for each requested <code>AppInstanceBot</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceBots(Collection<AppInstanceBotSummary> appInstanceBots);

        /**
         * <p>
         * The information for each requested <code>AppInstanceBot</code>.
         * </p>
         * 
         * @param appInstanceBots
         *        The information for each requested <code>AppInstanceBot</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceBots(AppInstanceBotSummary... appInstanceBots);

        /**
         * <p>
         * The information for each requested <code>AppInstanceBot</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkidentity.model.AppInstanceBotSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkidentity.model.AppInstanceBotSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkidentity.model.AppInstanceBotSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #appInstanceBots(List<AppInstanceBotSummary>)}.
         * 
         * @param appInstanceBots
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkidentity.model.AppInstanceBotSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appInstanceBots(java.util.Collection<AppInstanceBotSummary>)
         */
        Builder appInstanceBots(Consumer<AppInstanceBotSummary.Builder>... appInstanceBots);

        /**
         * <p>
         * The token passed by previous API calls until all requested bots are returned.
         * </p>
         * 
         * @param nextToken
         *        The token passed by previous API calls until all requested bots are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeSdkIdentityResponse.BuilderImpl implements Builder {
        private String appInstanceArn;

        private List<AppInstanceBotSummary> appInstanceBots = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppInstanceBotsResponse model) {
            super(model);
            appInstanceArn(model.appInstanceArn);
            appInstanceBots(model.appInstanceBots);
            nextToken(model.nextToken);
        }

        public final String getAppInstanceArn() {
            return appInstanceArn;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        @Override
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        public final List<AppInstanceBotSummary.Builder> getAppInstanceBots() {
            List<AppInstanceBotSummary.Builder> result = AppInstanceBotListCopier.copyToBuilder(this.appInstanceBots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppInstanceBots(Collection<AppInstanceBotSummary.BuilderImpl> appInstanceBots) {
            this.appInstanceBots = AppInstanceBotListCopier.copyFromBuilder(appInstanceBots);
        }

        @Override
        public final Builder appInstanceBots(Collection<AppInstanceBotSummary> appInstanceBots) {
            this.appInstanceBots = AppInstanceBotListCopier.copy(appInstanceBots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appInstanceBots(AppInstanceBotSummary... appInstanceBots) {
            appInstanceBots(Arrays.asList(appInstanceBots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appInstanceBots(Consumer<AppInstanceBotSummary.Builder>... appInstanceBots) {
            appInstanceBots(Stream.of(appInstanceBots).map(c -> AppInstanceBotSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppInstanceBotsResponse build() {
            return new ListAppInstanceBotsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
