/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppInstancesResponse extends ChimeSdkIdentityResponse implements
        ToCopyableBuilder<ListAppInstancesResponse.Builder, ListAppInstancesResponse> {
    private static final SdkField<List<AppInstanceSummary>> APP_INSTANCES_FIELD = SdkField
            .<List<AppInstanceSummary>> builder(MarshallingType.LIST)
            .memberName("AppInstances")
            .getter(getter(ListAppInstancesResponse::appInstances))
            .setter(setter(Builder::appInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppInstanceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppInstanceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAppInstancesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AppInstanceSummary> appInstances;

    private final String nextToken;

    private ListAppInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.appInstances = builder.appInstances;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppInstances property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAppInstances() {
        return appInstances != null && !(appInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information for each <code>AppInstance</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppInstances} method.
     * </p>
     * 
     * @return The information for each <code>AppInstance</code>.
     */
    public final List<AppInstanceSummary> appInstances() {
        return appInstances;
    }

    /**
     * <p>
     * The token passed by previous API requests until the maximum number of <code>AppInstance</code>s is reached.
     * </p>
     * 
     * @return The token passed by previous API requests until the maximum number of <code>AppInstance</code>s is
     *         reached.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAppInstances() ? appInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppInstancesResponse)) {
            return false;
        }
        ListAppInstancesResponse other = (ListAppInstancesResponse) obj;
        return hasAppInstances() == other.hasAppInstances() && Objects.equals(appInstances(), other.appInstances())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAppInstancesResponse").add("AppInstances", hasAppInstances() ? appInstances() : null)
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstances":
            return Optional.ofNullable(clazz.cast(appInstances()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppInstances", APP_INSTANCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAppInstancesResponse, T> g) {
        return obj -> g.apply((ListAppInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkIdentityResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAppInstancesResponse> {
        /**
         * <p>
         * The information for each <code>AppInstance</code>.
         * </p>
         * 
         * @param appInstances
         *        The information for each <code>AppInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstances(Collection<AppInstanceSummary> appInstances);

        /**
         * <p>
         * The information for each <code>AppInstance</code>.
         * </p>
         * 
         * @param appInstances
         *        The information for each <code>AppInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstances(AppInstanceSummary... appInstances);

        /**
         * <p>
         * The information for each <code>AppInstance</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkidentity.model.AppInstanceSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkidentity.model.AppInstanceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkidentity.model.AppInstanceSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #appInstances(List<AppInstanceSummary>)}.
         * 
         * @param appInstances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkidentity.model.AppInstanceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appInstances(java.util.Collection<AppInstanceSummary>)
         */
        Builder appInstances(Consumer<AppInstanceSummary.Builder>... appInstances);

        /**
         * <p>
         * The token passed by previous API requests until the maximum number of <code>AppInstance</code>s is reached.
         * </p>
         * 
         * @param nextToken
         *        The token passed by previous API requests until the maximum number of <code>AppInstance</code>s is
         *        reached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeSdkIdentityResponse.BuilderImpl implements Builder {
        private List<AppInstanceSummary> appInstances = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppInstancesResponse model) {
            super(model);
            appInstances(model.appInstances);
            nextToken(model.nextToken);
        }

        public final List<AppInstanceSummary.Builder> getAppInstances() {
            List<AppInstanceSummary.Builder> result = AppInstanceListCopier.copyToBuilder(this.appInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppInstances(Collection<AppInstanceSummary.BuilderImpl> appInstances) {
            this.appInstances = AppInstanceListCopier.copyFromBuilder(appInstances);
        }

        @Override
        public final Builder appInstances(Collection<AppInstanceSummary> appInstances) {
            this.appInstances = AppInstanceListCopier.copy(appInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appInstances(AppInstanceSummary... appInstances) {
            appInstances(Arrays.asList(appInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appInstances(Consumer<AppInstanceSummary.Builder>... appInstances) {
            appInstances(Stream.of(appInstances).map(c -> AppInstanceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppInstancesResponse build() {
            return new ListAppInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
