/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkidentity.model.AllowMessages;
import software.amazon.awssdk.services.chimesdkidentity.model.ChimeSdkIdentityRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAppInstanceUserEndpointRequest
extends ChimeSdkIdentityRequest
implements ToCopyableBuilder<Builder, UpdateAppInstanceUserEndpointRequest> {
    private static final SdkField<String> APP_INSTANCE_USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppInstanceUserArn").getter(UpdateAppInstanceUserEndpointRequest.getter(UpdateAppInstanceUserEndpointRequest::appInstanceUserArn)).setter(UpdateAppInstanceUserEndpointRequest.setter(Builder::appInstanceUserArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appInstanceUserArn").build()}).build();
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointId").getter(UpdateAppInstanceUserEndpointRequest.getter(UpdateAppInstanceUserEndpointRequest::endpointId)).setter(UpdateAppInstanceUserEndpointRequest.setter(Builder::endpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("endpointId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateAppInstanceUserEndpointRequest.getter(UpdateAppInstanceUserEndpointRequest::name)).setter(UpdateAppInstanceUserEndpointRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ALLOW_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllowMessages").getter(UpdateAppInstanceUserEndpointRequest.getter(UpdateAppInstanceUserEndpointRequest::allowMessagesAsString)).setter(UpdateAppInstanceUserEndpointRequest.setter(Builder::allowMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMessages").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_USER_ARN_FIELD, ENDPOINT_ID_FIELD, NAME_FIELD, ALLOW_MESSAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAppInstanceUserEndpointRequest.memberNameToFieldInitializer();
    private final String appInstanceUserArn;
    private final String endpointId;
    private final String name;
    private final String allowMessages;

    private UpdateAppInstanceUserEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceUserArn = builder.appInstanceUserArn;
        this.endpointId = builder.endpointId;
        this.name = builder.name;
        this.allowMessages = builder.allowMessages;
    }

    public final String appInstanceUserArn() {
        return this.appInstanceUserArn;
    }

    public final String endpointId() {
        return this.endpointId;
    }

    public final String name() {
        return this.name;
    }

    public final AllowMessages allowMessages() {
        return AllowMessages.fromValue(this.allowMessages);
    }

    public final String allowMessagesAsString() {
        return this.allowMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appInstanceUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowMessagesAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppInstanceUserEndpointRequest)) {
            return false;
        }
        UpdateAppInstanceUserEndpointRequest other = (UpdateAppInstanceUserEndpointRequest)((Object)obj);
        return Objects.equals(this.appInstanceUserArn(), other.appInstanceUserArn()) && Objects.equals(this.endpointId(), other.endpointId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.allowMessagesAsString(), other.allowMessagesAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAppInstanceUserEndpointRequest").add("AppInstanceUserArn", (Object)this.appInstanceUserArn()).add("EndpointId", (Object)this.endpointId()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("AllowMessages", (Object)this.allowMessagesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppInstanceUserArn": {
                return Optional.ofNullable(clazz.cast(this.appInstanceUserArn()));
            }
            case "EndpointId": {
                return Optional.ofNullable(clazz.cast(this.endpointId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AllowMessages": {
                return Optional.ofNullable(clazz.cast(this.allowMessagesAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("appInstanceUserArn", APP_INSTANCE_USER_ARN_FIELD);
        map.put("endpointId", ENDPOINT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("AllowMessages", ALLOW_MESSAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppInstanceUserEndpointRequest, T> g) {
        return obj -> g.apply((UpdateAppInstanceUserEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkIdentityRequest.BuilderImpl
    implements Builder {
        private String appInstanceUserArn;
        private String endpointId;
        private String name;
        private String allowMessages;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppInstanceUserEndpointRequest model) {
            super(model);
            this.appInstanceUserArn(model.appInstanceUserArn);
            this.endpointId(model.endpointId);
            this.name(model.name);
            this.allowMessages(model.allowMessages);
        }

        public final String getAppInstanceUserArn() {
            return this.appInstanceUserArn;
        }

        public final void setAppInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
        }

        @Override
        public final Builder appInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
            return this;
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAllowMessages() {
            return this.allowMessages;
        }

        public final void setAllowMessages(String allowMessages) {
            this.allowMessages = allowMessages;
        }

        @Override
        public final Builder allowMessages(String allowMessages) {
            this.allowMessages = allowMessages;
            return this;
        }

        @Override
        public final Builder allowMessages(AllowMessages allowMessages) {
            this.allowMessages(allowMessages == null ? null : allowMessages.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAppInstanceUserEndpointRequest build() {
            return new UpdateAppInstanceUserEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkIdentityRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAppInstanceUserEndpointRequest> {
        public Builder appInstanceUserArn(String var1);

        public Builder endpointId(String var1);

        public Builder name(String var1);

        public Builder allowMessages(String var1);

        public Builder allowMessages(AllowMessages var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

