/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAppInstanceBotRequest extends ChimeSdkIdentityRequest implements
        ToCopyableBuilder<CreateAppInstanceBotRequest.Builder, CreateAppInstanceBotRequest> {
    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceArn").getter(getter(CreateAppInstanceBotRequest::appInstanceArn))
            .setter(setter(Builder::appInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateAppInstanceBotRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata").getter(getter(CreateAppInstanceBotRequest::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateAppInstanceBotRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateAppInstanceBotRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Configuration> CONFIGURATION_FIELD = SdkField.<Configuration> builder(MarshallingType.SDK_POJO)
            .memberName("Configuration").getter(getter(CreateAppInstanceBotRequest::configuration))
            .setter(setter(Builder::configuration)).constructor(Configuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_ARN_FIELD,
            NAME_FIELD, METADATA_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD, CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appInstanceArn;

    private final String name;

    private final String metadata;

    private final String clientRequestToken;

    private final List<Tag> tags;

    private final Configuration configuration;

    private CreateAppInstanceBotRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceArn = builder.appInstanceArn;
        this.name = builder.name;
        this.metadata = builder.metadata;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstance</code> request.
     * </p>
     * 
     * @return The ARN of the <code>AppInstance</code> request.
     */
    public final String appInstanceArn() {
        return appInstanceArn;
    }

    /**
     * <p>
     * The user's name.
     * </p>
     * 
     * @return The user's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The request metadata. Limited to a 1KB string in UTF-8.
     * </p>
     * 
     * @return The request metadata. Limited to a 1KB string in UTF-8.
     */
    public final String metadata() {
        return metadata;
    }

    /**
     * <p>
     * The unique ID for the client making the request. Use different tokens for different <code>AppInstanceBots</code>.
     * </p>
     * 
     * @return The unique ID for the client making the request. Use different tokens for different
     *         <code>AppInstanceBots</code>.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the <code>AppInstanceBot</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the <code>AppInstanceBot</code>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Configuration information about the Amazon Lex V2 V2 bot.
     * </p>
     * 
     * @return Configuration information about the Amazon Lex V2 V2 bot.
     */
    public final Configuration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppInstanceBotRequest)) {
            return false;
        }
        CreateAppInstanceBotRequest other = (CreateAppInstanceBotRequest) obj;
        return Objects.equals(appInstanceArn(), other.appInstanceArn()) && Objects.equals(name(), other.name())
                && Objects.equals(metadata(), other.metadata())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAppInstanceBotRequest").add("AppInstanceArn", appInstanceArn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClientRequestToken", clientRequestToken()).add("Tags", hasTags() ? tags() : null)
                .add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceArn":
            return Optional.ofNullable(clazz.cast(appInstanceArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppInstanceArn", APP_INSTANCE_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Metadata", METADATA_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAppInstanceBotRequest, T> g) {
        return obj -> g.apply((CreateAppInstanceBotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkIdentityRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAppInstanceBotRequest> {
        /**
         * <p>
         * The ARN of the <code>AppInstance</code> request.
         * </p>
         * 
         * @param appInstanceArn
         *        The ARN of the <code>AppInstance</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceArn(String appInstanceArn);

        /**
         * <p>
         * The user's name.
         * </p>
         * 
         * @param name
         *        The user's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The request metadata. Limited to a 1KB string in UTF-8.
         * </p>
         * 
         * @param metadata
         *        The request metadata. Limited to a 1KB string in UTF-8.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);

        /**
         * <p>
         * The unique ID for the client making the request. Use different tokens for different
         * <code>AppInstanceBots</code>.
         * </p>
         * 
         * @param clientRequestToken
         *        The unique ID for the client making the request. Use different tokens for different
         *        <code>AppInstanceBots</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The tags assigned to the <code>AppInstanceBot</code>.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the <code>AppInstanceBot</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the <code>AppInstanceBot</code>.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the <code>AppInstanceBot</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the <code>AppInstanceBot</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkidentity.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.chimesdkidentity.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkidentity.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkidentity.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Configuration information about the Amazon Lex V2 V2 bot.
         * </p>
         * 
         * @param configuration
         *        Configuration information about the Amazon Lex V2 V2 bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Configuration configuration);

        /**
         * <p>
         * Configuration information about the Amazon Lex V2 V2 bot.
         * </p>
         * This is a convenience method that creates an instance of the {@link Configuration.Builder} avoiding the need
         * to create one manually via {@link Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Configuration.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(Configuration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(Configuration)
         */
        default Builder configuration(Consumer<Configuration.Builder> configuration) {
            return configuration(Configuration.builder().applyMutation(configuration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkIdentityRequest.BuilderImpl implements Builder {
        private String appInstanceArn;

        private String name;

        private String metadata;

        private String clientRequestToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Configuration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppInstanceBotRequest model) {
            super(model);
            appInstanceArn(model.appInstanceArn);
            name(model.name);
            metadata(model.metadata);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
            configuration(model.configuration);
        }

        public final String getAppInstanceArn() {
            return appInstanceArn;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        @Override
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMetadata() {
            return metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Configuration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(Configuration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppInstanceBotRequest build() {
            return new CreateAppInstanceBotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
