/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterAppInstanceUserEndpointRequest extends ChimeSdkIdentityRequest implements
        ToCopyableBuilder<DeregisterAppInstanceUserEndpointRequest.Builder, DeregisterAppInstanceUserEndpointRequest> {
    private static final SdkField<String> APP_INSTANCE_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceUserArn").getter(getter(DeregisterAppInstanceUserEndpointRequest::appInstanceUserArn))
            .setter(setter(Builder::appInstanceUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appInstanceUserArn").build()).build();

    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(DeregisterAppInstanceUserEndpointRequest::endpointId))
            .setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("endpointId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_USER_ARN_FIELD,
            ENDPOINT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appInstanceUserArn;

    private final String endpointId;

    private DeregisterAppInstanceUserEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceUserArn = builder.appInstanceUserArn;
        this.endpointId = builder.endpointId;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstanceUser</code>.
     * </p>
     * 
     * @return The ARN of the <code>AppInstanceUser</code>.
     */
    public final String appInstanceUserArn() {
        return appInstanceUserArn;
    }

    /**
     * <p>
     * The unique identifier of the <code>AppInstanceUserEndpoint</code>.
     * </p>
     * 
     * @return The unique identifier of the <code>AppInstanceUserEndpoint</code>.
     */
    public final String endpointId() {
        return endpointId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterAppInstanceUserEndpointRequest)) {
            return false;
        }
        DeregisterAppInstanceUserEndpointRequest other = (DeregisterAppInstanceUserEndpointRequest) obj;
        return Objects.equals(appInstanceUserArn(), other.appInstanceUserArn())
                && Objects.equals(endpointId(), other.endpointId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeregisterAppInstanceUserEndpointRequest").add("AppInstanceUserArn", appInstanceUserArn())
                .add("EndpointId", endpointId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceUserArn":
            return Optional.ofNullable(clazz.cast(appInstanceUserArn()));
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appInstanceUserArn", APP_INSTANCE_USER_ARN_FIELD);
        map.put("endpointId", ENDPOINT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeregisterAppInstanceUserEndpointRequest, T> g) {
        return obj -> g.apply((DeregisterAppInstanceUserEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkIdentityRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeregisterAppInstanceUserEndpointRequest> {
        /**
         * <p>
         * The ARN of the <code>AppInstanceUser</code>.
         * </p>
         * 
         * @param appInstanceUserArn
         *        The ARN of the <code>AppInstanceUser</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceUserArn(String appInstanceUserArn);

        /**
         * <p>
         * The unique identifier of the <code>AppInstanceUserEndpoint</code>.
         * </p>
         * 
         * @param endpointId
         *        The unique identifier of the <code>AppInstanceUserEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkIdentityRequest.BuilderImpl implements Builder {
        private String appInstanceUserArn;

        private String endpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterAppInstanceUserEndpointRequest model) {
            super(model);
            appInstanceUserArn(model.appInstanceUserArn);
            endpointId(model.endpointId);
        }

        public final String getAppInstanceUserArn() {
            return appInstanceUserArn;
        }

        public final void setAppInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
        }

        @Override
        public final Builder appInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
            return this;
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeregisterAppInstanceUserEndpointRequest build() {
            return new DeregisterAppInstanceUserEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
