/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the data-retention settings for an <code>AppInstance</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppInstanceRetentionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AppInstanceRetentionSettings.Builder, AppInstanceRetentionSettings> {
    private static final SdkField<ChannelRetentionSettings> CHANNEL_RETENTION_SETTINGS_FIELD = SdkField
            .<ChannelRetentionSettings> builder(MarshallingType.SDK_POJO).memberName("ChannelRetentionSettings")
            .getter(getter(AppInstanceRetentionSettings::channelRetentionSettings))
            .setter(setter(Builder::channelRetentionSettings)).constructor(ChannelRetentionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelRetentionSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CHANNEL_RETENTION_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ChannelRetentionSettings channelRetentionSettings;

    private AppInstanceRetentionSettings(BuilderImpl builder) {
        this.channelRetentionSettings = builder.channelRetentionSettings;
    }

    /**
     * <p>
     * The length of time in days to retain the messages in a channel.
     * </p>
     * 
     * @return The length of time in days to retain the messages in a channel.
     */
    public final ChannelRetentionSettings channelRetentionSettings() {
        return channelRetentionSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelRetentionSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppInstanceRetentionSettings)) {
            return false;
        }
        AppInstanceRetentionSettings other = (AppInstanceRetentionSettings) obj;
        return Objects.equals(channelRetentionSettings(), other.channelRetentionSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppInstanceRetentionSettings").add("ChannelRetentionSettings", channelRetentionSettings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelRetentionSettings":
            return Optional.ofNullable(clazz.cast(channelRetentionSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChannelRetentionSettings", CHANNEL_RETENTION_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppInstanceRetentionSettings, T> g) {
        return obj -> g.apply((AppInstanceRetentionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppInstanceRetentionSettings> {
        /**
         * <p>
         * The length of time in days to retain the messages in a channel.
         * </p>
         * 
         * @param channelRetentionSettings
         *        The length of time in days to retain the messages in a channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelRetentionSettings(ChannelRetentionSettings channelRetentionSettings);

        /**
         * <p>
         * The length of time in days to retain the messages in a channel.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChannelRetentionSettings.Builder}
         * avoiding the need to create one manually via {@link ChannelRetentionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChannelRetentionSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #channelRetentionSettings(ChannelRetentionSettings)}.
         * 
         * @param channelRetentionSettings
         *        a consumer that will call methods on {@link ChannelRetentionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelRetentionSettings(ChannelRetentionSettings)
         */
        default Builder channelRetentionSettings(Consumer<ChannelRetentionSettings.Builder> channelRetentionSettings) {
            return channelRetentionSettings(ChannelRetentionSettings.builder().applyMutation(channelRetentionSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ChannelRetentionSettings channelRetentionSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(AppInstanceRetentionSettings model) {
            channelRetentionSettings(model.channelRetentionSettings);
        }

        public final ChannelRetentionSettings.Builder getChannelRetentionSettings() {
            return channelRetentionSettings != null ? channelRetentionSettings.toBuilder() : null;
        }

        public final void setChannelRetentionSettings(ChannelRetentionSettings.BuilderImpl channelRetentionSettings) {
            this.channelRetentionSettings = channelRetentionSettings != null ? channelRetentionSettings.build() : null;
        }

        @Override
        public final Builder channelRetentionSettings(ChannelRetentionSettings channelRetentionSettings) {
            this.channelRetentionSettings = channelRetentionSettings;
            return this;
        }

        @Override
        public AppInstanceRetentionSettings build() {
            return new AppInstanceRetentionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
