/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAppInstanceBotRequest extends ChimeSdkIdentityRequest implements
        ToCopyableBuilder<DescribeAppInstanceBotRequest.Builder, DescribeAppInstanceBotRequest> {
    private static final SdkField<String> APP_INSTANCE_BOT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceBotArn").getter(getter(DescribeAppInstanceBotRequest::appInstanceBotArn))
            .setter(setter(Builder::appInstanceBotArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appInstanceBotArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_BOT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appInstanceBotArn;

    private DescribeAppInstanceBotRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceBotArn = builder.appInstanceBotArn;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstanceBot</code>.
     * </p>
     * 
     * @return The ARN of the <code>AppInstanceBot</code>.
     */
    public final String appInstanceBotArn() {
        return appInstanceBotArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceBotArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppInstanceBotRequest)) {
            return false;
        }
        DescribeAppInstanceBotRequest other = (DescribeAppInstanceBotRequest) obj;
        return Objects.equals(appInstanceBotArn(), other.appInstanceBotArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAppInstanceBotRequest").add("AppInstanceBotArn", appInstanceBotArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceBotArn":
            return Optional.ofNullable(clazz.cast(appInstanceBotArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appInstanceBotArn", APP_INSTANCE_BOT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppInstanceBotRequest, T> g) {
        return obj -> g.apply((DescribeAppInstanceBotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkIdentityRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAppInstanceBotRequest> {
        /**
         * <p>
         * The ARN of the <code>AppInstanceBot</code>.
         * </p>
         * 
         * @param appInstanceBotArn
         *        The ARN of the <code>AppInstanceBot</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceBotArn(String appInstanceBotArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkIdentityRequest.BuilderImpl implements Builder {
        private String appInstanceBotArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppInstanceBotRequest model) {
            super(model);
            appInstanceBotArn(model.appInstanceBotArn);
        }

        public final String getAppInstanceBotArn() {
            return appInstanceBotArn;
        }

        public final void setAppInstanceBotArn(String appInstanceBotArn) {
            this.appInstanceBotArn = appInstanceBotArn;
        }

        @Override
        public final Builder appInstanceBotArn(String appInstanceBotArn) {
            this.appInstanceBotArn = appInstanceBotArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAppInstanceBotRequest build() {
            return new DescribeAppInstanceBotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
