/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkidentity.model.AppInstanceRetentionSettings;
import software.amazon.awssdk.services.chimesdkidentity.model.ChimeSdkIdentityRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAppInstanceRetentionSettingsRequest
extends ChimeSdkIdentityRequest
implements ToCopyableBuilder<Builder, PutAppInstanceRetentionSettingsRequest> {
    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppInstanceArn").getter(PutAppInstanceRetentionSettingsRequest.getter(PutAppInstanceRetentionSettingsRequest::appInstanceArn)).setter(PutAppInstanceRetentionSettingsRequest.setter(Builder::appInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appInstanceArn").build()}).build();
    private static final SdkField<AppInstanceRetentionSettings> APP_INSTANCE_RETENTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AppInstanceRetentionSettings").getter(PutAppInstanceRetentionSettingsRequest.getter(PutAppInstanceRetentionSettingsRequest::appInstanceRetentionSettings)).setter(PutAppInstanceRetentionSettingsRequest.setter(Builder::appInstanceRetentionSettings)).constructor(AppInstanceRetentionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceRetentionSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_ARN_FIELD, APP_INSTANCE_RETENTION_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutAppInstanceRetentionSettingsRequest.memberNameToFieldInitializer();
    private final String appInstanceArn;
    private final AppInstanceRetentionSettings appInstanceRetentionSettings;

    private PutAppInstanceRetentionSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceArn = builder.appInstanceArn;
        this.appInstanceRetentionSettings = builder.appInstanceRetentionSettings;
    }

    public final String appInstanceArn() {
        return this.appInstanceArn;
    }

    public final AppInstanceRetentionSettings appInstanceRetentionSettings() {
        return this.appInstanceRetentionSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appInstanceRetentionSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAppInstanceRetentionSettingsRequest)) {
            return false;
        }
        PutAppInstanceRetentionSettingsRequest other = (PutAppInstanceRetentionSettingsRequest)((Object)obj);
        return Objects.equals(this.appInstanceArn(), other.appInstanceArn()) && Objects.equals(this.appInstanceRetentionSettings(), other.appInstanceRetentionSettings());
    }

    public final String toString() {
        return ToString.builder((String)"PutAppInstanceRetentionSettingsRequest").add("AppInstanceArn", (Object)this.appInstanceArn()).add("AppInstanceRetentionSettings", (Object)this.appInstanceRetentionSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.appInstanceArn()));
            }
            case "AppInstanceRetentionSettings": {
                return Optional.ofNullable(clazz.cast(this.appInstanceRetentionSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appInstanceArn", APP_INSTANCE_ARN_FIELD);
        map.put("AppInstanceRetentionSettings", APP_INSTANCE_RETENTION_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAppInstanceRetentionSettingsRequest, T> g) {
        return obj -> g.apply((PutAppInstanceRetentionSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkIdentityRequest.BuilderImpl
    implements Builder {
        private String appInstanceArn;
        private AppInstanceRetentionSettings appInstanceRetentionSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAppInstanceRetentionSettingsRequest model) {
            super(model);
            this.appInstanceArn(model.appInstanceArn);
            this.appInstanceRetentionSettings(model.appInstanceRetentionSettings);
        }

        public final String getAppInstanceArn() {
            return this.appInstanceArn;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        @Override
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        public final AppInstanceRetentionSettings.Builder getAppInstanceRetentionSettings() {
            return this.appInstanceRetentionSettings != null ? this.appInstanceRetentionSettings.toBuilder() : null;
        }

        public final void setAppInstanceRetentionSettings(AppInstanceRetentionSettings.BuilderImpl appInstanceRetentionSettings) {
            this.appInstanceRetentionSettings = appInstanceRetentionSettings != null ? appInstanceRetentionSettings.build() : null;
        }

        @Override
        public final Builder appInstanceRetentionSettings(AppInstanceRetentionSettings appInstanceRetentionSettings) {
            this.appInstanceRetentionSettings = appInstanceRetentionSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAppInstanceRetentionSettingsRequest build() {
            return new PutAppInstanceRetentionSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkIdentityRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAppInstanceRetentionSettingsRequest> {
        public Builder appInstanceArn(String var1);

        public Builder appInstanceRetentionSettings(AppInstanceRetentionSettings var1);

        default public Builder appInstanceRetentionSettings(Consumer<AppInstanceRetentionSettings.Builder> appInstanceRetentionSettings) {
            return this.appInstanceRetentionSettings((AppInstanceRetentionSettings)((AppInstanceRetentionSettings.Builder)AppInstanceRetentionSettings.builder().applyMutation(appInstanceRetentionSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

