/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkidentity.model.AllowMessages;
import software.amazon.awssdk.services.chimesdkidentity.model.AppInstanceUserEndpointType;
import software.amazon.awssdk.services.chimesdkidentity.model.ChimeSdkIdentityRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.EndpointAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterAppInstanceUserEndpointRequest
extends ChimeSdkIdentityRequest
implements ToCopyableBuilder<Builder, RegisterAppInstanceUserEndpointRequest> {
    private static final SdkField<String> APP_INSTANCE_USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppInstanceUserArn").getter(RegisterAppInstanceUserEndpointRequest.getter(RegisterAppInstanceUserEndpointRequest::appInstanceUserArn)).setter(RegisterAppInstanceUserEndpointRequest.setter(Builder::appInstanceUserArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appInstanceUserArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RegisterAppInstanceUserEndpointRequest.getter(RegisterAppInstanceUserEndpointRequest::name)).setter(RegisterAppInstanceUserEndpointRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(RegisterAppInstanceUserEndpointRequest.getter(RegisterAppInstanceUserEndpointRequest::typeAsString)).setter(RegisterAppInstanceUserEndpointRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(RegisterAppInstanceUserEndpointRequest.getter(RegisterAppInstanceUserEndpointRequest::resourceArn)).setter(RegisterAppInstanceUserEndpointRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<EndpointAttributes> ENDPOINT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointAttributes").getter(RegisterAppInstanceUserEndpointRequest.getter(RegisterAppInstanceUserEndpointRequest::endpointAttributes)).setter(RegisterAppInstanceUserEndpointRequest.setter(Builder::endpointAttributes)).constructor(EndpointAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointAttributes").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(RegisterAppInstanceUserEndpointRequest.getter(RegisterAppInstanceUserEndpointRequest::clientRequestToken)).setter(RegisterAppInstanceUserEndpointRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ALLOW_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllowMessages").getter(RegisterAppInstanceUserEndpointRequest.getter(RegisterAppInstanceUserEndpointRequest::allowMessagesAsString)).setter(RegisterAppInstanceUserEndpointRequest.setter(Builder::allowMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMessages").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_USER_ARN_FIELD, NAME_FIELD, TYPE_FIELD, RESOURCE_ARN_FIELD, ENDPOINT_ATTRIBUTES_FIELD, CLIENT_REQUEST_TOKEN_FIELD, ALLOW_MESSAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegisterAppInstanceUserEndpointRequest.memberNameToFieldInitializer();
    private final String appInstanceUserArn;
    private final String name;
    private final String type;
    private final String resourceArn;
    private final EndpointAttributes endpointAttributes;
    private final String clientRequestToken;
    private final String allowMessages;

    private RegisterAppInstanceUserEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceUserArn = builder.appInstanceUserArn;
        this.name = builder.name;
        this.type = builder.type;
        this.resourceArn = builder.resourceArn;
        this.endpointAttributes = builder.endpointAttributes;
        this.clientRequestToken = builder.clientRequestToken;
        this.allowMessages = builder.allowMessages;
    }

    public final String appInstanceUserArn() {
        return this.appInstanceUserArn;
    }

    public final String name() {
        return this.name;
    }

    public final AppInstanceUserEndpointType type() {
        return AppInstanceUserEndpointType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final EndpointAttributes endpointAttributes() {
        return this.endpointAttributes;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final AllowMessages allowMessages() {
        return AllowMessages.fromValue(this.allowMessages);
    }

    public final String allowMessagesAsString() {
        return this.allowMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appInstanceUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowMessagesAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterAppInstanceUserEndpointRequest)) {
            return false;
        }
        RegisterAppInstanceUserEndpointRequest other = (RegisterAppInstanceUserEndpointRequest)((Object)obj);
        return Objects.equals(this.appInstanceUserArn(), other.appInstanceUserArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.endpointAttributes(), other.endpointAttributes()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.allowMessagesAsString(), other.allowMessagesAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterAppInstanceUserEndpointRequest").add("AppInstanceUserArn", (Object)(this.appInstanceUserArn() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("ResourceArn", (Object)this.resourceArn()).add("EndpointAttributes", (Object)this.endpointAttributes()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("AllowMessages", (Object)this.allowMessagesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppInstanceUserArn": {
                return Optional.ofNullable(clazz.cast(this.appInstanceUserArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "EndpointAttributes": {
                return Optional.ofNullable(clazz.cast(this.endpointAttributes()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "AllowMessages": {
                return Optional.ofNullable(clazz.cast(this.allowMessagesAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appInstanceUserArn", APP_INSTANCE_USER_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("EndpointAttributes", ENDPOINT_ATTRIBUTES_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("AllowMessages", ALLOW_MESSAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterAppInstanceUserEndpointRequest, T> g) {
        return obj -> g.apply((RegisterAppInstanceUserEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkIdentityRequest.BuilderImpl
    implements Builder {
        private String appInstanceUserArn;
        private String name;
        private String type;
        private String resourceArn;
        private EndpointAttributes endpointAttributes;
        private String clientRequestToken;
        private String allowMessages;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterAppInstanceUserEndpointRequest model) {
            super(model);
            this.appInstanceUserArn(model.appInstanceUserArn);
            this.name(model.name);
            this.type(model.type);
            this.resourceArn(model.resourceArn);
            this.endpointAttributes(model.endpointAttributes);
            this.clientRequestToken(model.clientRequestToken);
            this.allowMessages(model.allowMessages);
        }

        public final String getAppInstanceUserArn() {
            return this.appInstanceUserArn;
        }

        public final void setAppInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
        }

        @Override
        public final Builder appInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AppInstanceUserEndpointType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final EndpointAttributes.Builder getEndpointAttributes() {
            return this.endpointAttributes != null ? this.endpointAttributes.toBuilder() : null;
        }

        public final void setEndpointAttributes(EndpointAttributes.BuilderImpl endpointAttributes) {
            this.endpointAttributes = endpointAttributes != null ? endpointAttributes.build() : null;
        }

        @Override
        public final Builder endpointAttributes(EndpointAttributes endpointAttributes) {
            this.endpointAttributes = endpointAttributes;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getAllowMessages() {
            return this.allowMessages;
        }

        public final void setAllowMessages(String allowMessages) {
            this.allowMessages = allowMessages;
        }

        @Override
        public final Builder allowMessages(String allowMessages) {
            this.allowMessages = allowMessages;
            return this;
        }

        @Override
        public final Builder allowMessages(AllowMessages allowMessages) {
            this.allowMessages(allowMessages == null ? null : allowMessages.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterAppInstanceUserEndpointRequest build() {
            return new RegisterAppInstanceUserEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChimeSdkIdentityRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterAppInstanceUserEndpointRequest> {
        public Builder appInstanceUserArn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(AppInstanceUserEndpointType var1);

        public Builder resourceArn(String var1);

        public Builder endpointAttributes(EndpointAttributes var1);

        default public Builder endpointAttributes(Consumer<EndpointAttributes.Builder> endpointAttributes) {
            return this.endpointAttributes((EndpointAttributes)((EndpointAttributes.Builder)EndpointAttributes.builder().applyMutation(endpointAttributes)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder allowMessages(String var1);

        public Builder allowMessages(AllowMessages var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

