/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMediaCapturePipelineResponse extends ChimeSdkMediaPipelinesResponse implements
        ToCopyableBuilder<CreateMediaCapturePipelineResponse.Builder, CreateMediaCapturePipelineResponse> {
    private static final SdkField<MediaCapturePipeline> MEDIA_CAPTURE_PIPELINE_FIELD = SdkField
            .<MediaCapturePipeline> builder(MarshallingType.SDK_POJO).memberName("MediaCapturePipeline")
            .getter(getter(CreateMediaCapturePipelineResponse::mediaCapturePipeline))
            .setter(setter(Builder::mediaCapturePipeline)).constructor(MediaCapturePipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaCapturePipeline").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_CAPTURE_PIPELINE_FIELD));

    private final MediaCapturePipeline mediaCapturePipeline;

    private CreateMediaCapturePipelineResponse(BuilderImpl builder) {
        super(builder);
        this.mediaCapturePipeline = builder.mediaCapturePipeline;
    }

    /**
     * <p>
     * A media capture pipeline object, the ID, source type, source ARN, sink type, and sink ARN of a media capture
     * pipeline object.
     * </p>
     * 
     * @return A media capture pipeline object, the ID, source type, source ARN, sink type, and sink ARN of a media
     *         capture pipeline object.
     */
    public final MediaCapturePipeline mediaCapturePipeline() {
        return mediaCapturePipeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mediaCapturePipeline());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMediaCapturePipelineResponse)) {
            return false;
        }
        CreateMediaCapturePipelineResponse other = (CreateMediaCapturePipelineResponse) obj;
        return Objects.equals(mediaCapturePipeline(), other.mediaCapturePipeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMediaCapturePipelineResponse").add("MediaCapturePipeline", mediaCapturePipeline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaCapturePipeline":
            return Optional.ofNullable(clazz.cast(mediaCapturePipeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMediaCapturePipelineResponse, T> g) {
        return obj -> g.apply((CreateMediaCapturePipelineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMediaPipelinesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMediaCapturePipelineResponse> {
        /**
         * <p>
         * A media capture pipeline object, the ID, source type, source ARN, sink type, and sink ARN of a media capture
         * pipeline object.
         * </p>
         * 
         * @param mediaCapturePipeline
         *        A media capture pipeline object, the ID, source type, source ARN, sink type, and sink ARN of a media
         *        capture pipeline object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaCapturePipeline(MediaCapturePipeline mediaCapturePipeline);

        /**
         * <p>
         * A media capture pipeline object, the ID, source type, source ARN, sink type, and sink ARN of a media capture
         * pipeline object.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaCapturePipeline.Builder} avoiding
         * the need to create one manually via {@link MediaCapturePipeline#builder()}.
         *
         * When the {@link Consumer} completes, {@link MediaCapturePipeline.Builder#build()} is called immediately and
         * its result is passed to {@link #mediaCapturePipeline(MediaCapturePipeline)}.
         * 
         * @param mediaCapturePipeline
         *        a consumer that will call methods on {@link MediaCapturePipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaCapturePipeline(MediaCapturePipeline)
         */
        default Builder mediaCapturePipeline(Consumer<MediaCapturePipeline.Builder> mediaCapturePipeline) {
            return mediaCapturePipeline(MediaCapturePipeline.builder().applyMutation(mediaCapturePipeline).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesResponse.BuilderImpl implements Builder {
        private MediaCapturePipeline mediaCapturePipeline;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMediaCapturePipelineResponse model) {
            super(model);
            mediaCapturePipeline(model.mediaCapturePipeline);
        }

        public final MediaCapturePipeline.Builder getMediaCapturePipeline() {
            return mediaCapturePipeline != null ? mediaCapturePipeline.toBuilder() : null;
        }

        public final void setMediaCapturePipeline(MediaCapturePipeline.BuilderImpl mediaCapturePipeline) {
            this.mediaCapturePipeline = mediaCapturePipeline != null ? mediaCapturePipeline.build() : null;
        }

        @Override
        public final Builder mediaCapturePipeline(MediaCapturePipeline mediaCapturePipeline) {
            this.mediaCapturePipeline = mediaCapturePipeline;
            return this;
        }

        @Override
        public CreateMediaCapturePipelineResponse build() {
            return new CreateMediaCapturePipelineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
