/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AudioMuxType {
    AUDIO_ONLY("AudioOnly"),
    AUDIO_WITH_ACTIVE_SPEAKER_VIDEO("AudioWithActiveSpeakerVideo"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AudioMuxType> VALUE_MAP;
    private final String value;

    private AudioMuxType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AudioMuxType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AudioMuxType> knownValues() {
        EnumSet<AudioMuxType> knownValues = EnumSet.allOf(AudioMuxType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AudioMuxType.class, AudioMuxType::toString);
    }
}

