/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMediaCapturePipelineRequest extends ChimeSdkMediaPipelinesRequest implements
        ToCopyableBuilder<CreateMediaCapturePipelineRequest.Builder, CreateMediaCapturePipelineRequest> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(CreateMediaCapturePipelineRequest::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(CreateMediaCapturePipelineRequest::sourceArn))
            .setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<String> SINK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SinkType").getter(getter(CreateMediaCapturePipelineRequest::sinkTypeAsString))
            .setter(setter(Builder::sinkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkType").build()).build();

    private static final SdkField<String> SINK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SinkArn").getter(getter(CreateMediaCapturePipelineRequest::sinkArn)).setter(setter(Builder::sinkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkArn").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateMediaCapturePipelineRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<ChimeSdkMeetingConfiguration> CHIME_SDK_MEETING_CONFIGURATION_FIELD = SdkField
            .<ChimeSdkMeetingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ChimeSdkMeetingConfiguration")
            .getter(getter(CreateMediaCapturePipelineRequest::chimeSdkMeetingConfiguration))
            .setter(setter(Builder::chimeSdkMeetingConfiguration))
            .constructor(ChimeSdkMeetingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChimeSdkMeetingConfiguration")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateMediaCapturePipelineRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD,
            SOURCE_ARN_FIELD, SINK_TYPE_FIELD, SINK_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD, CHIME_SDK_MEETING_CONFIGURATION_FIELD,
            TAGS_FIELD));

    private final String sourceType;

    private final String sourceArn;

    private final String sinkType;

    private final String sinkArn;

    private final String clientRequestToken;

    private final ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration;

    private final List<Tag> tags;

    private CreateMediaCapturePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.sourceType = builder.sourceType;
        this.sourceArn = builder.sourceArn;
        this.sinkType = builder.sinkType;
        this.sinkArn = builder.sinkArn;
        this.clientRequestToken = builder.clientRequestToken;
        this.chimeSdkMeetingConfiguration = builder.chimeSdkMeetingConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Source type from which the media artifacts are captured. A Chime SDK Meeting is the only supported source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link MediaPipelineSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Source type from which the media artifacts are captured. A Chime SDK Meeting is the only supported
     *         source.
     * @see MediaPipelineSourceType
     */
    public final MediaPipelineSourceType sourceType() {
        return MediaPipelineSourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * Source type from which the media artifacts are captured. A Chime SDK Meeting is the only supported source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link MediaPipelineSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Source type from which the media artifacts are captured. A Chime SDK Meeting is the only supported
     *         source.
     * @see MediaPipelineSourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * <p>
     * ARN of the source from which the media artifacts are captured.
     * </p>
     * 
     * @return ARN of the source from which the media artifacts are captured.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * Destination type to which the media artifacts are saved. You must use an S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sinkType} will
     * return {@link MediaPipelineSinkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sinkTypeAsString}.
     * </p>
     * 
     * @return Destination type to which the media artifacts are saved. You must use an S3 bucket.
     * @see MediaPipelineSinkType
     */
    public final MediaPipelineSinkType sinkType() {
        return MediaPipelineSinkType.fromValue(sinkType);
    }

    /**
     * <p>
     * Destination type to which the media artifacts are saved. You must use an S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sinkType} will
     * return {@link MediaPipelineSinkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sinkTypeAsString}.
     * </p>
     * 
     * @return Destination type to which the media artifacts are saved. You must use an S3 bucket.
     * @see MediaPipelineSinkType
     */
    public final String sinkTypeAsString() {
        return sinkType;
    }

    /**
     * <p>
     * The ARN of the sink type.
     * </p>
     * 
     * @return The ARN of the sink type.
     */
    public final String sinkArn() {
        return sinkArn;
    }

    /**
     * <p>
     * The unique identifier for the client request. The token makes the API request idempotent. Use a unique token for
     * each media pipeline request.
     * </p>
     * 
     * @return The unique identifier for the client request. The token makes the API request idempotent. Use a unique
     *         token for each media pipeline request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The configuration for a specified media pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.
     * </p>
     * 
     * @return The configuration for a specified media pipeline. <code>SourceType</code> must be
     *         <code>ChimeSdkMeeting</code>.
     */
    public final ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration() {
        return chimeSdkMeetingConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag key-value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tag key-value pairs.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sinkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sinkArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(chimeSdkMeetingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMediaCapturePipelineRequest)) {
            return false;
        }
        CreateMediaCapturePipelineRequest other = (CreateMediaCapturePipelineRequest) obj;
        return Objects.equals(sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(sourceArn(), other.sourceArn())
                && Objects.equals(sinkTypeAsString(), other.sinkTypeAsString()) && Objects.equals(sinkArn(), other.sinkArn())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(chimeSdkMeetingConfiguration(), other.chimeSdkMeetingConfiguration())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMediaCapturePipelineRequest").add("SourceType", sourceTypeAsString())
                .add("SourceArn", sourceArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SinkType", sinkTypeAsString()).add("SinkArn", sinkArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClientRequestToken", clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ChimeSdkMeetingConfiguration", chimeSdkMeetingConfiguration()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "SinkType":
            return Optional.ofNullable(clazz.cast(sinkTypeAsString()));
        case "SinkArn":
            return Optional.ofNullable(clazz.cast(sinkArn()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "ChimeSdkMeetingConfiguration":
            return Optional.ofNullable(clazz.cast(chimeSdkMeetingConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMediaCapturePipelineRequest, T> g) {
        return obj -> g.apply((CreateMediaCapturePipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMediaPipelinesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMediaCapturePipelineRequest> {
        /**
         * <p>
         * Source type from which the media artifacts are captured. A Chime SDK Meeting is the only supported source.
         * </p>
         * 
         * @param sourceType
         *        Source type from which the media artifacts are captured. A Chime SDK Meeting is the only supported
         *        source.
         * @see MediaPipelineSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * Source type from which the media artifacts are captured. A Chime SDK Meeting is the only supported source.
         * </p>
         * 
         * @param sourceType
         *        Source type from which the media artifacts are captured. A Chime SDK Meeting is the only supported
         *        source.
         * @see MediaPipelineSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineSourceType
         */
        Builder sourceType(MediaPipelineSourceType sourceType);

        /**
         * <p>
         * ARN of the source from which the media artifacts are captured.
         * </p>
         * 
         * @param sourceArn
         *        ARN of the source from which the media artifacts are captured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * Destination type to which the media artifacts are saved. You must use an S3 bucket.
         * </p>
         * 
         * @param sinkType
         *        Destination type to which the media artifacts are saved. You must use an S3 bucket.
         * @see MediaPipelineSinkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineSinkType
         */
        Builder sinkType(String sinkType);

        /**
         * <p>
         * Destination type to which the media artifacts are saved. You must use an S3 bucket.
         * </p>
         * 
         * @param sinkType
         *        Destination type to which the media artifacts are saved. You must use an S3 bucket.
         * @see MediaPipelineSinkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineSinkType
         */
        Builder sinkType(MediaPipelineSinkType sinkType);

        /**
         * <p>
         * The ARN of the sink type.
         * </p>
         * 
         * @param sinkArn
         *        The ARN of the sink type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinkArn(String sinkArn);

        /**
         * <p>
         * The unique identifier for the client request. The token makes the API request idempotent. Use a unique token
         * for each media pipeline request.
         * </p>
         * 
         * @param clientRequestToken
         *        The unique identifier for the client request. The token makes the API request idempotent. Use a unique
         *        token for each media pipeline request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The configuration for a specified media pipeline. <code>SourceType</code> must be
         * <code>ChimeSdkMeeting</code>.
         * </p>
         * 
         * @param chimeSdkMeetingConfiguration
         *        The configuration for a specified media pipeline. <code>SourceType</code> must be
         *        <code>ChimeSdkMeeting</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration);

        /**
         * <p>
         * The configuration for a specified media pipeline. <code>SourceType</code> must be
         * <code>ChimeSdkMeeting</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChimeSdkMeetingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ChimeSdkMeetingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChimeSdkMeetingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration)}.
         * 
         * @param chimeSdkMeetingConfiguration
         *        a consumer that will call methods on {@link ChimeSdkMeetingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration)
         */
        default Builder chimeSdkMeetingConfiguration(Consumer<ChimeSdkMeetingConfiguration.Builder> chimeSdkMeetingConfiguration) {
            return chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration.builder()
                    .applyMutation(chimeSdkMeetingConfiguration).build());
        }

        /**
         * <p>
         * The tag key-value pairs.
         * </p>
         * 
         * @param tags
         *        The tag key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag key-value pairs.
         * </p>
         * 
         * @param tags
         *        The tag key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag key-value pairs.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesRequest.BuilderImpl implements Builder {
        private String sourceType;

        private String sourceArn;

        private String sinkType;

        private String sinkArn;

        private String clientRequestToken;

        private ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMediaCapturePipelineRequest model) {
            super(model);
            sourceType(model.sourceType);
            sourceArn(model.sourceArn);
            sinkType(model.sinkType);
            sinkArn(model.sinkArn);
            clientRequestToken(model.clientRequestToken);
            chimeSdkMeetingConfiguration(model.chimeSdkMeetingConfiguration);
            tags(model.tags);
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(MediaPipelineSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getSinkType() {
            return sinkType;
        }

        public final void setSinkType(String sinkType) {
            this.sinkType = sinkType;
        }

        @Override
        public final Builder sinkType(String sinkType) {
            this.sinkType = sinkType;
            return this;
        }

        @Override
        public final Builder sinkType(MediaPipelineSinkType sinkType) {
            this.sinkType(sinkType == null ? null : sinkType.toString());
            return this;
        }

        public final String getSinkArn() {
            return sinkArn;
        }

        public final void setSinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
        }

        @Override
        public final Builder sinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final ChimeSdkMeetingConfiguration.Builder getChimeSdkMeetingConfiguration() {
            return chimeSdkMeetingConfiguration != null ? chimeSdkMeetingConfiguration.toBuilder() : null;
        }

        public final void setChimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration.BuilderImpl chimeSdkMeetingConfiguration) {
            this.chimeSdkMeetingConfiguration = chimeSdkMeetingConfiguration != null ? chimeSdkMeetingConfiguration.build()
                    : null;
        }

        @Override
        public final Builder chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration) {
            this.chimeSdkMeetingConfiguration = chimeSdkMeetingConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMediaCapturePipelineRequest build() {
            return new CreateMediaCapturePipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
