/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMediaCapturePipelinesResponse extends ChimeSdkMediaPipelinesResponse implements
        ToCopyableBuilder<ListMediaCapturePipelinesResponse.Builder, ListMediaCapturePipelinesResponse> {
    private static final SdkField<List<MediaCapturePipelineSummary>> MEDIA_CAPTURE_PIPELINES_FIELD = SdkField
            .<List<MediaCapturePipelineSummary>> builder(MarshallingType.LIST)
            .memberName("MediaCapturePipelines")
            .getter(getter(ListMediaCapturePipelinesResponse::mediaCapturePipelines))
            .setter(setter(Builder::mediaCapturePipelines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaCapturePipelines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaCapturePipelineSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaCapturePipelineSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMediaCapturePipelinesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_CAPTURE_PIPELINES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MediaCapturePipelineSummary> mediaCapturePipelines;

    private final String nextToken;

    private ListMediaCapturePipelinesResponse(BuilderImpl builder) {
        super(builder);
        this.mediaCapturePipelines = builder.mediaCapturePipelines;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaCapturePipelines property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMediaCapturePipelines() {
        return mediaCapturePipelines != null && !(mediaCapturePipelines instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The media pipeline objects in the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaCapturePipelines} method.
     * </p>
     * 
     * @return The media pipeline objects in the list.
     */
    public final List<MediaCapturePipelineSummary> mediaCapturePipelines() {
        return mediaCapturePipelines;
    }

    /**
     * <p>
     * The token used to retrieve the next page of results.
     * </p>
     * 
     * @return The token used to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaCapturePipelines() ? mediaCapturePipelines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMediaCapturePipelinesResponse)) {
            return false;
        }
        ListMediaCapturePipelinesResponse other = (ListMediaCapturePipelinesResponse) obj;
        return hasMediaCapturePipelines() == other.hasMediaCapturePipelines()
                && Objects.equals(mediaCapturePipelines(), other.mediaCapturePipelines())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMediaCapturePipelinesResponse")
                .add("MediaCapturePipelines", hasMediaCapturePipelines() ? mediaCapturePipelines() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaCapturePipelines":
            return Optional.ofNullable(clazz.cast(mediaCapturePipelines()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMediaCapturePipelinesResponse, T> g) {
        return obj -> g.apply((ListMediaCapturePipelinesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMediaPipelinesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMediaCapturePipelinesResponse> {
        /**
         * <p>
         * The media pipeline objects in the list.
         * </p>
         * 
         * @param mediaCapturePipelines
         *        The media pipeline objects in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaCapturePipelines(Collection<MediaCapturePipelineSummary> mediaCapturePipelines);

        /**
         * <p>
         * The media pipeline objects in the list.
         * </p>
         * 
         * @param mediaCapturePipelines
         *        The media pipeline objects in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaCapturePipelines(MediaCapturePipelineSummary... mediaCapturePipelines);

        /**
         * <p>
         * The media pipeline objects in the list.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <MediaCapturePipelineSummary>.Builder} avoiding the need to create one manually via {@link List
         * <MediaCapturePipelineSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MediaCapturePipelineSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #mediaCapturePipelines(List<MediaCapturePipelineSummary>)}.
         * 
         * @param mediaCapturePipelines
         *        a consumer that will call methods on {@link List<MediaCapturePipelineSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaCapturePipelines(List<MediaCapturePipelineSummary>)
         */
        Builder mediaCapturePipelines(Consumer<MediaCapturePipelineSummary.Builder>... mediaCapturePipelines);

        /**
         * <p>
         * The token used to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token used to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesResponse.BuilderImpl implements Builder {
        private List<MediaCapturePipelineSummary> mediaCapturePipelines = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMediaCapturePipelinesResponse model) {
            super(model);
            mediaCapturePipelines(model.mediaCapturePipelines);
            nextToken(model.nextToken);
        }

        public final List<MediaCapturePipelineSummary.Builder> getMediaCapturePipelines() {
            List<MediaCapturePipelineSummary.Builder> result = MediaCapturePipelineSummaryListCopier
                    .copyToBuilder(this.mediaCapturePipelines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaCapturePipelines(Collection<MediaCapturePipelineSummary.BuilderImpl> mediaCapturePipelines) {
            this.mediaCapturePipelines = MediaCapturePipelineSummaryListCopier.copyFromBuilder(mediaCapturePipelines);
        }

        @Override
        public final Builder mediaCapturePipelines(Collection<MediaCapturePipelineSummary> mediaCapturePipelines) {
            this.mediaCapturePipelines = MediaCapturePipelineSummaryListCopier.copy(mediaCapturePipelines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaCapturePipelines(MediaCapturePipelineSummary... mediaCapturePipelines) {
            mediaCapturePipelines(Arrays.asList(mediaCapturePipelines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaCapturePipelines(Consumer<MediaCapturePipelineSummary.Builder>... mediaCapturePipelines) {
            mediaCapturePipelines(Stream.of(mediaCapturePipelines)
                    .map(c -> MediaCapturePipelineSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMediaCapturePipelinesResponse build() {
            return new ListMediaCapturePipelinesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
