/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMediaPipelinesResponse extends ChimeSdkMediaPipelinesResponse implements
        ToCopyableBuilder<ListMediaPipelinesResponse.Builder, ListMediaPipelinesResponse> {
    private static final SdkField<List<MediaPipelineSummary>> MEDIA_PIPELINES_FIELD = SdkField
            .<List<MediaPipelineSummary>> builder(MarshallingType.LIST)
            .memberName("MediaPipelines")
            .getter(getter(ListMediaPipelinesResponse::mediaPipelines))
            .setter(setter(Builder::mediaPipelines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPipelines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaPipelineSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaPipelineSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMediaPipelinesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_PIPELINES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MediaPipelineSummary> mediaPipelines;

    private final String nextToken;

    private ListMediaPipelinesResponse(BuilderImpl builder) {
        super(builder);
        this.mediaPipelines = builder.mediaPipelines;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaPipelines property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMediaPipelines() {
        return mediaPipelines != null && !(mediaPipelines instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The media pipeline objects in the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaPipelines} method.
     * </p>
     * 
     * @return The media pipeline objects in the list.
     */
    public final List<MediaPipelineSummary> mediaPipelines() {
        return mediaPipelines;
    }

    /**
     * <p>
     * The token used to retrieve the next page of results.
     * </p>
     * 
     * @return The token used to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaPipelines() ? mediaPipelines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMediaPipelinesResponse)) {
            return false;
        }
        ListMediaPipelinesResponse other = (ListMediaPipelinesResponse) obj;
        return hasMediaPipelines() == other.hasMediaPipelines() && Objects.equals(mediaPipelines(), other.mediaPipelines())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMediaPipelinesResponse")
                .add("MediaPipelines", hasMediaPipelines() ? mediaPipelines() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaPipelines":
            return Optional.ofNullable(clazz.cast(mediaPipelines()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMediaPipelinesResponse, T> g) {
        return obj -> g.apply((ListMediaPipelinesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMediaPipelinesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMediaPipelinesResponse> {
        /**
         * <p>
         * The media pipeline objects in the list.
         * </p>
         * 
         * @param mediaPipelines
         *        The media pipeline objects in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPipelines(Collection<MediaPipelineSummary> mediaPipelines);

        /**
         * <p>
         * The media pipeline objects in the list.
         * </p>
         * 
         * @param mediaPipelines
         *        The media pipeline objects in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPipelines(MediaPipelineSummary... mediaPipelines);

        /**
         * <p>
         * The media pipeline objects in the list.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<MediaPipelineSummary>.Builder}
         * avoiding the need to create one manually via {@link List<MediaPipelineSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MediaPipelineSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #mediaPipelines(List<MediaPipelineSummary>)}.
         * 
         * @param mediaPipelines
         *        a consumer that will call methods on {@link List<MediaPipelineSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaPipelines(List<MediaPipelineSummary>)
         */
        Builder mediaPipelines(Consumer<MediaPipelineSummary.Builder>... mediaPipelines);

        /**
         * <p>
         * The token used to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token used to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesResponse.BuilderImpl implements Builder {
        private List<MediaPipelineSummary> mediaPipelines = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMediaPipelinesResponse model) {
            super(model);
            mediaPipelines(model.mediaPipelines);
            nextToken(model.nextToken);
        }

        public final List<MediaPipelineSummary.Builder> getMediaPipelines() {
            List<MediaPipelineSummary.Builder> result = MediaPipelineListCopier.copyToBuilder(this.mediaPipelines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaPipelines(Collection<MediaPipelineSummary.BuilderImpl> mediaPipelines) {
            this.mediaPipelines = MediaPipelineListCopier.copyFromBuilder(mediaPipelines);
        }

        @Override
        public final Builder mediaPipelines(Collection<MediaPipelineSummary> mediaPipelines) {
            this.mediaPipelines = MediaPipelineListCopier.copy(mediaPipelines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaPipelines(MediaPipelineSummary... mediaPipelines) {
            mediaPipelines(Arrays.asList(mediaPipelines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaPipelines(Consumer<MediaPipelineSummary.Builder>... mediaPipelines) {
            mediaPipelines(Stream.of(mediaPipelines).map(c -> MediaPipelineSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMediaPipelinesResponse build() {
            return new ListMediaPipelinesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
