/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data source configuration object of a streaming media pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LiveConnectorSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LiveConnectorSourceConfiguration.Builder, LiveConnectorSourceConfiguration> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(LiveConnectorSourceConfiguration::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<ChimeSdkMeetingLiveConnectorConfiguration> CHIME_SDK_MEETING_LIVE_CONNECTOR_CONFIGURATION_FIELD = SdkField
            .<ChimeSdkMeetingLiveConnectorConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ChimeSdkMeetingLiveConnectorConfiguration")
            .getter(getter(LiveConnectorSourceConfiguration::chimeSdkMeetingLiveConnectorConfiguration))
            .setter(setter(Builder::chimeSdkMeetingLiveConnectorConfiguration))
            .constructor(ChimeSdkMeetingLiveConnectorConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ChimeSdkMeetingLiveConnectorConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD,
            CHIME_SDK_MEETING_LIVE_CONNECTOR_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceType;

    private final ChimeSdkMeetingLiveConnectorConfiguration chimeSdkMeetingLiveConnectorConfiguration;

    private LiveConnectorSourceConfiguration(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.chimeSdkMeetingLiveConnectorConfiguration = builder.chimeSdkMeetingLiveConnectorConfiguration;
    }

    /**
     * <p>
     * The source configuration's media source type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link LiveConnectorSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The source configuration's media source type.
     * @see LiveConnectorSourceType
     */
    public final LiveConnectorSourceType sourceType() {
        return LiveConnectorSourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * The source configuration's media source type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link LiveConnectorSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The source configuration's media source type.
     * @see LiveConnectorSourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * <p>
     * The configuration settings of the connector pipeline.
     * </p>
     * 
     * @return The configuration settings of the connector pipeline.
     */
    public final ChimeSdkMeetingLiveConnectorConfiguration chimeSdkMeetingLiveConnectorConfiguration() {
        return chimeSdkMeetingLiveConnectorConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(chimeSdkMeetingLiveConnectorConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiveConnectorSourceConfiguration)) {
            return false;
        }
        LiveConnectorSourceConfiguration other = (LiveConnectorSourceConfiguration) obj;
        return Objects.equals(sourceTypeAsString(), other.sourceTypeAsString())
                && Objects.equals(chimeSdkMeetingLiveConnectorConfiguration(), other.chimeSdkMeetingLiveConnectorConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LiveConnectorSourceConfiguration").add("SourceType", sourceTypeAsString())
                .add("ChimeSdkMeetingLiveConnectorConfiguration", chimeSdkMeetingLiveConnectorConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "ChimeSdkMeetingLiveConnectorConfiguration":
            return Optional.ofNullable(clazz.cast(chimeSdkMeetingLiveConnectorConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LiveConnectorSourceConfiguration, T> g) {
        return obj -> g.apply((LiveConnectorSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LiveConnectorSourceConfiguration> {
        /**
         * <p>
         * The source configuration's media source type.
         * </p>
         * 
         * @param sourceType
         *        The source configuration's media source type.
         * @see LiveConnectorSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LiveConnectorSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The source configuration's media source type.
         * </p>
         * 
         * @param sourceType
         *        The source configuration's media source type.
         * @see LiveConnectorSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LiveConnectorSourceType
         */
        Builder sourceType(LiveConnectorSourceType sourceType);

        /**
         * <p>
         * The configuration settings of the connector pipeline.
         * </p>
         * 
         * @param chimeSdkMeetingLiveConnectorConfiguration
         *        The configuration settings of the connector pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chimeSdkMeetingLiveConnectorConfiguration(
                ChimeSdkMeetingLiveConnectorConfiguration chimeSdkMeetingLiveConnectorConfiguration);

        /**
         * <p>
         * The configuration settings of the connector pipeline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ChimeSdkMeetingLiveConnectorConfiguration.Builder} avoiding the need to create one manually via
         * {@link ChimeSdkMeetingLiveConnectorConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChimeSdkMeetingLiveConnectorConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #chimeSdkMeetingLiveConnectorConfiguration(ChimeSdkMeetingLiveConnectorConfiguration)}.
         * 
         * @param chimeSdkMeetingLiveConnectorConfiguration
         *        a consumer that will call methods on {@link ChimeSdkMeetingLiveConnectorConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chimeSdkMeetingLiveConnectorConfiguration(ChimeSdkMeetingLiveConnectorConfiguration)
         */
        default Builder chimeSdkMeetingLiveConnectorConfiguration(
                Consumer<ChimeSdkMeetingLiveConnectorConfiguration.Builder> chimeSdkMeetingLiveConnectorConfiguration) {
            return chimeSdkMeetingLiveConnectorConfiguration(ChimeSdkMeetingLiveConnectorConfiguration.builder()
                    .applyMutation(chimeSdkMeetingLiveConnectorConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sourceType;

        private ChimeSdkMeetingLiveConnectorConfiguration chimeSdkMeetingLiveConnectorConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(LiveConnectorSourceConfiguration model) {
            sourceType(model.sourceType);
            chimeSdkMeetingLiveConnectorConfiguration(model.chimeSdkMeetingLiveConnectorConfiguration);
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(LiveConnectorSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final ChimeSdkMeetingLiveConnectorConfiguration.Builder getChimeSdkMeetingLiveConnectorConfiguration() {
            return chimeSdkMeetingLiveConnectorConfiguration != null ? chimeSdkMeetingLiveConnectorConfiguration.toBuilder()
                    : null;
        }

        public final void setChimeSdkMeetingLiveConnectorConfiguration(
                ChimeSdkMeetingLiveConnectorConfiguration.BuilderImpl chimeSdkMeetingLiveConnectorConfiguration) {
            this.chimeSdkMeetingLiveConnectorConfiguration = chimeSdkMeetingLiveConnectorConfiguration != null ? chimeSdkMeetingLiveConnectorConfiguration
                    .build() : null;
        }

        @Override
        public final Builder chimeSdkMeetingLiveConnectorConfiguration(
                ChimeSdkMeetingLiveConnectorConfiguration chimeSdkMeetingLiveConnectorConfiguration) {
            this.chimeSdkMeetingLiveConnectorConfiguration = chimeSdkMeetingLiveConnectorConfiguration;
            return this;
        }

        @Override
        public LiveConnectorSourceConfiguration build() {
            return new LiveConnectorSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
