/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source configuration object of a media capture pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaCapturePipelineSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaCapturePipelineSourceConfiguration.Builder, MediaCapturePipelineSourceConfiguration> {
    private static final SdkField<String> MEDIA_PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaPipelineArn").getter(getter(MediaCapturePipelineSourceConfiguration::mediaPipelineArn))
            .setter(setter(Builder::mediaPipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPipelineArn").build()).build();

    private static final SdkField<ChimeSdkMeetingConcatenationConfiguration> CHIME_SDK_MEETING_CONFIGURATION_FIELD = SdkField
            .<ChimeSdkMeetingConcatenationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ChimeSdkMeetingConfiguration")
            .getter(getter(MediaCapturePipelineSourceConfiguration::chimeSdkMeetingConfiguration))
            .setter(setter(Builder::chimeSdkMeetingConfiguration))
            .constructor(ChimeSdkMeetingConcatenationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChimeSdkMeetingConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_PIPELINE_ARN_FIELD,
            CHIME_SDK_MEETING_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mediaPipelineArn;

    private final ChimeSdkMeetingConcatenationConfiguration chimeSdkMeetingConfiguration;

    private MediaCapturePipelineSourceConfiguration(BuilderImpl builder) {
        this.mediaPipelineArn = builder.mediaPipelineArn;
        this.chimeSdkMeetingConfiguration = builder.chimeSdkMeetingConfiguration;
    }

    /**
     * <p>
     * The media pipeline ARN in the configuration object of a media capture pipeline.
     * </p>
     * 
     * @return The media pipeline ARN in the configuration object of a media capture pipeline.
     */
    public final String mediaPipelineArn() {
        return mediaPipelineArn;
    }

    /**
     * <p>
     * The meeting configuration settings in a media capture pipeline configuration object.
     * </p>
     * 
     * @return The meeting configuration settings in a media capture pipeline configuration object.
     */
    public final ChimeSdkMeetingConcatenationConfiguration chimeSdkMeetingConfiguration() {
        return chimeSdkMeetingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mediaPipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(chimeSdkMeetingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaCapturePipelineSourceConfiguration)) {
            return false;
        }
        MediaCapturePipelineSourceConfiguration other = (MediaCapturePipelineSourceConfiguration) obj;
        return Objects.equals(mediaPipelineArn(), other.mediaPipelineArn())
                && Objects.equals(chimeSdkMeetingConfiguration(), other.chimeSdkMeetingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaCapturePipelineSourceConfiguration")
                .add("MediaPipelineArn", mediaPipelineArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ChimeSdkMeetingConfiguration", chimeSdkMeetingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaPipelineArn":
            return Optional.ofNullable(clazz.cast(mediaPipelineArn()));
        case "ChimeSdkMeetingConfiguration":
            return Optional.ofNullable(clazz.cast(chimeSdkMeetingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaCapturePipelineSourceConfiguration, T> g) {
        return obj -> g.apply((MediaCapturePipelineSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaCapturePipelineSourceConfiguration> {
        /**
         * <p>
         * The media pipeline ARN in the configuration object of a media capture pipeline.
         * </p>
         * 
         * @param mediaPipelineArn
         *        The media pipeline ARN in the configuration object of a media capture pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPipelineArn(String mediaPipelineArn);

        /**
         * <p>
         * The meeting configuration settings in a media capture pipeline configuration object.
         * </p>
         * 
         * @param chimeSdkMeetingConfiguration
         *        The meeting configuration settings in a media capture pipeline configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chimeSdkMeetingConfiguration(ChimeSdkMeetingConcatenationConfiguration chimeSdkMeetingConfiguration);

        /**
         * <p>
         * The meeting configuration settings in a media capture pipeline configuration object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ChimeSdkMeetingConcatenationConfiguration.Builder} avoiding the need to create one manually via
         * {@link ChimeSdkMeetingConcatenationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChimeSdkMeetingConcatenationConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #chimeSdkMeetingConfiguration(ChimeSdkMeetingConcatenationConfiguration)}.
         * 
         * @param chimeSdkMeetingConfiguration
         *        a consumer that will call methods on {@link ChimeSdkMeetingConcatenationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chimeSdkMeetingConfiguration(ChimeSdkMeetingConcatenationConfiguration)
         */
        default Builder chimeSdkMeetingConfiguration(
                Consumer<ChimeSdkMeetingConcatenationConfiguration.Builder> chimeSdkMeetingConfiguration) {
            return chimeSdkMeetingConfiguration(ChimeSdkMeetingConcatenationConfiguration.builder()
                    .applyMutation(chimeSdkMeetingConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String mediaPipelineArn;

        private ChimeSdkMeetingConcatenationConfiguration chimeSdkMeetingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaCapturePipelineSourceConfiguration model) {
            mediaPipelineArn(model.mediaPipelineArn);
            chimeSdkMeetingConfiguration(model.chimeSdkMeetingConfiguration);
        }

        public final String getMediaPipelineArn() {
            return mediaPipelineArn;
        }

        public final void setMediaPipelineArn(String mediaPipelineArn) {
            this.mediaPipelineArn = mediaPipelineArn;
        }

        @Override
        public final Builder mediaPipelineArn(String mediaPipelineArn) {
            this.mediaPipelineArn = mediaPipelineArn;
            return this;
        }

        public final ChimeSdkMeetingConcatenationConfiguration.Builder getChimeSdkMeetingConfiguration() {
            return chimeSdkMeetingConfiguration != null ? chimeSdkMeetingConfiguration.toBuilder() : null;
        }

        public final void setChimeSdkMeetingConfiguration(
                ChimeSdkMeetingConcatenationConfiguration.BuilderImpl chimeSdkMeetingConfiguration) {
            this.chimeSdkMeetingConfiguration = chimeSdkMeetingConfiguration != null ? chimeSdkMeetingConfiguration.build()
                    : null;
        }

        @Override
        public final Builder chimeSdkMeetingConfiguration(ChimeSdkMeetingConcatenationConfiguration chimeSdkMeetingConfiguration) {
            this.chimeSdkMeetingConfiguration = chimeSdkMeetingConfiguration;
            return this;
        }

        @Override
        public MediaCapturePipelineSourceConfiguration build() {
            return new MediaCapturePipelineSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
