/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMediaLiveConnectorPipelineResponse extends ChimeSdkMediaPipelinesResponse implements
        ToCopyableBuilder<CreateMediaLiveConnectorPipelineResponse.Builder, CreateMediaLiveConnectorPipelineResponse> {
    private static final SdkField<MediaLiveConnectorPipeline> MEDIA_LIVE_CONNECTOR_PIPELINE_FIELD = SdkField
            .<MediaLiveConnectorPipeline> builder(MarshallingType.SDK_POJO)
            .memberName("MediaLiveConnectorPipeline")
            .getter(getter(CreateMediaLiveConnectorPipelineResponse::mediaLiveConnectorPipeline))
            .setter(setter(Builder::mediaLiveConnectorPipeline))
            .constructor(MediaLiveConnectorPipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaLiveConnectorPipeline").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MEDIA_LIVE_CONNECTOR_PIPELINE_FIELD));

    private final MediaLiveConnectorPipeline mediaLiveConnectorPipeline;

    private CreateMediaLiveConnectorPipelineResponse(BuilderImpl builder) {
        super(builder);
        this.mediaLiveConnectorPipeline = builder.mediaLiveConnectorPipeline;
    }

    /**
     * <p>
     * The new media pipeline.
     * </p>
     * 
     * @return The new media pipeline.
     */
    public final MediaLiveConnectorPipeline mediaLiveConnectorPipeline() {
        return mediaLiveConnectorPipeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mediaLiveConnectorPipeline());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMediaLiveConnectorPipelineResponse)) {
            return false;
        }
        CreateMediaLiveConnectorPipelineResponse other = (CreateMediaLiveConnectorPipelineResponse) obj;
        return Objects.equals(mediaLiveConnectorPipeline(), other.mediaLiveConnectorPipeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMediaLiveConnectorPipelineResponse")
                .add("MediaLiveConnectorPipeline", mediaLiveConnectorPipeline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaLiveConnectorPipeline":
            return Optional.ofNullable(clazz.cast(mediaLiveConnectorPipeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMediaLiveConnectorPipelineResponse, T> g) {
        return obj -> g.apply((CreateMediaLiveConnectorPipelineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMediaPipelinesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMediaLiveConnectorPipelineResponse> {
        /**
         * <p>
         * The new media pipeline.
         * </p>
         * 
         * @param mediaLiveConnectorPipeline
         *        The new media pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaLiveConnectorPipeline(MediaLiveConnectorPipeline mediaLiveConnectorPipeline);

        /**
         * <p>
         * The new media pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaLiveConnectorPipeline.Builder}
         * avoiding the need to create one manually via {@link MediaLiveConnectorPipeline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaLiveConnectorPipeline.Builder#build()} is called immediately
         * and its result is passed to {@link #mediaLiveConnectorPipeline(MediaLiveConnectorPipeline)}.
         * 
         * @param mediaLiveConnectorPipeline
         *        a consumer that will call methods on {@link MediaLiveConnectorPipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaLiveConnectorPipeline(MediaLiveConnectorPipeline)
         */
        default Builder mediaLiveConnectorPipeline(Consumer<MediaLiveConnectorPipeline.Builder> mediaLiveConnectorPipeline) {
            return mediaLiveConnectorPipeline(MediaLiveConnectorPipeline.builder().applyMutation(mediaLiveConnectorPipeline)
                    .build());
        }
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesResponse.BuilderImpl implements Builder {
        private MediaLiveConnectorPipeline mediaLiveConnectorPipeline;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMediaLiveConnectorPipelineResponse model) {
            super(model);
            mediaLiveConnectorPipeline(model.mediaLiveConnectorPipeline);
        }

        public final MediaLiveConnectorPipeline.Builder getMediaLiveConnectorPipeline() {
            return mediaLiveConnectorPipeline != null ? mediaLiveConnectorPipeline.toBuilder() : null;
        }

        public final void setMediaLiveConnectorPipeline(MediaLiveConnectorPipeline.BuilderImpl mediaLiveConnectorPipeline) {
            this.mediaLiveConnectorPipeline = mediaLiveConnectorPipeline != null ? mediaLiveConnectorPipeline.build() : null;
        }

        @Override
        public final Builder mediaLiveConnectorPipeline(MediaLiveConnectorPipeline mediaLiveConnectorPipeline) {
            this.mediaLiveConnectorPipeline = mediaLiveConnectorPipeline;
            return this;
        }

        @Override
        public CreateMediaLiveConnectorPipelineResponse build() {
            return new CreateMediaLiveConnectorPipelineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
