/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the type of grid layout.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GridViewConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GridViewConfiguration.Builder, GridViewConfiguration> {
    private static final SdkField<String> CONTENT_SHARE_LAYOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentShareLayout").getter(getter(GridViewConfiguration::contentShareLayoutAsString))
            .setter(setter(Builder::contentShareLayout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentShareLayout").build())
            .build();

    private static final SdkField<PresenterOnlyConfiguration> PRESENTER_ONLY_CONFIGURATION_FIELD = SdkField
            .<PresenterOnlyConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("PresenterOnlyConfiguration")
            .getter(getter(GridViewConfiguration::presenterOnlyConfiguration))
            .setter(setter(Builder::presenterOnlyConfiguration))
            .constructor(PresenterOnlyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresenterOnlyConfiguration").build())
            .build();

    private static final SdkField<ActiveSpeakerOnlyConfiguration> ACTIVE_SPEAKER_ONLY_CONFIGURATION_FIELD = SdkField
            .<ActiveSpeakerOnlyConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ActiveSpeakerOnlyConfiguration")
            .getter(getter(GridViewConfiguration::activeSpeakerOnlyConfiguration))
            .setter(setter(Builder::activeSpeakerOnlyConfiguration))
            .constructor(ActiveSpeakerOnlyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveSpeakerOnlyConfiguration")
                    .build()).build();

    private static final SdkField<HorizontalLayoutConfiguration> HORIZONTAL_LAYOUT_CONFIGURATION_FIELD = SdkField
            .<HorizontalLayoutConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("HorizontalLayoutConfiguration")
            .getter(getter(GridViewConfiguration::horizontalLayoutConfiguration))
            .setter(setter(Builder::horizontalLayoutConfiguration))
            .constructor(HorizontalLayoutConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HorizontalLayoutConfiguration")
                    .build()).build();

    private static final SdkField<VerticalLayoutConfiguration> VERTICAL_LAYOUT_CONFIGURATION_FIELD = SdkField
            .<VerticalLayoutConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("VerticalLayoutConfiguration")
            .getter(getter(GridViewConfiguration::verticalLayoutConfiguration))
            .setter(setter(Builder::verticalLayoutConfiguration))
            .constructor(VerticalLayoutConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerticalLayoutConfiguration")
                    .build()).build();

    private static final SdkField<VideoAttribute> VIDEO_ATTRIBUTE_FIELD = SdkField
            .<VideoAttribute> builder(MarshallingType.SDK_POJO).memberName("VideoAttribute")
            .getter(getter(GridViewConfiguration::videoAttribute)).setter(setter(Builder::videoAttribute))
            .constructor(VideoAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoAttribute").build()).build();

    private static final SdkField<String> CANVAS_ORIENTATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CanvasOrientation").getter(getter(GridViewConfiguration::canvasOrientationAsString))
            .setter(setter(Builder::canvasOrientation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanvasOrientation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_SHARE_LAYOUT_FIELD,
            PRESENTER_ONLY_CONFIGURATION_FIELD, ACTIVE_SPEAKER_ONLY_CONFIGURATION_FIELD, HORIZONTAL_LAYOUT_CONFIGURATION_FIELD,
            VERTICAL_LAYOUT_CONFIGURATION_FIELD, VIDEO_ATTRIBUTE_FIELD, CANVAS_ORIENTATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contentShareLayout;

    private final PresenterOnlyConfiguration presenterOnlyConfiguration;

    private final ActiveSpeakerOnlyConfiguration activeSpeakerOnlyConfiguration;

    private final HorizontalLayoutConfiguration horizontalLayoutConfiguration;

    private final VerticalLayoutConfiguration verticalLayoutConfiguration;

    private final VideoAttribute videoAttribute;

    private final String canvasOrientation;

    private GridViewConfiguration(BuilderImpl builder) {
        this.contentShareLayout = builder.contentShareLayout;
        this.presenterOnlyConfiguration = builder.presenterOnlyConfiguration;
        this.activeSpeakerOnlyConfiguration = builder.activeSpeakerOnlyConfiguration;
        this.horizontalLayoutConfiguration = builder.horizontalLayoutConfiguration;
        this.verticalLayoutConfiguration = builder.verticalLayoutConfiguration;
        this.videoAttribute = builder.videoAttribute;
        this.canvasOrientation = builder.canvasOrientation;
    }

    /**
     * <p>
     * Defines the layout of the video tiles when content sharing is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentShareLayout} will return {@link ContentShareLayoutOption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #contentShareLayoutAsString}.
     * </p>
     * 
     * @return Defines the layout of the video tiles when content sharing is enabled.
     * @see ContentShareLayoutOption
     */
    public final ContentShareLayoutOption contentShareLayout() {
        return ContentShareLayoutOption.fromValue(contentShareLayout);
    }

    /**
     * <p>
     * Defines the layout of the video tiles when content sharing is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentShareLayout} will return {@link ContentShareLayoutOption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #contentShareLayoutAsString}.
     * </p>
     * 
     * @return Defines the layout of the video tiles when content sharing is enabled.
     * @see ContentShareLayoutOption
     */
    public final String contentShareLayoutAsString() {
        return contentShareLayout;
    }

    /**
     * <p>
     * Defines the configuration options for a presenter only video tile.
     * </p>
     * 
     * @return Defines the configuration options for a presenter only video tile.
     */
    public final PresenterOnlyConfiguration presenterOnlyConfiguration() {
        return presenterOnlyConfiguration;
    }

    /**
     * <p>
     * The configuration settings for an <code>ActiveSpeakerOnly</code> video tile.
     * </p>
     * 
     * @return The configuration settings for an <code>ActiveSpeakerOnly</code> video tile.
     */
    public final ActiveSpeakerOnlyConfiguration activeSpeakerOnlyConfiguration() {
        return activeSpeakerOnlyConfiguration;
    }

    /**
     * <p>
     * The configuration settings for a horizontal layout.
     * </p>
     * 
     * @return The configuration settings for a horizontal layout.
     */
    public final HorizontalLayoutConfiguration horizontalLayoutConfiguration() {
        return horizontalLayoutConfiguration;
    }

    /**
     * <p>
     * The configuration settings for a vertical layout.
     * </p>
     * 
     * @return The configuration settings for a vertical layout.
     */
    public final VerticalLayoutConfiguration verticalLayoutConfiguration() {
        return verticalLayoutConfiguration;
    }

    /**
     * <p>
     * The attribute settings for the video tiles.
     * </p>
     * 
     * @return The attribute settings for the video tiles.
     */
    public final VideoAttribute videoAttribute() {
        return videoAttribute;
    }

    /**
     * <p>
     * The orientation setting, horizontal or vertical.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #canvasOrientation}
     * will return {@link CanvasOrientation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #canvasOrientationAsString}.
     * </p>
     * 
     * @return The orientation setting, horizontal or vertical.
     * @see CanvasOrientation
     */
    public final CanvasOrientation canvasOrientation() {
        return CanvasOrientation.fromValue(canvasOrientation);
    }

    /**
     * <p>
     * The orientation setting, horizontal or vertical.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #canvasOrientation}
     * will return {@link CanvasOrientation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #canvasOrientationAsString}.
     * </p>
     * 
     * @return The orientation setting, horizontal or vertical.
     * @see CanvasOrientation
     */
    public final String canvasOrientationAsString() {
        return canvasOrientation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentShareLayoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(presenterOnlyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(activeSpeakerOnlyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(horizontalLayoutConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(verticalLayoutConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(videoAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(canvasOrientationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GridViewConfiguration)) {
            return false;
        }
        GridViewConfiguration other = (GridViewConfiguration) obj;
        return Objects.equals(contentShareLayoutAsString(), other.contentShareLayoutAsString())
                && Objects.equals(presenterOnlyConfiguration(), other.presenterOnlyConfiguration())
                && Objects.equals(activeSpeakerOnlyConfiguration(), other.activeSpeakerOnlyConfiguration())
                && Objects.equals(horizontalLayoutConfiguration(), other.horizontalLayoutConfiguration())
                && Objects.equals(verticalLayoutConfiguration(), other.verticalLayoutConfiguration())
                && Objects.equals(videoAttribute(), other.videoAttribute())
                && Objects.equals(canvasOrientationAsString(), other.canvasOrientationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GridViewConfiguration").add("ContentShareLayout", contentShareLayoutAsString())
                .add("PresenterOnlyConfiguration", presenterOnlyConfiguration())
                .add("ActiveSpeakerOnlyConfiguration", activeSpeakerOnlyConfiguration())
                .add("HorizontalLayoutConfiguration", horizontalLayoutConfiguration())
                .add("VerticalLayoutConfiguration", verticalLayoutConfiguration()).add("VideoAttribute", videoAttribute())
                .add("CanvasOrientation", canvasOrientationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentShareLayout":
            return Optional.ofNullable(clazz.cast(contentShareLayoutAsString()));
        case "PresenterOnlyConfiguration":
            return Optional.ofNullable(clazz.cast(presenterOnlyConfiguration()));
        case "ActiveSpeakerOnlyConfiguration":
            return Optional.ofNullable(clazz.cast(activeSpeakerOnlyConfiguration()));
        case "HorizontalLayoutConfiguration":
            return Optional.ofNullable(clazz.cast(horizontalLayoutConfiguration()));
        case "VerticalLayoutConfiguration":
            return Optional.ofNullable(clazz.cast(verticalLayoutConfiguration()));
        case "VideoAttribute":
            return Optional.ofNullable(clazz.cast(videoAttribute()));
        case "CanvasOrientation":
            return Optional.ofNullable(clazz.cast(canvasOrientationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GridViewConfiguration, T> g) {
        return obj -> g.apply((GridViewConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GridViewConfiguration> {
        /**
         * <p>
         * Defines the layout of the video tiles when content sharing is enabled.
         * </p>
         * 
         * @param contentShareLayout
         *        Defines the layout of the video tiles when content sharing is enabled.
         * @see ContentShareLayoutOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentShareLayoutOption
         */
        Builder contentShareLayout(String contentShareLayout);

        /**
         * <p>
         * Defines the layout of the video tiles when content sharing is enabled.
         * </p>
         * 
         * @param contentShareLayout
         *        Defines the layout of the video tiles when content sharing is enabled.
         * @see ContentShareLayoutOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentShareLayoutOption
         */
        Builder contentShareLayout(ContentShareLayoutOption contentShareLayout);

        /**
         * <p>
         * Defines the configuration options for a presenter only video tile.
         * </p>
         * 
         * @param presenterOnlyConfiguration
         *        Defines the configuration options for a presenter only video tile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presenterOnlyConfiguration(PresenterOnlyConfiguration presenterOnlyConfiguration);

        /**
         * <p>
         * Defines the configuration options for a presenter only video tile.
         * </p>
         * This is a convenience method that creates an instance of the {@link PresenterOnlyConfiguration.Builder}
         * avoiding the need to create one manually via {@link PresenterOnlyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PresenterOnlyConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #presenterOnlyConfiguration(PresenterOnlyConfiguration)}.
         * 
         * @param presenterOnlyConfiguration
         *        a consumer that will call methods on {@link PresenterOnlyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #presenterOnlyConfiguration(PresenterOnlyConfiguration)
         */
        default Builder presenterOnlyConfiguration(Consumer<PresenterOnlyConfiguration.Builder> presenterOnlyConfiguration) {
            return presenterOnlyConfiguration(PresenterOnlyConfiguration.builder().applyMutation(presenterOnlyConfiguration)
                    .build());
        }

        /**
         * <p>
         * The configuration settings for an <code>ActiveSpeakerOnly</code> video tile.
         * </p>
         * 
         * @param activeSpeakerOnlyConfiguration
         *        The configuration settings for an <code>ActiveSpeakerOnly</code> video tile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeSpeakerOnlyConfiguration(ActiveSpeakerOnlyConfiguration activeSpeakerOnlyConfiguration);

        /**
         * <p>
         * The configuration settings for an <code>ActiveSpeakerOnly</code> video tile.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActiveSpeakerOnlyConfiguration.Builder}
         * avoiding the need to create one manually via {@link ActiveSpeakerOnlyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActiveSpeakerOnlyConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #activeSpeakerOnlyConfiguration(ActiveSpeakerOnlyConfiguration)}.
         * 
         * @param activeSpeakerOnlyConfiguration
         *        a consumer that will call methods on {@link ActiveSpeakerOnlyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeSpeakerOnlyConfiguration(ActiveSpeakerOnlyConfiguration)
         */
        default Builder activeSpeakerOnlyConfiguration(
                Consumer<ActiveSpeakerOnlyConfiguration.Builder> activeSpeakerOnlyConfiguration) {
            return activeSpeakerOnlyConfiguration(ActiveSpeakerOnlyConfiguration.builder()
                    .applyMutation(activeSpeakerOnlyConfiguration).build());
        }

        /**
         * <p>
         * The configuration settings for a horizontal layout.
         * </p>
         * 
         * @param horizontalLayoutConfiguration
         *        The configuration settings for a horizontal layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder horizontalLayoutConfiguration(HorizontalLayoutConfiguration horizontalLayoutConfiguration);

        /**
         * <p>
         * The configuration settings for a horizontal layout.
         * </p>
         * This is a convenience method that creates an instance of the {@link HorizontalLayoutConfiguration.Builder}
         * avoiding the need to create one manually via {@link HorizontalLayoutConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HorizontalLayoutConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #horizontalLayoutConfiguration(HorizontalLayoutConfiguration)}.
         * 
         * @param horizontalLayoutConfiguration
         *        a consumer that will call methods on {@link HorizontalLayoutConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #horizontalLayoutConfiguration(HorizontalLayoutConfiguration)
         */
        default Builder horizontalLayoutConfiguration(
                Consumer<HorizontalLayoutConfiguration.Builder> horizontalLayoutConfiguration) {
            return horizontalLayoutConfiguration(HorizontalLayoutConfiguration.builder()
                    .applyMutation(horizontalLayoutConfiguration).build());
        }

        /**
         * <p>
         * The configuration settings for a vertical layout.
         * </p>
         * 
         * @param verticalLayoutConfiguration
         *        The configuration settings for a vertical layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verticalLayoutConfiguration(VerticalLayoutConfiguration verticalLayoutConfiguration);

        /**
         * <p>
         * The configuration settings for a vertical layout.
         * </p>
         * This is a convenience method that creates an instance of the {@link VerticalLayoutConfiguration.Builder}
         * avoiding the need to create one manually via {@link VerticalLayoutConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerticalLayoutConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #verticalLayoutConfiguration(VerticalLayoutConfiguration)}.
         * 
         * @param verticalLayoutConfiguration
         *        a consumer that will call methods on {@link VerticalLayoutConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verticalLayoutConfiguration(VerticalLayoutConfiguration)
         */
        default Builder verticalLayoutConfiguration(Consumer<VerticalLayoutConfiguration.Builder> verticalLayoutConfiguration) {
            return verticalLayoutConfiguration(VerticalLayoutConfiguration.builder().applyMutation(verticalLayoutConfiguration)
                    .build());
        }

        /**
         * <p>
         * The attribute settings for the video tiles.
         * </p>
         * 
         * @param videoAttribute
         *        The attribute settings for the video tiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoAttribute(VideoAttribute videoAttribute);

        /**
         * <p>
         * The attribute settings for the video tiles.
         * </p>
         * This is a convenience method that creates an instance of the {@link VideoAttribute.Builder} avoiding the need
         * to create one manually via {@link VideoAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #videoAttribute(VideoAttribute)}.
         * 
         * @param videoAttribute
         *        a consumer that will call methods on {@link VideoAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoAttribute(VideoAttribute)
         */
        default Builder videoAttribute(Consumer<VideoAttribute.Builder> videoAttribute) {
            return videoAttribute(VideoAttribute.builder().applyMutation(videoAttribute).build());
        }

        /**
         * <p>
         * The orientation setting, horizontal or vertical.
         * </p>
         * 
         * @param canvasOrientation
         *        The orientation setting, horizontal or vertical.
         * @see CanvasOrientation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CanvasOrientation
         */
        Builder canvasOrientation(String canvasOrientation);

        /**
         * <p>
         * The orientation setting, horizontal or vertical.
         * </p>
         * 
         * @param canvasOrientation
         *        The orientation setting, horizontal or vertical.
         * @see CanvasOrientation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CanvasOrientation
         */
        Builder canvasOrientation(CanvasOrientation canvasOrientation);
    }

    static final class BuilderImpl implements Builder {
        private String contentShareLayout;

        private PresenterOnlyConfiguration presenterOnlyConfiguration;

        private ActiveSpeakerOnlyConfiguration activeSpeakerOnlyConfiguration;

        private HorizontalLayoutConfiguration horizontalLayoutConfiguration;

        private VerticalLayoutConfiguration verticalLayoutConfiguration;

        private VideoAttribute videoAttribute;

        private String canvasOrientation;

        private BuilderImpl() {
        }

        private BuilderImpl(GridViewConfiguration model) {
            contentShareLayout(model.contentShareLayout);
            presenterOnlyConfiguration(model.presenterOnlyConfiguration);
            activeSpeakerOnlyConfiguration(model.activeSpeakerOnlyConfiguration);
            horizontalLayoutConfiguration(model.horizontalLayoutConfiguration);
            verticalLayoutConfiguration(model.verticalLayoutConfiguration);
            videoAttribute(model.videoAttribute);
            canvasOrientation(model.canvasOrientation);
        }

        public final String getContentShareLayout() {
            return contentShareLayout;
        }

        public final void setContentShareLayout(String contentShareLayout) {
            this.contentShareLayout = contentShareLayout;
        }

        @Override
        public final Builder contentShareLayout(String contentShareLayout) {
            this.contentShareLayout = contentShareLayout;
            return this;
        }

        @Override
        public final Builder contentShareLayout(ContentShareLayoutOption contentShareLayout) {
            this.contentShareLayout(contentShareLayout == null ? null : contentShareLayout.toString());
            return this;
        }

        public final PresenterOnlyConfiguration.Builder getPresenterOnlyConfiguration() {
            return presenterOnlyConfiguration != null ? presenterOnlyConfiguration.toBuilder() : null;
        }

        public final void setPresenterOnlyConfiguration(PresenterOnlyConfiguration.BuilderImpl presenterOnlyConfiguration) {
            this.presenterOnlyConfiguration = presenterOnlyConfiguration != null ? presenterOnlyConfiguration.build() : null;
        }

        @Override
        public final Builder presenterOnlyConfiguration(PresenterOnlyConfiguration presenterOnlyConfiguration) {
            this.presenterOnlyConfiguration = presenterOnlyConfiguration;
            return this;
        }

        public final ActiveSpeakerOnlyConfiguration.Builder getActiveSpeakerOnlyConfiguration() {
            return activeSpeakerOnlyConfiguration != null ? activeSpeakerOnlyConfiguration.toBuilder() : null;
        }

        public final void setActiveSpeakerOnlyConfiguration(
                ActiveSpeakerOnlyConfiguration.BuilderImpl activeSpeakerOnlyConfiguration) {
            this.activeSpeakerOnlyConfiguration = activeSpeakerOnlyConfiguration != null ? activeSpeakerOnlyConfiguration.build()
                    : null;
        }

        @Override
        public final Builder activeSpeakerOnlyConfiguration(ActiveSpeakerOnlyConfiguration activeSpeakerOnlyConfiguration) {
            this.activeSpeakerOnlyConfiguration = activeSpeakerOnlyConfiguration;
            return this;
        }

        public final HorizontalLayoutConfiguration.Builder getHorizontalLayoutConfiguration() {
            return horizontalLayoutConfiguration != null ? horizontalLayoutConfiguration.toBuilder() : null;
        }

        public final void setHorizontalLayoutConfiguration(HorizontalLayoutConfiguration.BuilderImpl horizontalLayoutConfiguration) {
            this.horizontalLayoutConfiguration = horizontalLayoutConfiguration != null ? horizontalLayoutConfiguration.build()
                    : null;
        }

        @Override
        public final Builder horizontalLayoutConfiguration(HorizontalLayoutConfiguration horizontalLayoutConfiguration) {
            this.horizontalLayoutConfiguration = horizontalLayoutConfiguration;
            return this;
        }

        public final VerticalLayoutConfiguration.Builder getVerticalLayoutConfiguration() {
            return verticalLayoutConfiguration != null ? verticalLayoutConfiguration.toBuilder() : null;
        }

        public final void setVerticalLayoutConfiguration(VerticalLayoutConfiguration.BuilderImpl verticalLayoutConfiguration) {
            this.verticalLayoutConfiguration = verticalLayoutConfiguration != null ? verticalLayoutConfiguration.build() : null;
        }

        @Override
        public final Builder verticalLayoutConfiguration(VerticalLayoutConfiguration verticalLayoutConfiguration) {
            this.verticalLayoutConfiguration = verticalLayoutConfiguration;
            return this;
        }

        public final VideoAttribute.Builder getVideoAttribute() {
            return videoAttribute != null ? videoAttribute.toBuilder() : null;
        }

        public final void setVideoAttribute(VideoAttribute.BuilderImpl videoAttribute) {
            this.videoAttribute = videoAttribute != null ? videoAttribute.build() : null;
        }

        @Override
        public final Builder videoAttribute(VideoAttribute videoAttribute) {
            this.videoAttribute = videoAttribute;
            return this;
        }

        public final String getCanvasOrientation() {
            return canvasOrientation;
        }

        public final void setCanvasOrientation(String canvasOrientation) {
            this.canvasOrientation = canvasOrientation;
        }

        @Override
        public final Builder canvasOrientation(String canvasOrientation) {
            this.canvasOrientation = canvasOrientation;
            return this;
        }

        @Override
        public final Builder canvasOrientation(CanvasOrientation canvasOrientation) {
            this.canvasOrientation(canvasOrientation == null ? null : canvasOrientation.toString());
            return this;
        }

        @Override
        public GridViewConfiguration build() {
            return new GridViewConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
