/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsRuntimeMetadataCopier;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineStatus;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaInsightsPipeline
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaInsightsPipeline> {
    private static final SdkField<String> MEDIA_PIPELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaPipelineId").getter(MediaInsightsPipeline.getter(MediaInsightsPipeline::mediaPipelineId)).setter(MediaInsightsPipeline.setter(Builder::mediaPipelineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPipelineId").build()}).build();
    private static final SdkField<String> MEDIA_PIPELINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaPipelineArn").getter(MediaInsightsPipeline.getter(MediaInsightsPipeline::mediaPipelineArn)).setter(MediaInsightsPipeline.setter(Builder::mediaPipelineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPipelineArn").build()}).build();
    private static final SdkField<String> MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaInsightsPipelineConfigurationArn").getter(MediaInsightsPipeline.getter(MediaInsightsPipeline::mediaInsightsPipelineConfigurationArn)).setter(MediaInsightsPipeline.setter(Builder::mediaInsightsPipelineConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaInsightsPipelineConfigurationArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(MediaInsightsPipeline.getter(MediaInsightsPipeline::statusAsString)).setter(MediaInsightsPipeline.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<KinesisVideoStreamSourceRuntimeConfiguration> KINESIS_VIDEO_STREAM_SOURCE_RUNTIME_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisVideoStreamSourceRuntimeConfiguration").getter(MediaInsightsPipeline.getter(MediaInsightsPipeline::kinesisVideoStreamSourceRuntimeConfiguration)).setter(MediaInsightsPipeline.setter(Builder::kinesisVideoStreamSourceRuntimeConfiguration)).constructor(KinesisVideoStreamSourceRuntimeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisVideoStreamSourceRuntimeConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> MEDIA_INSIGHTS_RUNTIME_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("MediaInsightsRuntimeMetadata").getter(MediaInsightsPipeline.getter(MediaInsightsPipeline::mediaInsightsRuntimeMetadata)).setter(MediaInsightsPipeline.setter(Builder::mediaInsightsRuntimeMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaInsightsRuntimeMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<KinesisVideoStreamRecordingSourceRuntimeConfiguration> KINESIS_VIDEO_STREAM_RECORDING_SOURCE_RUNTIME_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisVideoStreamRecordingSourceRuntimeConfiguration").getter(MediaInsightsPipeline.getter(MediaInsightsPipeline::kinesisVideoStreamRecordingSourceRuntimeConfiguration)).setter(MediaInsightsPipeline.setter(Builder::kinesisVideoStreamRecordingSourceRuntimeConfiguration)).constructor(KinesisVideoStreamRecordingSourceRuntimeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisVideoStreamRecordingSourceRuntimeConfiguration").build()}).build();
    private static final SdkField<S3RecordingSinkRuntimeConfiguration> S3_RECORDING_SINK_RUNTIME_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3RecordingSinkRuntimeConfiguration").getter(MediaInsightsPipeline.getter(MediaInsightsPipeline::s3RecordingSinkRuntimeConfiguration)).setter(MediaInsightsPipeline.setter(Builder::s3RecordingSinkRuntimeConfiguration)).constructor(S3RecordingSinkRuntimeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3RecordingSinkRuntimeConfiguration").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(MediaInsightsPipeline.getter(MediaInsightsPipeline::createdTimestamp)).setter(MediaInsightsPipeline.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_PIPELINE_ID_FIELD, MEDIA_PIPELINE_ARN_FIELD, MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ARN_FIELD, STATUS_FIELD, KINESIS_VIDEO_STREAM_SOURCE_RUNTIME_CONFIGURATION_FIELD, MEDIA_INSIGHTS_RUNTIME_METADATA_FIELD, KINESIS_VIDEO_STREAM_RECORDING_SOURCE_RUNTIME_CONFIGURATION_FIELD, S3_RECORDING_SINK_RUNTIME_CONFIGURATION_FIELD, CREATED_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mediaPipelineId;
    private final String mediaPipelineArn;
    private final String mediaInsightsPipelineConfigurationArn;
    private final String status;
    private final KinesisVideoStreamSourceRuntimeConfiguration kinesisVideoStreamSourceRuntimeConfiguration;
    private final Map<String, String> mediaInsightsRuntimeMetadata;
    private final KinesisVideoStreamRecordingSourceRuntimeConfiguration kinesisVideoStreamRecordingSourceRuntimeConfiguration;
    private final S3RecordingSinkRuntimeConfiguration s3RecordingSinkRuntimeConfiguration;
    private final Instant createdTimestamp;

    private MediaInsightsPipeline(BuilderImpl builder) {
        this.mediaPipelineId = builder.mediaPipelineId;
        this.mediaPipelineArn = builder.mediaPipelineArn;
        this.mediaInsightsPipelineConfigurationArn = builder.mediaInsightsPipelineConfigurationArn;
        this.status = builder.status;
        this.kinesisVideoStreamSourceRuntimeConfiguration = builder.kinesisVideoStreamSourceRuntimeConfiguration;
        this.mediaInsightsRuntimeMetadata = builder.mediaInsightsRuntimeMetadata;
        this.kinesisVideoStreamRecordingSourceRuntimeConfiguration = builder.kinesisVideoStreamRecordingSourceRuntimeConfiguration;
        this.s3RecordingSinkRuntimeConfiguration = builder.s3RecordingSinkRuntimeConfiguration;
        this.createdTimestamp = builder.createdTimestamp;
    }

    public final String mediaPipelineId() {
        return this.mediaPipelineId;
    }

    public final String mediaPipelineArn() {
        return this.mediaPipelineArn;
    }

    public final String mediaInsightsPipelineConfigurationArn() {
        return this.mediaInsightsPipelineConfigurationArn;
    }

    public final MediaPipelineStatus status() {
        return MediaPipelineStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final KinesisVideoStreamSourceRuntimeConfiguration kinesisVideoStreamSourceRuntimeConfiguration() {
        return this.kinesisVideoStreamSourceRuntimeConfiguration;
    }

    public final boolean hasMediaInsightsRuntimeMetadata() {
        return this.mediaInsightsRuntimeMetadata != null && !(this.mediaInsightsRuntimeMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> mediaInsightsRuntimeMetadata() {
        return this.mediaInsightsRuntimeMetadata;
    }

    public final KinesisVideoStreamRecordingSourceRuntimeConfiguration kinesisVideoStreamRecordingSourceRuntimeConfiguration() {
        return this.kinesisVideoStreamRecordingSourceRuntimeConfiguration;
    }

    public final S3RecordingSinkRuntimeConfiguration s3RecordingSinkRuntimeConfiguration() {
        return this.s3RecordingSinkRuntimeConfiguration;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaPipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaPipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaInsightsPipelineConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisVideoStreamSourceRuntimeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaInsightsRuntimeMetadata() ? this.mediaInsightsRuntimeMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisVideoStreamRecordingSourceRuntimeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3RecordingSinkRuntimeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaInsightsPipeline)) {
            return false;
        }
        MediaInsightsPipeline other = (MediaInsightsPipeline)obj;
        return Objects.equals(this.mediaPipelineId(), other.mediaPipelineId()) && Objects.equals(this.mediaPipelineArn(), other.mediaPipelineArn()) && Objects.equals(this.mediaInsightsPipelineConfigurationArn(), other.mediaInsightsPipelineConfigurationArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.kinesisVideoStreamSourceRuntimeConfiguration(), other.kinesisVideoStreamSourceRuntimeConfiguration()) && this.hasMediaInsightsRuntimeMetadata() == other.hasMediaInsightsRuntimeMetadata() && Objects.equals(this.mediaInsightsRuntimeMetadata(), other.mediaInsightsRuntimeMetadata()) && Objects.equals(this.kinesisVideoStreamRecordingSourceRuntimeConfiguration(), other.kinesisVideoStreamRecordingSourceRuntimeConfiguration()) && Objects.equals(this.s3RecordingSinkRuntimeConfiguration(), other.s3RecordingSinkRuntimeConfiguration()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"MediaInsightsPipeline").add("MediaPipelineId", (Object)this.mediaPipelineId()).add("MediaPipelineArn", (Object)(this.mediaPipelineArn() == null ? null : "*** Sensitive Data Redacted ***")).add("MediaInsightsPipelineConfigurationArn", (Object)(this.mediaInsightsPipelineConfigurationArn() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("KinesisVideoStreamSourceRuntimeConfiguration", (Object)this.kinesisVideoStreamSourceRuntimeConfiguration()).add("MediaInsightsRuntimeMetadata", (Object)(this.mediaInsightsRuntimeMetadata() == null ? null : "*** Sensitive Data Redacted ***")).add("KinesisVideoStreamRecordingSourceRuntimeConfiguration", (Object)this.kinesisVideoStreamRecordingSourceRuntimeConfiguration()).add("S3RecordingSinkRuntimeConfiguration", (Object)this.s3RecordingSinkRuntimeConfiguration()).add("CreatedTimestamp", (Object)this.createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaPipelineId": {
                return Optional.ofNullable(clazz.cast(this.mediaPipelineId()));
            }
            case "MediaPipelineArn": {
                return Optional.ofNullable(clazz.cast(this.mediaPipelineArn()));
            }
            case "MediaInsightsPipelineConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.mediaInsightsPipelineConfigurationArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "KinesisVideoStreamSourceRuntimeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.kinesisVideoStreamSourceRuntimeConfiguration()));
            }
            case "MediaInsightsRuntimeMetadata": {
                return Optional.ofNullable(clazz.cast(this.mediaInsightsRuntimeMetadata()));
            }
            case "KinesisVideoStreamRecordingSourceRuntimeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.kinesisVideoStreamRecordingSourceRuntimeConfiguration()));
            }
            case "S3RecordingSinkRuntimeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3RecordingSinkRuntimeConfiguration()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaInsightsPipeline, T> g) {
        return obj -> g.apply((MediaInsightsPipeline)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mediaPipelineId;
        private String mediaPipelineArn;
        private String mediaInsightsPipelineConfigurationArn;
        private String status;
        private KinesisVideoStreamSourceRuntimeConfiguration kinesisVideoStreamSourceRuntimeConfiguration;
        private Map<String, String> mediaInsightsRuntimeMetadata = DefaultSdkAutoConstructMap.getInstance();
        private KinesisVideoStreamRecordingSourceRuntimeConfiguration kinesisVideoStreamRecordingSourceRuntimeConfiguration;
        private S3RecordingSinkRuntimeConfiguration s3RecordingSinkRuntimeConfiguration;
        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaInsightsPipeline model) {
            this.mediaPipelineId(model.mediaPipelineId);
            this.mediaPipelineArn(model.mediaPipelineArn);
            this.mediaInsightsPipelineConfigurationArn(model.mediaInsightsPipelineConfigurationArn);
            this.status(model.status);
            this.kinesisVideoStreamSourceRuntimeConfiguration(model.kinesisVideoStreamSourceRuntimeConfiguration);
            this.mediaInsightsRuntimeMetadata(model.mediaInsightsRuntimeMetadata);
            this.kinesisVideoStreamRecordingSourceRuntimeConfiguration(model.kinesisVideoStreamRecordingSourceRuntimeConfiguration);
            this.s3RecordingSinkRuntimeConfiguration(model.s3RecordingSinkRuntimeConfiguration);
            this.createdTimestamp(model.createdTimestamp);
        }

        public final String getMediaPipelineId() {
            return this.mediaPipelineId;
        }

        public final void setMediaPipelineId(String mediaPipelineId) {
            this.mediaPipelineId = mediaPipelineId;
        }

        @Override
        public final Builder mediaPipelineId(String mediaPipelineId) {
            this.mediaPipelineId = mediaPipelineId;
            return this;
        }

        public final String getMediaPipelineArn() {
            return this.mediaPipelineArn;
        }

        public final void setMediaPipelineArn(String mediaPipelineArn) {
            this.mediaPipelineArn = mediaPipelineArn;
        }

        @Override
        public final Builder mediaPipelineArn(String mediaPipelineArn) {
            this.mediaPipelineArn = mediaPipelineArn;
            return this;
        }

        public final String getMediaInsightsPipelineConfigurationArn() {
            return this.mediaInsightsPipelineConfigurationArn;
        }

        public final void setMediaInsightsPipelineConfigurationArn(String mediaInsightsPipelineConfigurationArn) {
            this.mediaInsightsPipelineConfigurationArn = mediaInsightsPipelineConfigurationArn;
        }

        @Override
        public final Builder mediaInsightsPipelineConfigurationArn(String mediaInsightsPipelineConfigurationArn) {
            this.mediaInsightsPipelineConfigurationArn = mediaInsightsPipelineConfigurationArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MediaPipelineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final KinesisVideoStreamSourceRuntimeConfiguration.Builder getKinesisVideoStreamSourceRuntimeConfiguration() {
            return this.kinesisVideoStreamSourceRuntimeConfiguration != null ? this.kinesisVideoStreamSourceRuntimeConfiguration.toBuilder() : null;
        }

        public final void setKinesisVideoStreamSourceRuntimeConfiguration(KinesisVideoStreamSourceRuntimeConfiguration.BuilderImpl kinesisVideoStreamSourceRuntimeConfiguration) {
            this.kinesisVideoStreamSourceRuntimeConfiguration = kinesisVideoStreamSourceRuntimeConfiguration != null ? kinesisVideoStreamSourceRuntimeConfiguration.build() : null;
        }

        @Override
        public final Builder kinesisVideoStreamSourceRuntimeConfiguration(KinesisVideoStreamSourceRuntimeConfiguration kinesisVideoStreamSourceRuntimeConfiguration) {
            this.kinesisVideoStreamSourceRuntimeConfiguration = kinesisVideoStreamSourceRuntimeConfiguration;
            return this;
        }

        public final Map<String, String> getMediaInsightsRuntimeMetadata() {
            if (this.mediaInsightsRuntimeMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.mediaInsightsRuntimeMetadata;
        }

        public final void setMediaInsightsRuntimeMetadata(Map<String, String> mediaInsightsRuntimeMetadata) {
            this.mediaInsightsRuntimeMetadata = MediaInsightsRuntimeMetadataCopier.copy(mediaInsightsRuntimeMetadata);
        }

        @Override
        public final Builder mediaInsightsRuntimeMetadata(Map<String, String> mediaInsightsRuntimeMetadata) {
            this.mediaInsightsRuntimeMetadata = MediaInsightsRuntimeMetadataCopier.copy(mediaInsightsRuntimeMetadata);
            return this;
        }

        public final KinesisVideoStreamRecordingSourceRuntimeConfiguration.Builder getKinesisVideoStreamRecordingSourceRuntimeConfiguration() {
            return this.kinesisVideoStreamRecordingSourceRuntimeConfiguration != null ? this.kinesisVideoStreamRecordingSourceRuntimeConfiguration.toBuilder() : null;
        }

        public final void setKinesisVideoStreamRecordingSourceRuntimeConfiguration(KinesisVideoStreamRecordingSourceRuntimeConfiguration.BuilderImpl kinesisVideoStreamRecordingSourceRuntimeConfiguration) {
            this.kinesisVideoStreamRecordingSourceRuntimeConfiguration = kinesisVideoStreamRecordingSourceRuntimeConfiguration != null ? kinesisVideoStreamRecordingSourceRuntimeConfiguration.build() : null;
        }

        @Override
        public final Builder kinesisVideoStreamRecordingSourceRuntimeConfiguration(KinesisVideoStreamRecordingSourceRuntimeConfiguration kinesisVideoStreamRecordingSourceRuntimeConfiguration) {
            this.kinesisVideoStreamRecordingSourceRuntimeConfiguration = kinesisVideoStreamRecordingSourceRuntimeConfiguration;
            return this;
        }

        public final S3RecordingSinkRuntimeConfiguration.Builder getS3RecordingSinkRuntimeConfiguration() {
            return this.s3RecordingSinkRuntimeConfiguration != null ? this.s3RecordingSinkRuntimeConfiguration.toBuilder() : null;
        }

        public final void setS3RecordingSinkRuntimeConfiguration(S3RecordingSinkRuntimeConfiguration.BuilderImpl s3RecordingSinkRuntimeConfiguration) {
            this.s3RecordingSinkRuntimeConfiguration = s3RecordingSinkRuntimeConfiguration != null ? s3RecordingSinkRuntimeConfiguration.build() : null;
        }

        @Override
        public final Builder s3RecordingSinkRuntimeConfiguration(S3RecordingSinkRuntimeConfiguration s3RecordingSinkRuntimeConfiguration) {
            this.s3RecordingSinkRuntimeConfiguration = s3RecordingSinkRuntimeConfiguration;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public MediaInsightsPipeline build() {
            return new MediaInsightsPipeline(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaInsightsPipeline> {
        public Builder mediaPipelineId(String var1);

        public Builder mediaPipelineArn(String var1);

        public Builder mediaInsightsPipelineConfigurationArn(String var1);

        public Builder status(String var1);

        public Builder status(MediaPipelineStatus var1);

        public Builder kinesisVideoStreamSourceRuntimeConfiguration(KinesisVideoStreamSourceRuntimeConfiguration var1);

        default public Builder kinesisVideoStreamSourceRuntimeConfiguration(Consumer<KinesisVideoStreamSourceRuntimeConfiguration.Builder> kinesisVideoStreamSourceRuntimeConfiguration) {
            return this.kinesisVideoStreamSourceRuntimeConfiguration((KinesisVideoStreamSourceRuntimeConfiguration)((KinesisVideoStreamSourceRuntimeConfiguration.Builder)KinesisVideoStreamSourceRuntimeConfiguration.builder().applyMutation(kinesisVideoStreamSourceRuntimeConfiguration)).build());
        }

        public Builder mediaInsightsRuntimeMetadata(Map<String, String> var1);

        public Builder kinesisVideoStreamRecordingSourceRuntimeConfiguration(KinesisVideoStreamRecordingSourceRuntimeConfiguration var1);

        default public Builder kinesisVideoStreamRecordingSourceRuntimeConfiguration(Consumer<KinesisVideoStreamRecordingSourceRuntimeConfiguration.Builder> kinesisVideoStreamRecordingSourceRuntimeConfiguration) {
            return this.kinesisVideoStreamRecordingSourceRuntimeConfiguration((KinesisVideoStreamRecordingSourceRuntimeConfiguration)((KinesisVideoStreamRecordingSourceRuntimeConfiguration.Builder)KinesisVideoStreamRecordingSourceRuntimeConfiguration.builder().applyMutation(kinesisVideoStreamRecordingSourceRuntimeConfiguration)).build());
        }

        public Builder s3RecordingSinkRuntimeConfiguration(S3RecordingSinkRuntimeConfiguration var1);

        default public Builder s3RecordingSinkRuntimeConfiguration(Consumer<S3RecordingSinkRuntimeConfiguration.Builder> s3RecordingSinkRuntimeConfiguration) {
            return this.s3RecordingSinkRuntimeConfiguration((S3RecordingSinkRuntimeConfiguration)((S3RecordingSinkRuntimeConfiguration.Builder)S3RecordingSinkRuntimeConfiguration.builder().applyMutation(s3RecordingSinkRuntimeConfiguration)).build());
        }

        public Builder createdTimestamp(Instant var1);
    }
}

