/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the type of grid layout.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GridViewConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GridViewConfiguration.Builder, GridViewConfiguration> {
    private static final SdkField<String> CONTENT_SHARE_LAYOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentShareLayout").getter(getter(GridViewConfiguration::contentShareLayoutAsString))
            .setter(setter(Builder::contentShareLayout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentShareLayout").build())
            .build();

    private static final SdkField<PresenterOnlyConfiguration> PRESENTER_ONLY_CONFIGURATION_FIELD = SdkField
            .<PresenterOnlyConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("PresenterOnlyConfiguration")
            .getter(getter(GridViewConfiguration::presenterOnlyConfiguration))
            .setter(setter(Builder::presenterOnlyConfiguration))
            .constructor(PresenterOnlyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresenterOnlyConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_SHARE_LAYOUT_FIELD,
            PRESENTER_ONLY_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contentShareLayout;

    private final PresenterOnlyConfiguration presenterOnlyConfiguration;

    private GridViewConfiguration(BuilderImpl builder) {
        this.contentShareLayout = builder.contentShareLayout;
        this.presenterOnlyConfiguration = builder.presenterOnlyConfiguration;
    }

    /**
     * <p>
     * Defines the layout of the video tiles when content sharing is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentShareLayout} will return {@link ContentShareLayoutOption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #contentShareLayoutAsString}.
     * </p>
     * 
     * @return Defines the layout of the video tiles when content sharing is enabled.
     * @see ContentShareLayoutOption
     */
    public final ContentShareLayoutOption contentShareLayout() {
        return ContentShareLayoutOption.fromValue(contentShareLayout);
    }

    /**
     * <p>
     * Defines the layout of the video tiles when content sharing is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentShareLayout} will return {@link ContentShareLayoutOption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #contentShareLayoutAsString}.
     * </p>
     * 
     * @return Defines the layout of the video tiles when content sharing is enabled.
     * @see ContentShareLayoutOption
     */
    public final String contentShareLayoutAsString() {
        return contentShareLayout;
    }

    /**
     * <p>
     * Defines the configuration options for a presenter only video tile.
     * </p>
     * 
     * @return Defines the configuration options for a presenter only video tile.
     */
    public final PresenterOnlyConfiguration presenterOnlyConfiguration() {
        return presenterOnlyConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentShareLayoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(presenterOnlyConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GridViewConfiguration)) {
            return false;
        }
        GridViewConfiguration other = (GridViewConfiguration) obj;
        return Objects.equals(contentShareLayoutAsString(), other.contentShareLayoutAsString())
                && Objects.equals(presenterOnlyConfiguration(), other.presenterOnlyConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GridViewConfiguration").add("ContentShareLayout", contentShareLayoutAsString())
                .add("PresenterOnlyConfiguration", presenterOnlyConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentShareLayout":
            return Optional.ofNullable(clazz.cast(contentShareLayoutAsString()));
        case "PresenterOnlyConfiguration":
            return Optional.ofNullable(clazz.cast(presenterOnlyConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GridViewConfiguration, T> g) {
        return obj -> g.apply((GridViewConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GridViewConfiguration> {
        /**
         * <p>
         * Defines the layout of the video tiles when content sharing is enabled.
         * </p>
         * 
         * @param contentShareLayout
         *        Defines the layout of the video tiles when content sharing is enabled.
         * @see ContentShareLayoutOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentShareLayoutOption
         */
        Builder contentShareLayout(String contentShareLayout);

        /**
         * <p>
         * Defines the layout of the video tiles when content sharing is enabled.
         * </p>
         * 
         * @param contentShareLayout
         *        Defines the layout of the video tiles when content sharing is enabled.
         * @see ContentShareLayoutOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentShareLayoutOption
         */
        Builder contentShareLayout(ContentShareLayoutOption contentShareLayout);

        /**
         * <p>
         * Defines the configuration options for a presenter only video tile.
         * </p>
         * 
         * @param presenterOnlyConfiguration
         *        Defines the configuration options for a presenter only video tile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presenterOnlyConfiguration(PresenterOnlyConfiguration presenterOnlyConfiguration);

        /**
         * <p>
         * Defines the configuration options for a presenter only video tile.
         * </p>
         * This is a convenience method that creates an instance of the {@link PresenterOnlyConfiguration.Builder}
         * avoiding the need to create one manually via {@link PresenterOnlyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PresenterOnlyConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #presenterOnlyConfiguration(PresenterOnlyConfiguration)}.
         * 
         * @param presenterOnlyConfiguration
         *        a consumer that will call methods on {@link PresenterOnlyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #presenterOnlyConfiguration(PresenterOnlyConfiguration)
         */
        default Builder presenterOnlyConfiguration(Consumer<PresenterOnlyConfiguration.Builder> presenterOnlyConfiguration) {
            return presenterOnlyConfiguration(PresenterOnlyConfiguration.builder().applyMutation(presenterOnlyConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String contentShareLayout;

        private PresenterOnlyConfiguration presenterOnlyConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GridViewConfiguration model) {
            contentShareLayout(model.contentShareLayout);
            presenterOnlyConfiguration(model.presenterOnlyConfiguration);
        }

        public final String getContentShareLayout() {
            return contentShareLayout;
        }

        public final void setContentShareLayout(String contentShareLayout) {
            this.contentShareLayout = contentShareLayout;
        }

        @Override
        public final Builder contentShareLayout(String contentShareLayout) {
            this.contentShareLayout = contentShareLayout;
            return this;
        }

        @Override
        public final Builder contentShareLayout(ContentShareLayoutOption contentShareLayout) {
            this.contentShareLayout(contentShareLayout == null ? null : contentShareLayout.toString());
            return this;
        }

        public final PresenterOnlyConfiguration.Builder getPresenterOnlyConfiguration() {
            return presenterOnlyConfiguration != null ? presenterOnlyConfiguration.toBuilder() : null;
        }

        public final void setPresenterOnlyConfiguration(PresenterOnlyConfiguration.BuilderImpl presenterOnlyConfiguration) {
            this.presenterOnlyConfiguration = presenterOnlyConfiguration != null ? presenterOnlyConfiguration.build() : null;
        }

        @Override
        public final Builder presenterOnlyConfiguration(PresenterOnlyConfiguration presenterOnlyConfiguration) {
            this.presenterOnlyConfiguration = presenterOnlyConfiguration;
            return this;
        }

        @Override
        public GridViewConfiguration build() {
            return new GridViewConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
