/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMediaInsightsPipelineRequest extends ChimeSdkMediaPipelinesRequest implements
        ToCopyableBuilder<CreateMediaInsightsPipelineRequest.Builder, CreateMediaInsightsPipelineRequest> {
    private static final SdkField<String> MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MediaInsightsPipelineConfigurationArn")
            .getter(getter(CreateMediaInsightsPipelineRequest::mediaInsightsPipelineConfigurationArn))
            .setter(setter(Builder::mediaInsightsPipelineConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MediaInsightsPipelineConfigurationArn").build()).build();

    private static final SdkField<KinesisVideoStreamSourceRuntimeConfiguration> KINESIS_VIDEO_STREAM_SOURCE_RUNTIME_CONFIGURATION_FIELD = SdkField
            .<KinesisVideoStreamSourceRuntimeConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisVideoStreamSourceRuntimeConfiguration")
            .getter(getter(CreateMediaInsightsPipelineRequest::kinesisVideoStreamSourceRuntimeConfiguration))
            .setter(setter(Builder::kinesisVideoStreamSourceRuntimeConfiguration))
            .constructor(KinesisVideoStreamSourceRuntimeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("KinesisVideoStreamSourceRuntimeConfiguration").build()).build();

    private static final SdkField<Map<String, String>> MEDIA_INSIGHTS_RUNTIME_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("MediaInsightsRuntimeMetadata")
            .getter(getter(CreateMediaInsightsPipelineRequest::mediaInsightsRuntimeMetadata))
            .setter(setter(Builder::mediaInsightsRuntimeMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaInsightsRuntimeMetadata")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<KinesisVideoStreamRecordingSourceRuntimeConfiguration> KINESIS_VIDEO_STREAM_RECORDING_SOURCE_RUNTIME_CONFIGURATION_FIELD = SdkField
            .<KinesisVideoStreamRecordingSourceRuntimeConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisVideoStreamRecordingSourceRuntimeConfiguration")
            .getter(getter(CreateMediaInsightsPipelineRequest::kinesisVideoStreamRecordingSourceRuntimeConfiguration))
            .setter(setter(Builder::kinesisVideoStreamRecordingSourceRuntimeConfiguration))
            .constructor(KinesisVideoStreamRecordingSourceRuntimeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("KinesisVideoStreamRecordingSourceRuntimeConfiguration").build()).build();

    private static final SdkField<S3RecordingSinkRuntimeConfiguration> S3_RECORDING_SINK_RUNTIME_CONFIGURATION_FIELD = SdkField
            .<S3RecordingSinkRuntimeConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("S3RecordingSinkRuntimeConfiguration")
            .getter(getter(CreateMediaInsightsPipelineRequest::s3RecordingSinkRuntimeConfiguration))
            .setter(setter(Builder::s3RecordingSinkRuntimeConfiguration))
            .constructor(S3RecordingSinkRuntimeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("S3RecordingSinkRuntimeConfiguration").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateMediaInsightsPipelineRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateMediaInsightsPipelineRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ARN_FIELD, KINESIS_VIDEO_STREAM_SOURCE_RUNTIME_CONFIGURATION_FIELD,
            MEDIA_INSIGHTS_RUNTIME_METADATA_FIELD, KINESIS_VIDEO_STREAM_RECORDING_SOURCE_RUNTIME_CONFIGURATION_FIELD,
            S3_RECORDING_SINK_RUNTIME_CONFIGURATION_FIELD, TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String mediaInsightsPipelineConfigurationArn;

    private final KinesisVideoStreamSourceRuntimeConfiguration kinesisVideoStreamSourceRuntimeConfiguration;

    private final Map<String, String> mediaInsightsRuntimeMetadata;

    private final KinesisVideoStreamRecordingSourceRuntimeConfiguration kinesisVideoStreamRecordingSourceRuntimeConfiguration;

    private final S3RecordingSinkRuntimeConfiguration s3RecordingSinkRuntimeConfiguration;

    private final List<Tag> tags;

    private final String clientRequestToken;

    private CreateMediaInsightsPipelineRequest(BuilderImpl builder) {
        super(builder);
        this.mediaInsightsPipelineConfigurationArn = builder.mediaInsightsPipelineConfigurationArn;
        this.kinesisVideoStreamSourceRuntimeConfiguration = builder.kinesisVideoStreamSourceRuntimeConfiguration;
        this.mediaInsightsRuntimeMetadata = builder.mediaInsightsRuntimeMetadata;
        this.kinesisVideoStreamRecordingSourceRuntimeConfiguration = builder.kinesisVideoStreamRecordingSourceRuntimeConfiguration;
        this.s3RecordingSinkRuntimeConfiguration = builder.s3RecordingSinkRuntimeConfiguration;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The ARN of the pipeline's configuration.
     * </p>
     * 
     * @return The ARN of the pipeline's configuration.
     */
    public final String mediaInsightsPipelineConfigurationArn() {
        return mediaInsightsPipelineConfigurationArn;
    }

    /**
     * <p>
     * The runtime configuration for the Kinesis video stream source of the media insights pipeline.
     * </p>
     * 
     * @return The runtime configuration for the Kinesis video stream source of the media insights pipeline.
     */
    public final KinesisVideoStreamSourceRuntimeConfiguration kinesisVideoStreamSourceRuntimeConfiguration() {
        return kinesisVideoStreamSourceRuntimeConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaInsightsRuntimeMetadata property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMediaInsightsRuntimeMetadata() {
        return mediaInsightsRuntimeMetadata != null && !(mediaInsightsRuntimeMetadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The runtime metadata for the media insights pipeline. Consists of a key-value map of strings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaInsightsRuntimeMetadata} method.
     * </p>
     * 
     * @return The runtime metadata for the media insights pipeline. Consists of a key-value map of strings.
     */
    public final Map<String, String> mediaInsightsRuntimeMetadata() {
        return mediaInsightsRuntimeMetadata;
    }

    /**
     * <p>
     * The runtime configuration for the Kinesis video recording stream source.
     * </p>
     * 
     * @return The runtime configuration for the Kinesis video recording stream source.
     */
    public final KinesisVideoStreamRecordingSourceRuntimeConfiguration kinesisVideoStreamRecordingSourceRuntimeConfiguration() {
        return kinesisVideoStreamRecordingSourceRuntimeConfiguration;
    }

    /**
     * <p>
     * The runtime configuration for the S3 recording sink.
     * </p>
     * 
     * @return The runtime configuration for the S3 recording sink.
     */
    public final S3RecordingSinkRuntimeConfiguration s3RecordingSinkRuntimeConfiguration() {
        return s3RecordingSinkRuntimeConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the media insights pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the media insights pipeline.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The unique identifier for the media insights pipeline request.
     * </p>
     * 
     * @return The unique identifier for the media insights pipeline request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mediaInsightsPipelineConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisVideoStreamSourceRuntimeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaInsightsRuntimeMetadata() ? mediaInsightsRuntimeMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kinesisVideoStreamRecordingSourceRuntimeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3RecordingSinkRuntimeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMediaInsightsPipelineRequest)) {
            return false;
        }
        CreateMediaInsightsPipelineRequest other = (CreateMediaInsightsPipelineRequest) obj;
        return Objects.equals(mediaInsightsPipelineConfigurationArn(), other.mediaInsightsPipelineConfigurationArn())
                && Objects.equals(kinesisVideoStreamSourceRuntimeConfiguration(),
                        other.kinesisVideoStreamSourceRuntimeConfiguration())
                && hasMediaInsightsRuntimeMetadata() == other.hasMediaInsightsRuntimeMetadata()
                && Objects.equals(mediaInsightsRuntimeMetadata(), other.mediaInsightsRuntimeMetadata())
                && Objects.equals(kinesisVideoStreamRecordingSourceRuntimeConfiguration(),
                        other.kinesisVideoStreamRecordingSourceRuntimeConfiguration())
                && Objects.equals(s3RecordingSinkRuntimeConfiguration(), other.s3RecordingSinkRuntimeConfiguration())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateMediaInsightsPipelineRequest")
                .add("MediaInsightsPipelineConfigurationArn",
                        mediaInsightsPipelineConfigurationArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("KinesisVideoStreamSourceRuntimeConfiguration", kinesisVideoStreamSourceRuntimeConfiguration())
                .add("MediaInsightsRuntimeMetadata",
                        mediaInsightsRuntimeMetadata() == null ? null : "*** Sensitive Data Redacted ***")
                .add("KinesisVideoStreamRecordingSourceRuntimeConfiguration",
                        kinesisVideoStreamRecordingSourceRuntimeConfiguration())
                .add("S3RecordingSinkRuntimeConfiguration", s3RecordingSinkRuntimeConfiguration())
                .add("Tags", hasTags() ? tags() : null)
                .add("ClientRequestToken", clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaInsightsPipelineConfigurationArn":
            return Optional.ofNullable(clazz.cast(mediaInsightsPipelineConfigurationArn()));
        case "KinesisVideoStreamSourceRuntimeConfiguration":
            return Optional.ofNullable(clazz.cast(kinesisVideoStreamSourceRuntimeConfiguration()));
        case "MediaInsightsRuntimeMetadata":
            return Optional.ofNullable(clazz.cast(mediaInsightsRuntimeMetadata()));
        case "KinesisVideoStreamRecordingSourceRuntimeConfiguration":
            return Optional.ofNullable(clazz.cast(kinesisVideoStreamRecordingSourceRuntimeConfiguration()));
        case "S3RecordingSinkRuntimeConfiguration":
            return Optional.ofNullable(clazz.cast(s3RecordingSinkRuntimeConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMediaInsightsPipelineRequest, T> g) {
        return obj -> g.apply((CreateMediaInsightsPipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMediaPipelinesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMediaInsightsPipelineRequest> {
        /**
         * <p>
         * The ARN of the pipeline's configuration.
         * </p>
         * 
         * @param mediaInsightsPipelineConfigurationArn
         *        The ARN of the pipeline's configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaInsightsPipelineConfigurationArn(String mediaInsightsPipelineConfigurationArn);

        /**
         * <p>
         * The runtime configuration for the Kinesis video stream source of the media insights pipeline.
         * </p>
         * 
         * @param kinesisVideoStreamSourceRuntimeConfiguration
         *        The runtime configuration for the Kinesis video stream source of the media insights pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisVideoStreamSourceRuntimeConfiguration(
                KinesisVideoStreamSourceRuntimeConfiguration kinesisVideoStreamSourceRuntimeConfiguration);

        /**
         * <p>
         * The runtime configuration for the Kinesis video stream source of the media insights pipeline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KinesisVideoStreamSourceRuntimeConfiguration.Builder} avoiding the need to create one manually via
         * {@link KinesisVideoStreamSourceRuntimeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisVideoStreamSourceRuntimeConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #kinesisVideoStreamSourceRuntimeConfiguration(KinesisVideoStreamSourceRuntimeConfiguration)}.
         * 
         * @param kinesisVideoStreamSourceRuntimeConfiguration
         *        a consumer that will call methods on {@link KinesisVideoStreamSourceRuntimeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisVideoStreamSourceRuntimeConfiguration(KinesisVideoStreamSourceRuntimeConfiguration)
         */
        default Builder kinesisVideoStreamSourceRuntimeConfiguration(
                Consumer<KinesisVideoStreamSourceRuntimeConfiguration.Builder> kinesisVideoStreamSourceRuntimeConfiguration) {
            return kinesisVideoStreamSourceRuntimeConfiguration(KinesisVideoStreamSourceRuntimeConfiguration.builder()
                    .applyMutation(kinesisVideoStreamSourceRuntimeConfiguration).build());
        }

        /**
         * <p>
         * The runtime metadata for the media insights pipeline. Consists of a key-value map of strings.
         * </p>
         * 
         * @param mediaInsightsRuntimeMetadata
         *        The runtime metadata for the media insights pipeline. Consists of a key-value map of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaInsightsRuntimeMetadata(Map<String, String> mediaInsightsRuntimeMetadata);

        /**
         * <p>
         * The runtime configuration for the Kinesis video recording stream source.
         * </p>
         * 
         * @param kinesisVideoStreamRecordingSourceRuntimeConfiguration
         *        The runtime configuration for the Kinesis video recording stream source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisVideoStreamRecordingSourceRuntimeConfiguration(
                KinesisVideoStreamRecordingSourceRuntimeConfiguration kinesisVideoStreamRecordingSourceRuntimeConfiguration);

        /**
         * <p>
         * The runtime configuration for the Kinesis video recording stream source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KinesisVideoStreamRecordingSourceRuntimeConfiguration.Builder} avoiding the need to create one
         * manually via {@link KinesisVideoStreamRecordingSourceRuntimeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link KinesisVideoStreamRecordingSourceRuntimeConfiguration.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #kinesisVideoStreamRecordingSourceRuntimeConfiguration(KinesisVideoStreamRecordingSourceRuntimeConfiguration)}.
         * 
         * @param kinesisVideoStreamRecordingSourceRuntimeConfiguration
         *        a consumer that will call methods on
         *        {@link KinesisVideoStreamRecordingSourceRuntimeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisVideoStreamRecordingSourceRuntimeConfiguration(KinesisVideoStreamRecordingSourceRuntimeConfiguration)
         */
        default Builder kinesisVideoStreamRecordingSourceRuntimeConfiguration(
                Consumer<KinesisVideoStreamRecordingSourceRuntimeConfiguration.Builder> kinesisVideoStreamRecordingSourceRuntimeConfiguration) {
            return kinesisVideoStreamRecordingSourceRuntimeConfiguration(KinesisVideoStreamRecordingSourceRuntimeConfiguration
                    .builder().applyMutation(kinesisVideoStreamRecordingSourceRuntimeConfiguration).build());
        }

        /**
         * <p>
         * The runtime configuration for the S3 recording sink.
         * </p>
         * 
         * @param s3RecordingSinkRuntimeConfiguration
         *        The runtime configuration for the S3 recording sink.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3RecordingSinkRuntimeConfiguration(S3RecordingSinkRuntimeConfiguration s3RecordingSinkRuntimeConfiguration);

        /**
         * <p>
         * The runtime configuration for the S3 recording sink.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link S3RecordingSinkRuntimeConfiguration.Builder} avoiding the need to create one manually via
         * {@link S3RecordingSinkRuntimeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3RecordingSinkRuntimeConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #s3RecordingSinkRuntimeConfiguration(S3RecordingSinkRuntimeConfiguration)}.
         * 
         * @param s3RecordingSinkRuntimeConfiguration
         *        a consumer that will call methods on {@link S3RecordingSinkRuntimeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3RecordingSinkRuntimeConfiguration(S3RecordingSinkRuntimeConfiguration)
         */
        default Builder s3RecordingSinkRuntimeConfiguration(
                Consumer<S3RecordingSinkRuntimeConfiguration.Builder> s3RecordingSinkRuntimeConfiguration) {
            return s3RecordingSinkRuntimeConfiguration(S3RecordingSinkRuntimeConfiguration.builder()
                    .applyMutation(s3RecordingSinkRuntimeConfiguration).build());
        }

        /**
         * <p>
         * The tags assigned to the media insights pipeline.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the media insights pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the media insights pipeline.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the media insights pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the media insights pipeline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag.Builder#build()} is called
         * immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The unique identifier for the media insights pipeline request.
         * </p>
         * 
         * @param clientRequestToken
         *        The unique identifier for the media insights pipeline request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesRequest.BuilderImpl implements Builder {
        private String mediaInsightsPipelineConfigurationArn;

        private KinesisVideoStreamSourceRuntimeConfiguration kinesisVideoStreamSourceRuntimeConfiguration;

        private Map<String, String> mediaInsightsRuntimeMetadata = DefaultSdkAutoConstructMap.getInstance();

        private KinesisVideoStreamRecordingSourceRuntimeConfiguration kinesisVideoStreamRecordingSourceRuntimeConfiguration;

        private S3RecordingSinkRuntimeConfiguration s3RecordingSinkRuntimeConfiguration;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMediaInsightsPipelineRequest model) {
            super(model);
            mediaInsightsPipelineConfigurationArn(model.mediaInsightsPipelineConfigurationArn);
            kinesisVideoStreamSourceRuntimeConfiguration(model.kinesisVideoStreamSourceRuntimeConfiguration);
            mediaInsightsRuntimeMetadata(model.mediaInsightsRuntimeMetadata);
            kinesisVideoStreamRecordingSourceRuntimeConfiguration(model.kinesisVideoStreamRecordingSourceRuntimeConfiguration);
            s3RecordingSinkRuntimeConfiguration(model.s3RecordingSinkRuntimeConfiguration);
            tags(model.tags);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getMediaInsightsPipelineConfigurationArn() {
            return mediaInsightsPipelineConfigurationArn;
        }

        public final void setMediaInsightsPipelineConfigurationArn(String mediaInsightsPipelineConfigurationArn) {
            this.mediaInsightsPipelineConfigurationArn = mediaInsightsPipelineConfigurationArn;
        }

        @Override
        public final Builder mediaInsightsPipelineConfigurationArn(String mediaInsightsPipelineConfigurationArn) {
            this.mediaInsightsPipelineConfigurationArn = mediaInsightsPipelineConfigurationArn;
            return this;
        }

        public final KinesisVideoStreamSourceRuntimeConfiguration.Builder getKinesisVideoStreamSourceRuntimeConfiguration() {
            return kinesisVideoStreamSourceRuntimeConfiguration != null ? kinesisVideoStreamSourceRuntimeConfiguration
                    .toBuilder() : null;
        }

        public final void setKinesisVideoStreamSourceRuntimeConfiguration(
                KinesisVideoStreamSourceRuntimeConfiguration.BuilderImpl kinesisVideoStreamSourceRuntimeConfiguration) {
            this.kinesisVideoStreamSourceRuntimeConfiguration = kinesisVideoStreamSourceRuntimeConfiguration != null ? kinesisVideoStreamSourceRuntimeConfiguration
                    .build() : null;
        }

        @Override
        public final Builder kinesisVideoStreamSourceRuntimeConfiguration(
                KinesisVideoStreamSourceRuntimeConfiguration kinesisVideoStreamSourceRuntimeConfiguration) {
            this.kinesisVideoStreamSourceRuntimeConfiguration = kinesisVideoStreamSourceRuntimeConfiguration;
            return this;
        }

        public final Map<String, String> getMediaInsightsRuntimeMetadata() {
            if (mediaInsightsRuntimeMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return mediaInsightsRuntimeMetadata;
        }

        public final void setMediaInsightsRuntimeMetadata(Map<String, String> mediaInsightsRuntimeMetadata) {
            this.mediaInsightsRuntimeMetadata = MediaInsightsRuntimeMetadataCopier.copy(mediaInsightsRuntimeMetadata);
        }

        @Override
        public final Builder mediaInsightsRuntimeMetadata(Map<String, String> mediaInsightsRuntimeMetadata) {
            this.mediaInsightsRuntimeMetadata = MediaInsightsRuntimeMetadataCopier.copy(mediaInsightsRuntimeMetadata);
            return this;
        }

        public final KinesisVideoStreamRecordingSourceRuntimeConfiguration.Builder getKinesisVideoStreamRecordingSourceRuntimeConfiguration() {
            return kinesisVideoStreamRecordingSourceRuntimeConfiguration != null ? kinesisVideoStreamRecordingSourceRuntimeConfiguration
                    .toBuilder() : null;
        }

        public final void setKinesisVideoStreamRecordingSourceRuntimeConfiguration(
                KinesisVideoStreamRecordingSourceRuntimeConfiguration.BuilderImpl kinesisVideoStreamRecordingSourceRuntimeConfiguration) {
            this.kinesisVideoStreamRecordingSourceRuntimeConfiguration = kinesisVideoStreamRecordingSourceRuntimeConfiguration != null ? kinesisVideoStreamRecordingSourceRuntimeConfiguration
                    .build() : null;
        }

        @Override
        public final Builder kinesisVideoStreamRecordingSourceRuntimeConfiguration(
                KinesisVideoStreamRecordingSourceRuntimeConfiguration kinesisVideoStreamRecordingSourceRuntimeConfiguration) {
            this.kinesisVideoStreamRecordingSourceRuntimeConfiguration = kinesisVideoStreamRecordingSourceRuntimeConfiguration;
            return this;
        }

        public final S3RecordingSinkRuntimeConfiguration.Builder getS3RecordingSinkRuntimeConfiguration() {
            return s3RecordingSinkRuntimeConfiguration != null ? s3RecordingSinkRuntimeConfiguration.toBuilder() : null;
        }

        public final void setS3RecordingSinkRuntimeConfiguration(
                S3RecordingSinkRuntimeConfiguration.BuilderImpl s3RecordingSinkRuntimeConfiguration) {
            this.s3RecordingSinkRuntimeConfiguration = s3RecordingSinkRuntimeConfiguration != null ? s3RecordingSinkRuntimeConfiguration
                    .build() : null;
        }

        @Override
        public final Builder s3RecordingSinkRuntimeConfiguration(
                S3RecordingSinkRuntimeConfiguration s3RecordingSinkRuntimeConfiguration) {
            this.s3RecordingSinkRuntimeConfiguration = s3RecordingSinkRuntimeConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMediaInsightsPipelineRequest build() {
            return new CreateMediaInsightsPipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
