/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for a post-call voice analytics task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostCallAnalyticsSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<PostCallAnalyticsSettings.Builder, PostCallAnalyticsSettings> {
    private static final SdkField<String> OUTPUT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputLocation").getter(getter(PostCallAnalyticsSettings::outputLocation))
            .setter(setter(Builder::outputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(PostCallAnalyticsSettings::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<String> CONTENT_REDACTION_OUTPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentRedactionOutput").getter(getter(PostCallAnalyticsSettings::contentRedactionOutputAsString))
            .setter(setter(Builder::contentRedactionOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRedactionOutput").build())
            .build();

    private static final SdkField<String> OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputEncryptionKMSKeyId").getter(getter(PostCallAnalyticsSettings::outputEncryptionKMSKeyId))
            .setter(setter(Builder::outputEncryptionKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputEncryptionKMSKeyId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_LOCATION_FIELD,
            DATA_ACCESS_ROLE_ARN_FIELD, CONTENT_REDACTION_OUTPUT_FIELD, OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String outputLocation;

    private final String dataAccessRoleArn;

    private final String contentRedactionOutput;

    private final String outputEncryptionKMSKeyId;

    private PostCallAnalyticsSettings(BuilderImpl builder) {
        this.outputLocation = builder.outputLocation;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.contentRedactionOutput = builder.contentRedactionOutput;
        this.outputEncryptionKMSKeyId = builder.outputEncryptionKMSKeyId;
    }

    /**
     * <p>
     * The URL of the Amazon S3 bucket that contains the post-call data.
     * </p>
     * 
     * @return The URL of the Amazon S3 bucket that contains the post-call data.
     */
    public final String outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * The ARN of the role used by Amazon Web Services Transcribe to upload your post call analysis. For more
     * information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-post-call.html">Post-call
     * analytics with real-time transcriptions</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * 
     * @return The ARN of the role used by Amazon Web Services Transcribe to upload your post call analysis. For more
     *         information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-post-call.html">Post-call
     *         analytics with real-time transcriptions</a> in the <i>Amazon Transcribe Developer Guide</i>.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * The content redaction output settings for a post-call analysis task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentRedactionOutput} will return {@link ContentRedactionOutput#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #contentRedactionOutputAsString}.
     * </p>
     * 
     * @return The content redaction output settings for a post-call analysis task.
     * @see ContentRedactionOutput
     */
    public final ContentRedactionOutput contentRedactionOutput() {
        return ContentRedactionOutput.fromValue(contentRedactionOutput);
    }

    /**
     * <p>
     * The content redaction output settings for a post-call analysis task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentRedactionOutput} will return {@link ContentRedactionOutput#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #contentRedactionOutputAsString}.
     * </p>
     * 
     * @return The content redaction output settings for a post-call analysis task.
     * @see ContentRedactionOutput
     */
    public final String contentRedactionOutputAsString() {
        return contentRedactionOutput;
    }

    /**
     * <p>
     * The ID of the KMS (Key Management System) key used to encrypt the output.
     * </p>
     * 
     * @return The ID of the KMS (Key Management System) key used to encrypt the output.
     */
    public final String outputEncryptionKMSKeyId() {
        return outputEncryptionKMSKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(contentRedactionOutputAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputEncryptionKMSKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostCallAnalyticsSettings)) {
            return false;
        }
        PostCallAnalyticsSettings other = (PostCallAnalyticsSettings) obj;
        return Objects.equals(outputLocation(), other.outputLocation())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn())
                && Objects.equals(contentRedactionOutputAsString(), other.contentRedactionOutputAsString())
                && Objects.equals(outputEncryptionKMSKeyId(), other.outputEncryptionKMSKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PostCallAnalyticsSettings").add("OutputLocation", outputLocation())
                .add("DataAccessRoleArn", dataAccessRoleArn()).add("ContentRedactionOutput", contentRedactionOutputAsString())
                .add("OutputEncryptionKMSKeyId", outputEncryptionKMSKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "ContentRedactionOutput":
            return Optional.ofNullable(clazz.cast(contentRedactionOutputAsString()));
        case "OutputEncryptionKMSKeyId":
            return Optional.ofNullable(clazz.cast(outputEncryptionKMSKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostCallAnalyticsSettings, T> g) {
        return obj -> g.apply((PostCallAnalyticsSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PostCallAnalyticsSettings> {
        /**
         * <p>
         * The URL of the Amazon S3 bucket that contains the post-call data.
         * </p>
         * 
         * @param outputLocation
         *        The URL of the Amazon S3 bucket that contains the post-call data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(String outputLocation);

        /**
         * <p>
         * The ARN of the role used by Amazon Web Services Transcribe to upload your post call analysis. For more
         * information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-post-call.html">Post-call
         * analytics with real-time transcriptions</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The ARN of the role used by Amazon Web Services Transcribe to upload your post call analysis. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-post-call.html">Post-call analytics with
         *        real-time transcriptions</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * The content redaction output settings for a post-call analysis task.
         * </p>
         * 
         * @param contentRedactionOutput
         *        The content redaction output settings for a post-call analysis task.
         * @see ContentRedactionOutput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentRedactionOutput
         */
        Builder contentRedactionOutput(String contentRedactionOutput);

        /**
         * <p>
         * The content redaction output settings for a post-call analysis task.
         * </p>
         * 
         * @param contentRedactionOutput
         *        The content redaction output settings for a post-call analysis task.
         * @see ContentRedactionOutput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentRedactionOutput
         */
        Builder contentRedactionOutput(ContentRedactionOutput contentRedactionOutput);

        /**
         * <p>
         * The ID of the KMS (Key Management System) key used to encrypt the output.
         * </p>
         * 
         * @param outputEncryptionKMSKeyId
         *        The ID of the KMS (Key Management System) key used to encrypt the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String outputLocation;

        private String dataAccessRoleArn;

        private String contentRedactionOutput;

        private String outputEncryptionKMSKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(PostCallAnalyticsSettings model) {
            outputLocation(model.outputLocation);
            dataAccessRoleArn(model.dataAccessRoleArn);
            contentRedactionOutput(model.contentRedactionOutput);
            outputEncryptionKMSKeyId(model.outputEncryptionKMSKeyId);
        }

        public final String getOutputLocation() {
            return outputLocation;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getContentRedactionOutput() {
            return contentRedactionOutput;
        }

        public final void setContentRedactionOutput(String contentRedactionOutput) {
            this.contentRedactionOutput = contentRedactionOutput;
        }

        @Override
        public final Builder contentRedactionOutput(String contentRedactionOutput) {
            this.contentRedactionOutput = contentRedactionOutput;
            return this;
        }

        @Override
        public final Builder contentRedactionOutput(ContentRedactionOutput contentRedactionOutput) {
            this.contentRedactionOutput(contentRedactionOutput == null ? null : contentRedactionOutput.toString());
            return this;
        }

        public final String getOutputEncryptionKMSKeyId() {
            return outputEncryptionKMSKeyId;
        }

        public final void setOutputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
        }

        @Override
        public final Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
            return this;
        }

        @Override
        public PostCallAnalyticsSettings build() {
            return new PostCallAnalyticsSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
