/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that holds the settings for transmitting audio and video recordings to the runtime Amazon S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3RecordingSinkRuntimeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<S3RecordingSinkRuntimeConfiguration.Builder, S3RecordingSinkRuntimeConfiguration> {
    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(S3RecordingSinkRuntimeConfiguration::destination))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> RECORDING_FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordingFileFormat").getter(getter(S3RecordingSinkRuntimeConfiguration::recordingFileFormatAsString))
            .setter(setter(Builder::recordingFileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordingFileFormat").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD,
            RECORDING_FILE_FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destination;

    private final String recordingFileFormat;

    private S3RecordingSinkRuntimeConfiguration(BuilderImpl builder) {
        this.destination = builder.destination;
        this.recordingFileFormat = builder.recordingFileFormat;
    }

    /**
     * <p>
     * The URL of the S3 bucket used as the runtime sink.
     * </p>
     * 
     * @return The URL of the S3 bucket used as the runtime sink.
     */
    public final String destination() {
        return destination;
    }

    /**
     * <p>
     * The file formats for the audio and video files sent to the Amazon S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recordingFileFormat} will return {@link RecordingFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #recordingFileFormatAsString}.
     * </p>
     * 
     * @return The file formats for the audio and video files sent to the Amazon S3 bucket.
     * @see RecordingFileFormat
     */
    public final RecordingFileFormat recordingFileFormat() {
        return RecordingFileFormat.fromValue(recordingFileFormat);
    }

    /**
     * <p>
     * The file formats for the audio and video files sent to the Amazon S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recordingFileFormat} will return {@link RecordingFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #recordingFileFormatAsString}.
     * </p>
     * 
     * @return The file formats for the audio and video files sent to the Amazon S3 bucket.
     * @see RecordingFileFormat
     */
    public final String recordingFileFormatAsString() {
        return recordingFileFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(recordingFileFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3RecordingSinkRuntimeConfiguration)) {
            return false;
        }
        S3RecordingSinkRuntimeConfiguration other = (S3RecordingSinkRuntimeConfiguration) obj;
        return Objects.equals(destination(), other.destination())
                && Objects.equals(recordingFileFormatAsString(), other.recordingFileFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3RecordingSinkRuntimeConfiguration")
                .add("Destination", destination() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RecordingFileFormat", recordingFileFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "RecordingFileFormat":
            return Optional.ofNullable(clazz.cast(recordingFileFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3RecordingSinkRuntimeConfiguration, T> g) {
        return obj -> g.apply((S3RecordingSinkRuntimeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3RecordingSinkRuntimeConfiguration> {
        /**
         * <p>
         * The URL of the S3 bucket used as the runtime sink.
         * </p>
         * 
         * @param destination
         *        The URL of the S3 bucket used as the runtime sink.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The file formats for the audio and video files sent to the Amazon S3 bucket.
         * </p>
         * 
         * @param recordingFileFormat
         *        The file formats for the audio and video files sent to the Amazon S3 bucket.
         * @see RecordingFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordingFileFormat
         */
        Builder recordingFileFormat(String recordingFileFormat);

        /**
         * <p>
         * The file formats for the audio and video files sent to the Amazon S3 bucket.
         * </p>
         * 
         * @param recordingFileFormat
         *        The file formats for the audio and video files sent to the Amazon S3 bucket.
         * @see RecordingFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordingFileFormat
         */
        Builder recordingFileFormat(RecordingFileFormat recordingFileFormat);
    }

    static final class BuilderImpl implements Builder {
        private String destination;

        private String recordingFileFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(S3RecordingSinkRuntimeConfiguration model) {
            destination(model.destination);
            recordingFileFormat(model.recordingFileFormat);
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getRecordingFileFormat() {
            return recordingFileFormat;
        }

        public final void setRecordingFileFormat(String recordingFileFormat) {
            this.recordingFileFormat = recordingFileFormat;
        }

        @Override
        public final Builder recordingFileFormat(String recordingFileFormat) {
            this.recordingFileFormat = recordingFileFormat;
            return this;
        }

        @Override
        public final Builder recordingFileFormat(RecordingFileFormat recordingFileFormat) {
            this.recordingFileFormat(recordingFileFormat == null ? null : recordingFileFormat.toString());
            return this;
        }

        @Override
        public S3RecordingSinkRuntimeConfiguration build() {
            return new S3RecordingSinkRuntimeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
