/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The URL of the SQS sink.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SqsQueueSinkConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SqsQueueSinkConfiguration.Builder, SqsQueueSinkConfiguration> {
    private static final SdkField<String> INSIGHTS_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InsightsTarget").getter(getter(SqsQueueSinkConfiguration::insightsTarget))
            .setter(setter(Builder::insightsTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightsTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHTS_TARGET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String insightsTarget;

    private SqsQueueSinkConfiguration(BuilderImpl builder) {
        this.insightsTarget = builder.insightsTarget;
    }

    /**
     * <p>
     * The URL of the SQS sink, <a
     * href="https://aws.amazon.com/kinesis/data-streams/">https://aws.amazon.com/kinesis/data-streams/</a>.
     * </p>
     * 
     * @return The URL of the SQS sink, <a
     *         href="https://aws.amazon.com/kinesis/data-streams/">https://aws.amazon.com/kinesis/data-streams/</a>.
     */
    public final String insightsTarget() {
        return insightsTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(insightsTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqsQueueSinkConfiguration)) {
            return false;
        }
        SqsQueueSinkConfiguration other = (SqsQueueSinkConfiguration) obj;
        return Objects.equals(insightsTarget(), other.insightsTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SqsQueueSinkConfiguration")
                .add("InsightsTarget", insightsTarget() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsightsTarget":
            return Optional.ofNullable(clazz.cast(insightsTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqsQueueSinkConfiguration, T> g) {
        return obj -> g.apply((SqsQueueSinkConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SqsQueueSinkConfiguration> {
        /**
         * <p>
         * The URL of the SQS sink, <a
         * href="https://aws.amazon.com/kinesis/data-streams/">https://aws.amazon.com/kinesis/data-streams/</a>.
         * </p>
         * 
         * @param insightsTarget
         *        The URL of the SQS sink, <a
         *        href="https://aws.amazon.com/kinesis/data-streams/">https://aws.amazon.com/kinesis/data-streams/</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightsTarget(String insightsTarget);
    }

    static final class BuilderImpl implements Builder {
        private String insightsTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(SqsQueueSinkConfiguration model) {
            insightsTarget(model.insightsTarget);
        }

        public final String getInsightsTarget() {
            return insightsTarget;
        }

        public final void setInsightsTarget(String insightsTarget) {
            this.insightsTarget = insightsTarget;
        }

        @Override
        public final Builder insightsTarget(String insightsTarget) {
            this.insightsTarget = insightsTarget;
            return this;
        }

        @Override
        public SqsQueueSinkConfiguration build() {
            return new SqsQueueSinkConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
