/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for a voice analytics processor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoiceAnalyticsProcessorConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VoiceAnalyticsProcessorConfiguration.Builder, VoiceAnalyticsProcessorConfiguration> {
    private static final SdkField<String> SPEAKER_SEARCH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpeakerSearchStatus").getter(getter(VoiceAnalyticsProcessorConfiguration::speakerSearchStatusAsString))
            .setter(setter(Builder::speakerSearchStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeakerSearchStatus").build())
            .build();

    private static final SdkField<String> VOICE_TONE_ANALYSIS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceToneAnalysisStatus")
            .getter(getter(VoiceAnalyticsProcessorConfiguration::voiceToneAnalysisStatusAsString))
            .setter(setter(Builder::voiceToneAnalysisStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceToneAnalysisStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEAKER_SEARCH_STATUS_FIELD,
            VOICE_TONE_ANALYSIS_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String speakerSearchStatus;

    private final String voiceToneAnalysisStatus;

    private VoiceAnalyticsProcessorConfiguration(BuilderImpl builder) {
        this.speakerSearchStatus = builder.speakerSearchStatus;
        this.voiceToneAnalysisStatus = builder.voiceToneAnalysisStatus;
    }

    /**
     * <p>
     * The status of the speaker search task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #speakerSearchStatus} will return {@link VoiceAnalyticsConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #speakerSearchStatusAsString}.
     * </p>
     * 
     * @return The status of the speaker search task.
     * @see VoiceAnalyticsConfigurationStatus
     */
    public final VoiceAnalyticsConfigurationStatus speakerSearchStatus() {
        return VoiceAnalyticsConfigurationStatus.fromValue(speakerSearchStatus);
    }

    /**
     * <p>
     * The status of the speaker search task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #speakerSearchStatus} will return {@link VoiceAnalyticsConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #speakerSearchStatusAsString}.
     * </p>
     * 
     * @return The status of the speaker search task.
     * @see VoiceAnalyticsConfigurationStatus
     */
    public final String speakerSearchStatusAsString() {
        return speakerSearchStatus;
    }

    /**
     * <p>
     * The status of the voice tone analysis task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #voiceToneAnalysisStatus} will return {@link VoiceAnalyticsConfigurationStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #voiceToneAnalysisStatusAsString}.
     * </p>
     * 
     * @return The status of the voice tone analysis task.
     * @see VoiceAnalyticsConfigurationStatus
     */
    public final VoiceAnalyticsConfigurationStatus voiceToneAnalysisStatus() {
        return VoiceAnalyticsConfigurationStatus.fromValue(voiceToneAnalysisStatus);
    }

    /**
     * <p>
     * The status of the voice tone analysis task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #voiceToneAnalysisStatus} will return {@link VoiceAnalyticsConfigurationStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #voiceToneAnalysisStatusAsString}.
     * </p>
     * 
     * @return The status of the voice tone analysis task.
     * @see VoiceAnalyticsConfigurationStatus
     */
    public final String voiceToneAnalysisStatusAsString() {
        return voiceToneAnalysisStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(speakerSearchStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(voiceToneAnalysisStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceAnalyticsProcessorConfiguration)) {
            return false;
        }
        VoiceAnalyticsProcessorConfiguration other = (VoiceAnalyticsProcessorConfiguration) obj;
        return Objects.equals(speakerSearchStatusAsString(), other.speakerSearchStatusAsString())
                && Objects.equals(voiceToneAnalysisStatusAsString(), other.voiceToneAnalysisStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VoiceAnalyticsProcessorConfiguration").add("SpeakerSearchStatus", speakerSearchStatusAsString())
                .add("VoiceToneAnalysisStatus", voiceToneAnalysisStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpeakerSearchStatus":
            return Optional.ofNullable(clazz.cast(speakerSearchStatusAsString()));
        case "VoiceToneAnalysisStatus":
            return Optional.ofNullable(clazz.cast(voiceToneAnalysisStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VoiceAnalyticsProcessorConfiguration, T> g) {
        return obj -> g.apply((VoiceAnalyticsProcessorConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoiceAnalyticsProcessorConfiguration> {
        /**
         * <p>
         * The status of the speaker search task.
         * </p>
         * 
         * @param speakerSearchStatus
         *        The status of the speaker search task.
         * @see VoiceAnalyticsConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceAnalyticsConfigurationStatus
         */
        Builder speakerSearchStatus(String speakerSearchStatus);

        /**
         * <p>
         * The status of the speaker search task.
         * </p>
         * 
         * @param speakerSearchStatus
         *        The status of the speaker search task.
         * @see VoiceAnalyticsConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceAnalyticsConfigurationStatus
         */
        Builder speakerSearchStatus(VoiceAnalyticsConfigurationStatus speakerSearchStatus);

        /**
         * <p>
         * The status of the voice tone analysis task.
         * </p>
         * 
         * @param voiceToneAnalysisStatus
         *        The status of the voice tone analysis task.
         * @see VoiceAnalyticsConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceAnalyticsConfigurationStatus
         */
        Builder voiceToneAnalysisStatus(String voiceToneAnalysisStatus);

        /**
         * <p>
         * The status of the voice tone analysis task.
         * </p>
         * 
         * @param voiceToneAnalysisStatus
         *        The status of the voice tone analysis task.
         * @see VoiceAnalyticsConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceAnalyticsConfigurationStatus
         */
        Builder voiceToneAnalysisStatus(VoiceAnalyticsConfigurationStatus voiceToneAnalysisStatus);
    }

    static final class BuilderImpl implements Builder {
        private String speakerSearchStatus;

        private String voiceToneAnalysisStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceAnalyticsProcessorConfiguration model) {
            speakerSearchStatus(model.speakerSearchStatus);
            voiceToneAnalysisStatus(model.voiceToneAnalysisStatus);
        }

        public final String getSpeakerSearchStatus() {
            return speakerSearchStatus;
        }

        public final void setSpeakerSearchStatus(String speakerSearchStatus) {
            this.speakerSearchStatus = speakerSearchStatus;
        }

        @Override
        public final Builder speakerSearchStatus(String speakerSearchStatus) {
            this.speakerSearchStatus = speakerSearchStatus;
            return this;
        }

        @Override
        public final Builder speakerSearchStatus(VoiceAnalyticsConfigurationStatus speakerSearchStatus) {
            this.speakerSearchStatus(speakerSearchStatus == null ? null : speakerSearchStatus.toString());
            return this;
        }

        public final String getVoiceToneAnalysisStatus() {
            return voiceToneAnalysisStatus;
        }

        public final void setVoiceToneAnalysisStatus(String voiceToneAnalysisStatus) {
            this.voiceToneAnalysisStatus = voiceToneAnalysisStatus;
        }

        @Override
        public final Builder voiceToneAnalysisStatus(String voiceToneAnalysisStatus) {
            this.voiceToneAnalysisStatus = voiceToneAnalysisStatus;
            return this;
        }

        @Override
        public final Builder voiceToneAnalysisStatus(VoiceAnalyticsConfigurationStatus voiceToneAnalysisStatus) {
            this.voiceToneAnalysisStatus(voiceToneAnalysisStatus == null ? null : voiceToneAnalysisStatus.toString());
            return this;
        }

        @Override
        public VoiceAnalyticsProcessorConfiguration build() {
            return new VoiceAnalyticsProcessorConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
