/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the configuration settings for an Amazon Transcribe processor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmazonTranscribeProcessorConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AmazonTranscribeProcessorConfiguration.Builder, AmazonTranscribeProcessorConfiguration> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(AmazonTranscribeProcessorConfiguration::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName").getter(getter(AmazonTranscribeProcessorConfiguration::vocabularyName))
            .setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterName").getter(getter(AmazonTranscribeProcessorConfiguration::vocabularyFilterName))
            .setter(setter(Builder::vocabularyFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build())
            .build();

    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterMethod")
            .getter(getter(AmazonTranscribeProcessorConfiguration::vocabularyFilterMethodAsString))
            .setter(setter(Builder::vocabularyFilterMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMethod").build())
            .build();

    private static final SdkField<Boolean> SHOW_SPEAKER_LABEL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowSpeakerLabel").getter(getter(AmazonTranscribeProcessorConfiguration::showSpeakerLabel))
            .setter(setter(Builder::showSpeakerLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowSpeakerLabel").build()).build();

    private static final SdkField<Boolean> ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnablePartialResultsStabilization")
            .getter(getter(AmazonTranscribeProcessorConfiguration::enablePartialResultsStabilization))
            .setter(setter(Builder::enablePartialResultsStabilization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePartialResultsStabilization")
                    .build()).build();

    private static final SdkField<String> PARTIAL_RESULTS_STABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartialResultsStability")
            .getter(getter(AmazonTranscribeProcessorConfiguration::partialResultsStabilityAsString))
            .setter(setter(Builder::partialResultsStability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartialResultsStability").build())
            .build();

    private static final SdkField<String> CONTENT_IDENTIFICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentIdentificationType")
            .getter(getter(AmazonTranscribeProcessorConfiguration::contentIdentificationTypeAsString))
            .setter(setter(Builder::contentIdentificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentIdentificationType").build())
            .build();

    private static final SdkField<String> CONTENT_REDACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentRedactionType")
            .getter(getter(AmazonTranscribeProcessorConfiguration::contentRedactionTypeAsString))
            .setter(setter(Builder::contentRedactionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRedactionType").build())
            .build();

    private static final SdkField<String> PII_ENTITY_TYPES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PiiEntityTypes").getter(getter(AmazonTranscribeProcessorConfiguration::piiEntityTypes))
            .setter(setter(Builder::piiEntityTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PiiEntityTypes").build()).build();

    private static final SdkField<String> LANGUAGE_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageModelName").getter(getter(AmazonTranscribeProcessorConfiguration::languageModelName))
            .setter(setter(Builder::languageModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageModelName").build()).build();

    private static final SdkField<Boolean> FILTER_PARTIAL_RESULTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FilterPartialResults").getter(getter(AmazonTranscribeProcessorConfiguration::filterPartialResults))
            .setter(setter(Builder::filterPartialResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterPartialResults").build())
            .build();

    private static final SdkField<Boolean> IDENTIFY_LANGUAGE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IdentifyLanguage").getter(getter(AmazonTranscribeProcessorConfiguration::identifyLanguage))
            .setter(setter(Builder::identifyLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifyLanguage").build()).build();

    private static final SdkField<String> LANGUAGE_OPTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageOptions").getter(getter(AmazonTranscribeProcessorConfiguration::languageOptions))
            .setter(setter(Builder::languageOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageOptions").build()).build();

    private static final SdkField<String> PREFERRED_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredLanguage").getter(getter(AmazonTranscribeProcessorConfiguration::preferredLanguageAsString))
            .setter(setter(Builder::preferredLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredLanguage").build()).build();

    private static final SdkField<String> VOCABULARY_NAMES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyNames").getter(getter(AmazonTranscribeProcessorConfiguration::vocabularyNames))
            .setter(setter(Builder::vocabularyNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyNames").build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_NAMES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterNames").getter(getter(AmazonTranscribeProcessorConfiguration::vocabularyFilterNames))
            .setter(setter(Builder::vocabularyFilterNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterNames").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD,
            VOCABULARY_NAME_FIELD, VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD, SHOW_SPEAKER_LABEL_FIELD,
            ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD, PARTIAL_RESULTS_STABILITY_FIELD, CONTENT_IDENTIFICATION_TYPE_FIELD,
            CONTENT_REDACTION_TYPE_FIELD, PII_ENTITY_TYPES_FIELD, LANGUAGE_MODEL_NAME_FIELD, FILTER_PARTIAL_RESULTS_FIELD,
            IDENTIFY_LANGUAGE_FIELD, LANGUAGE_OPTIONS_FIELD, PREFERRED_LANGUAGE_FIELD, VOCABULARY_NAMES_FIELD,
            VOCABULARY_FILTER_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String languageCode;

    private final String vocabularyName;

    private final String vocabularyFilterName;

    private final String vocabularyFilterMethod;

    private final Boolean showSpeakerLabel;

    private final Boolean enablePartialResultsStabilization;

    private final String partialResultsStability;

    private final String contentIdentificationType;

    private final String contentRedactionType;

    private final String piiEntityTypes;

    private final String languageModelName;

    private final Boolean filterPartialResults;

    private final Boolean identifyLanguage;

    private final String languageOptions;

    private final String preferredLanguage;

    private final String vocabularyNames;

    private final String vocabularyFilterNames;

    private AmazonTranscribeProcessorConfiguration(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.vocabularyName = builder.vocabularyName;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.showSpeakerLabel = builder.showSpeakerLabel;
        this.enablePartialResultsStabilization = builder.enablePartialResultsStabilization;
        this.partialResultsStability = builder.partialResultsStability;
        this.contentIdentificationType = builder.contentIdentificationType;
        this.contentRedactionType = builder.contentRedactionType;
        this.piiEntityTypes = builder.piiEntityTypes;
        this.languageModelName = builder.languageModelName;
        this.filterPartialResults = builder.filterPartialResults;
        this.identifyLanguage = builder.identifyLanguage;
        this.languageOptions = builder.languageOptions;
        this.preferredLanguage = builder.preferredLanguage;
        this.vocabularyNames = builder.vocabularyNames;
        this.vocabularyFilterNames = builder.vocabularyFilterNames;
    }

    /**
     * <p>
     * The language code that represents the language spoken in your audio.
     * </p>
     * <p>
     * If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable
     * automatic language identification.
     * </p>
     * <p>
     * For a list of languages that real-time Call Analytics supports, see the <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages table</a> in
     * the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link CallAnalyticsLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code that represents the language spoken in your audio.</p>
     *         <p>
     *         If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to
     *         enable automatic language identification.
     *         </p>
     *         <p>
     *         For a list of languages that real-time Call Analytics supports, see the <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages
     *         table</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * @see CallAnalyticsLanguageCode
     */
    public final CallAnalyticsLanguageCode languageCode() {
        return CallAnalyticsLanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code that represents the language spoken in your audio.
     * </p>
     * <p>
     * If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable
     * automatic language identification.
     * </p>
     * <p>
     * For a list of languages that real-time Call Analytics supports, see the <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages table</a> in
     * the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link CallAnalyticsLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code that represents the language spoken in your audio.</p>
     *         <p>
     *         If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to
     *         enable automatic language identification.
     *         </p>
     *         <p>
     *         For a list of languages that real-time Call Analytics supports, see the <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages
     *         table</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * @see CallAnalyticsLanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The name of the custom vocabulary that you specified in your Call Analytics request.
     * </p>
     * <p>
     * Length Constraints: Minimum length of 1. Maximum length of 200.
     * </p>
     * 
     * @return The name of the custom vocabulary that you specified in your Call Analytics request.</p>
     *         <p>
     *         Length Constraints: Minimum length of 1. Maximum length of 200.
     */
    public final String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * The name of the custom vocabulary filter that you specified in your Call Analytics request.
     * </p>
     * <p>
     * Length Constraints: Minimum length of 1. Maximum length of 200.
     * </p>
     * 
     * @return The name of the custom vocabulary filter that you specified in your Call Analytics request.</p>
     *         <p>
     *         Length Constraints: Minimum length of 1. Maximum length of 200.
     */
    public final String vocabularyFilterName() {
        return vocabularyFilterName;
    }

    /**
     * <p>
     * The vocabulary filtering method used in your Call Analytics transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return The vocabulary filtering method used in your Call Analytics transcription.
     * @see VocabularyFilterMethod
     */
    public final VocabularyFilterMethod vocabularyFilterMethod() {
        return VocabularyFilterMethod.fromValue(vocabularyFilterMethod);
    }

    /**
     * <p>
     * The vocabulary filtering method used in your Call Analytics transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return The vocabulary filtering method used in your Call Analytics transcription.
     * @see VocabularyFilterMethod
     */
    public final String vocabularyFilterMethodAsString() {
        return vocabularyFilterMethod;
    }

    /**
     * <p>
     * Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech
     * from individual speakers in your media file.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>
     * in the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * 
     * @return Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the
     *         speech from individual speakers in your media file.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
     *         (diarization)</a> in the <i>Amazon Transcribe Developer Guide</i>.
     */
    public final Boolean showSpeakerLabel() {
        return showSpeakerLabel;
    }

    /**
     * <p>
     * Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in
     * your output, but may impact accuracy.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     * >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * 
     * @return Enables partial result stabilization for your transcription. Partial result stabilization can reduce
     *         latency in your output, but may impact accuracy.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     *         >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
     */
    public final Boolean enablePartialResultsStabilization() {
        return enablePartialResultsStabilization;
    }

    /**
     * <p>
     * The level of stability to use when you enable partial results stabilization (
     * <code>EnablePartialResultsStabilization</code>).
     * </p>
     * <p>
     * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     * >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #partialResultsStability} will return {@link PartialResultsStability#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #partialResultsStabilityAsString}.
     * </p>
     * 
     * @return The level of stability to use when you enable partial results stabilization (
     *         <code>EnablePartialResultsStabilization</code>).</p>
     *         <p>
     *         Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower
     *         accuracy.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     *         >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * @see PartialResultsStability
     */
    public final PartialResultsStability partialResultsStability() {
        return PartialResultsStability.fromValue(partialResultsStability);
    }

    /**
     * <p>
     * The level of stability to use when you enable partial results stabilization (
     * <code>EnablePartialResultsStabilization</code>).
     * </p>
     * <p>
     * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     * >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #partialResultsStability} will return {@link PartialResultsStability#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #partialResultsStabilityAsString}.
     * </p>
     * 
     * @return The level of stability to use when you enable partial results stabilization (
     *         <code>EnablePartialResultsStabilization</code>).</p>
     *         <p>
     *         Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower
     *         accuracy.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     *         >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * @see PartialResultsStability
     */
    public final String partialResultsStabilityAsString() {
        return partialResultsStability;
    }

    /**
     * <p>
     * Labels all personally identifiable information (PII) identified in your transcript.
     * </p>
     * <p>
     * Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is flagged
     * upon complete transcription of an audio segment.
     * </p>
     * <p>
     * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request.
     * If you set both, your request returns a <code>BadRequestException</code>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting
     * or identifying personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return Labels all personally identifiable information (PII) identified in your transcript.</p>
     *         <p>
     *         Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
     *         flagged upon complete transcription of an audio segment.
     *         </p>
     *         <p>
     *         You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
     *         request. If you set both, your request returns a <code>BadRequestException</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
     *         personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * @see ContentType
     */
    public final ContentType contentIdentificationType() {
        return ContentType.fromValue(contentIdentificationType);
    }

    /**
     * <p>
     * Labels all personally identifiable information (PII) identified in your transcript.
     * </p>
     * <p>
     * Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is flagged
     * upon complete transcription of an audio segment.
     * </p>
     * <p>
     * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request.
     * If you set both, your request returns a <code>BadRequestException</code>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting
     * or identifying personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return Labels all personally identifiable information (PII) identified in your transcript.</p>
     *         <p>
     *         Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
     *         flagged upon complete transcription of an audio segment.
     *         </p>
     *         <p>
     *         You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
     *         request. If you set both, your request returns a <code>BadRequestException</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
     *         personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * @see ContentType
     */
    public final String contentIdentificationTypeAsString() {
        return contentIdentificationType;
    }

    /**
     * <p>
     * Redacts all personally identifiable information (PII) identified in your transcript.
     * </p>
     * <p>
     * Content redaction is performed at the segment level; PII specified in PiiEntityTypes is redacted upon complete
     * transcription of an audio segment.
     * </p>
     * <p>
     * You can’t set ContentRedactionType and ContentIdentificationType in the same request. If you set both, your
     * request returns a <code>BadRequestException</code>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting
     * or identifying personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentRedactionType} will return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #contentRedactionTypeAsString}.
     * </p>
     * 
     * @return Redacts all personally identifiable information (PII) identified in your transcript.</p>
     *         <p>
     *         Content redaction is performed at the segment level; PII specified in PiiEntityTypes is redacted upon
     *         complete transcription of an audio segment.
     *         </p>
     *         <p>
     *         You can’t set ContentRedactionType and ContentIdentificationType in the same request. If you set both,
     *         your request returns a <code>BadRequestException</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
     *         personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * @see ContentType
     */
    public final ContentType contentRedactionType() {
        return ContentType.fromValue(contentRedactionType);
    }

    /**
     * <p>
     * Redacts all personally identifiable information (PII) identified in your transcript.
     * </p>
     * <p>
     * Content redaction is performed at the segment level; PII specified in PiiEntityTypes is redacted upon complete
     * transcription of an audio segment.
     * </p>
     * <p>
     * You can’t set ContentRedactionType and ContentIdentificationType in the same request. If you set both, your
     * request returns a <code>BadRequestException</code>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting
     * or identifying personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentRedactionType} will return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #contentRedactionTypeAsString}.
     * </p>
     * 
     * @return Redacts all personally identifiable information (PII) identified in your transcript.</p>
     *         <p>
     *         Content redaction is performed at the segment level; PII specified in PiiEntityTypes is redacted upon
     *         complete transcription of an audio segment.
     *         </p>
     *         <p>
     *         You can’t set ContentRedactionType and ContentIdentificationType in the same request. If you set both,
     *         your request returns a <code>BadRequestException</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
     *         personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * @see ContentType
     */
    public final String contentRedactionTypeAsString() {
        return contentRedactionType;
    }

    /**
     * <p>
     * The types of personally identifiable information (PII) to redact from a transcript. You can include as many types
     * as you'd like, or you can select <code>ALL</code>.
     * </p>
     * <p>
     * To include <code>PiiEntityTypes</code> in your Call Analytics request, you must also include
     * <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>, but you can't include both.
     * </p>
     * <p>
     * Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>,
     * <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>,
     * <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>, <code>NAME</code>, <code>PHONE</code>, <code>PIN</code>,
     * <code>SSN</code>, or <code>ALL</code>.
     * </p>
     * <p>
     * If you leave this parameter empty, the default behavior is equivalent to <code>ALL</code>.
     * </p>
     * 
     * @return The types of personally identifiable information (PII) to redact from a transcript. You can include as
     *         many types as you'd like, or you can select <code>ALL</code>.</p>
     *         <p>
     *         To include <code>PiiEntityTypes</code> in your Call Analytics request, you must also include
     *         <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>, but you can't include both.
     *         </p>
     *         <p>
     *         Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>,
     *         <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>,
     *         <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>, <code>NAME</code>, <code>PHONE</code>,
     *         <code>PIN</code>, <code>SSN</code>, or <code>ALL</code>.
     *         </p>
     *         <p>
     *         If you leave this parameter empty, the default behavior is equivalent to <code>ALL</code>.
     */
    public final String piiEntityTypes() {
        return piiEntityTypes;
    }

    /**
     * <p>
     * The name of the custom language model that you want to use when processing your transcription. Note that language
     * model names are case sensitive.
     * </p>
     * <p>
     * The language of the specified language model must match the language code you specify in your transcription
     * request. If the languages don't match, the custom language model isn't applied. There are no errors or warnings
     * associated with a language mismatch.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language models</a> in
     * the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * 
     * @return The name of the custom language model that you want to use when processing your transcription. Note that
     *         language model names are case sensitive.</p>
     *         <p>
     *         The language of the specified language model must match the language code you specify in your
     *         transcription request. If the languages don't match, the custom language model isn't applied. There are
     *         no errors or warnings associated with a language mismatch.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language
     *         models</a> in the <i>Amazon Transcribe Developer Guide</i>.
     */
    public final String languageModelName() {
        return languageModelName;
    }

    /**
     * <p>
     * If true, <code>TranscriptEvents</code> with <code>IsPartial: true</code> are filtered out of the insights target.
     * </p>
     * 
     * @return If true, <code>TranscriptEvents</code> with <code>IsPartial: true</code> are filtered out of the insights
     *         target.
     */
    public final Boolean filterPartialResults() {
        return filterPartialResults;
    }

    /**
     * <p>
     * Turns language identification on or off.
     * </p>
     * 
     * @return Turns language identification on or off.
     */
    public final Boolean identifyLanguage() {
        return identifyLanguage;
    }

    /**
     * <p>
     * The language options for the transcription, such as automatic language detection.
     * </p>
     * 
     * @return The language options for the transcription, such as automatic language detection.
     */
    public final String languageOptions() {
        return languageOptions;
    }

    /**
     * <p>
     * The preferred language for the transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preferredLanguage}
     * will return {@link CallAnalyticsLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #preferredLanguageAsString}.
     * </p>
     * 
     * @return The preferred language for the transcription.
     * @see CallAnalyticsLanguageCode
     */
    public final CallAnalyticsLanguageCode preferredLanguage() {
        return CallAnalyticsLanguageCode.fromValue(preferredLanguage);
    }

    /**
     * <p>
     * The preferred language for the transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preferredLanguage}
     * will return {@link CallAnalyticsLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #preferredLanguageAsString}.
     * </p>
     * 
     * @return The preferred language for the transcription.
     * @see CallAnalyticsLanguageCode
     */
    public final String preferredLanguageAsString() {
        return preferredLanguage;
    }

    /**
     * <p>
     * The names of the custom vocabulary or vocabularies used during transcription.
     * </p>
     * 
     * @return The names of the custom vocabulary or vocabularies used during transcription.
     */
    public final String vocabularyNames() {
        return vocabularyNames;
    }

    /**
     * <p>
     * The names of the custom vocabulary filter or filters using during transcription.
     * </p>
     * 
     * @return The names of the custom vocabulary filter or filters using during transcription.
     */
    public final String vocabularyFilterNames() {
        return vocabularyFilterNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(showSpeakerLabel());
        hashCode = 31 * hashCode + Objects.hashCode(enablePartialResultsStabilization());
        hashCode = 31 * hashCode + Objects.hashCode(partialResultsStabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentIdentificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentRedactionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(piiEntityTypes());
        hashCode = 31 * hashCode + Objects.hashCode(languageModelName());
        hashCode = 31 * hashCode + Objects.hashCode(filterPartialResults());
        hashCode = 31 * hashCode + Objects.hashCode(identifyLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(languageOptions());
        hashCode = 31 * hashCode + Objects.hashCode(preferredLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyNames());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterNames());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonTranscribeProcessorConfiguration)) {
            return false;
        }
        AmazonTranscribeProcessorConfiguration other = (AmazonTranscribeProcessorConfiguration) obj;
        return Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(vocabularyName(), other.vocabularyName())
                && Objects.equals(vocabularyFilterName(), other.vocabularyFilterName())
                && Objects.equals(vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString())
                && Objects.equals(showSpeakerLabel(), other.showSpeakerLabel())
                && Objects.equals(enablePartialResultsStabilization(), other.enablePartialResultsStabilization())
                && Objects.equals(partialResultsStabilityAsString(), other.partialResultsStabilityAsString())
                && Objects.equals(contentIdentificationTypeAsString(), other.contentIdentificationTypeAsString())
                && Objects.equals(contentRedactionTypeAsString(), other.contentRedactionTypeAsString())
                && Objects.equals(piiEntityTypes(), other.piiEntityTypes())
                && Objects.equals(languageModelName(), other.languageModelName())
                && Objects.equals(filterPartialResults(), other.filterPartialResults())
                && Objects.equals(identifyLanguage(), other.identifyLanguage())
                && Objects.equals(languageOptions(), other.languageOptions())
                && Objects.equals(preferredLanguageAsString(), other.preferredLanguageAsString())
                && Objects.equals(vocabularyNames(), other.vocabularyNames())
                && Objects.equals(vocabularyFilterNames(), other.vocabularyFilterNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmazonTranscribeProcessorConfiguration").add("LanguageCode", languageCodeAsString())
                .add("VocabularyName", vocabularyName()).add("VocabularyFilterName", vocabularyFilterName())
                .add("VocabularyFilterMethod", vocabularyFilterMethodAsString()).add("ShowSpeakerLabel", showSpeakerLabel())
                .add("EnablePartialResultsStabilization", enablePartialResultsStabilization())
                .add("PartialResultsStability", partialResultsStabilityAsString())
                .add("ContentIdentificationType", contentIdentificationTypeAsString())
                .add("ContentRedactionType", contentRedactionTypeAsString()).add("PiiEntityTypes", piiEntityTypes())
                .add("LanguageModelName", languageModelName()).add("FilterPartialResults", filterPartialResults())
                .add("IdentifyLanguage", identifyLanguage()).add("LanguageOptions", languageOptions())
                .add("PreferredLanguage", preferredLanguageAsString()).add("VocabularyNames", vocabularyNames())
                .add("VocabularyFilterNames", vocabularyFilterNames()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "VocabularyFilterName":
            return Optional.ofNullable(clazz.cast(vocabularyFilterName()));
        case "VocabularyFilterMethod":
            return Optional.ofNullable(clazz.cast(vocabularyFilterMethodAsString()));
        case "ShowSpeakerLabel":
            return Optional.ofNullable(clazz.cast(showSpeakerLabel()));
        case "EnablePartialResultsStabilization":
            return Optional.ofNullable(clazz.cast(enablePartialResultsStabilization()));
        case "PartialResultsStability":
            return Optional.ofNullable(clazz.cast(partialResultsStabilityAsString()));
        case "ContentIdentificationType":
            return Optional.ofNullable(clazz.cast(contentIdentificationTypeAsString()));
        case "ContentRedactionType":
            return Optional.ofNullable(clazz.cast(contentRedactionTypeAsString()));
        case "PiiEntityTypes":
            return Optional.ofNullable(clazz.cast(piiEntityTypes()));
        case "LanguageModelName":
            return Optional.ofNullable(clazz.cast(languageModelName()));
        case "FilterPartialResults":
            return Optional.ofNullable(clazz.cast(filterPartialResults()));
        case "IdentifyLanguage":
            return Optional.ofNullable(clazz.cast(identifyLanguage()));
        case "LanguageOptions":
            return Optional.ofNullable(clazz.cast(languageOptions()));
        case "PreferredLanguage":
            return Optional.ofNullable(clazz.cast(preferredLanguageAsString()));
        case "VocabularyNames":
            return Optional.ofNullable(clazz.cast(vocabularyNames()));
        case "VocabularyFilterNames":
            return Optional.ofNullable(clazz.cast(vocabularyFilterNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AmazonTranscribeProcessorConfiguration, T> g) {
        return obj -> g.apply((AmazonTranscribeProcessorConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmazonTranscribeProcessorConfiguration> {
        /**
         * <p>
         * The language code that represents the language spoken in your audio.
         * </p>
         * <p>
         * If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable
         * automatic language identification.
         * </p>
         * <p>
         * For a list of languages that real-time Call Analytics supports, see the <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages
         * table</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param languageCode
         *        The language code that represents the language spoken in your audio.</p>
         *        <p>
         *        If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to
         *        enable automatic language identification.
         *        </p>
         *        <p>
         *        For a list of languages that real-time Call Analytics supports, see the <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages
         *        table</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @see CallAnalyticsLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAnalyticsLanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code that represents the language spoken in your audio.
         * </p>
         * <p>
         * If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable
         * automatic language identification.
         * </p>
         * <p>
         * For a list of languages that real-time Call Analytics supports, see the <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages
         * table</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param languageCode
         *        The language code that represents the language spoken in your audio.</p>
         *        <p>
         *        If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to
         *        enable automatic language identification.
         *        </p>
         *        <p>
         *        For a list of languages that real-time Call Analytics supports, see the <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages
         *        table</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @see CallAnalyticsLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAnalyticsLanguageCode
         */
        Builder languageCode(CallAnalyticsLanguageCode languageCode);

        /**
         * <p>
         * The name of the custom vocabulary that you specified in your Call Analytics request.
         * </p>
         * <p>
         * Length Constraints: Minimum length of 1. Maximum length of 200.
         * </p>
         * 
         * @param vocabularyName
         *        The name of the custom vocabulary that you specified in your Call Analytics request.</p>
         *        <p>
         *        Length Constraints: Minimum length of 1. Maximum length of 200.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * The name of the custom vocabulary filter that you specified in your Call Analytics request.
         * </p>
         * <p>
         * Length Constraints: Minimum length of 1. Maximum length of 200.
         * </p>
         * 
         * @param vocabularyFilterName
         *        The name of the custom vocabulary filter that you specified in your Call Analytics request.</p>
         *        <p>
         *        Length Constraints: Minimum length of 1. Maximum length of 200.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterName(String vocabularyFilterName);

        /**
         * <p>
         * The vocabulary filtering method used in your Call Analytics transcription.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        The vocabulary filtering method used in your Call Analytics transcription.
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(String vocabularyFilterMethod);

        /**
         * <p>
         * The vocabulary filtering method used in your Call Analytics transcription.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        The vocabulary filtering method used in your Call Analytics transcription.
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod);

        /**
         * <p>
         * Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the
         * speech from individual speakers in your media file.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
         * (diarization)</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param showSpeakerLabel
         *        Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels
         *        the speech from individual speakers in your media file.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
         *        (diarization)</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showSpeakerLabel(Boolean showSpeakerLabel);

        /**
         * <p>
         * Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency
         * in your output, but may impact accuracy.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         * >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param enablePartialResultsStabilization
         *        Enables partial result stabilization for your transcription. Partial result stabilization can reduce
         *        latency in your output, but may impact accuracy.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         *        >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePartialResultsStabilization(Boolean enablePartialResultsStabilization);

        /**
         * <p>
         * The level of stability to use when you enable partial results stabilization (
         * <code>EnablePartialResultsStabilization</code>).
         * </p>
         * <p>
         * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower
         * accuracy.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         * >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param partialResultsStability
         *        The level of stability to use when you enable partial results stabilization (
         *        <code>EnablePartialResultsStabilization</code>).</p>
         *        <p>
         *        Low stability provides the highest accuracy. High stability transcribes faster, but with slightly
         *        lower accuracy.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         *        >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @see PartialResultsStability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartialResultsStability
         */
        Builder partialResultsStability(String partialResultsStability);

        /**
         * <p>
         * The level of stability to use when you enable partial results stabilization (
         * <code>EnablePartialResultsStabilization</code>).
         * </p>
         * <p>
         * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower
         * accuracy.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         * >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param partialResultsStability
         *        The level of stability to use when you enable partial results stabilization (
         *        <code>EnablePartialResultsStabilization</code>).</p>
         *        <p>
         *        Low stability provides the highest accuracy. High stability transcribes faster, but with slightly
         *        lower accuracy.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         *        >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @see PartialResultsStability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartialResultsStability
         */
        Builder partialResultsStability(PartialResultsStability partialResultsStability);

        /**
         * <p>
         * Labels all personally identifiable information (PII) identified in your transcript.
         * </p>
         * <p>
         * Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
         * flagged upon complete transcription of an audio segment.
         * </p>
         * <p>
         * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
         * request. If you set both, your request returns a <code>BadRequestException</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         * personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param contentIdentificationType
         *        Labels all personally identifiable information (PII) identified in your transcript.</p>
         *        <p>
         *        Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code>
         *        is flagged upon complete transcription of an audio segment.
         *        </p>
         *        <p>
         *        You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
         *        request. If you set both, your request returns a <code>BadRequestException</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         *        personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentIdentificationType(String contentIdentificationType);

        /**
         * <p>
         * Labels all personally identifiable information (PII) identified in your transcript.
         * </p>
         * <p>
         * Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
         * flagged upon complete transcription of an audio segment.
         * </p>
         * <p>
         * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
         * request. If you set both, your request returns a <code>BadRequestException</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         * personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param contentIdentificationType
         *        Labels all personally identifiable information (PII) identified in your transcript.</p>
         *        <p>
         *        Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code>
         *        is flagged upon complete transcription of an audio segment.
         *        </p>
         *        <p>
         *        You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
         *        request. If you set both, your request returns a <code>BadRequestException</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         *        personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentIdentificationType(ContentType contentIdentificationType);

        /**
         * <p>
         * Redacts all personally identifiable information (PII) identified in your transcript.
         * </p>
         * <p>
         * Content redaction is performed at the segment level; PII specified in PiiEntityTypes is redacted upon
         * complete transcription of an audio segment.
         * </p>
         * <p>
         * You can’t set ContentRedactionType and ContentIdentificationType in the same request. If you set both, your
         * request returns a <code>BadRequestException</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         * personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param contentRedactionType
         *        Redacts all personally identifiable information (PII) identified in your transcript.</p>
         *        <p>
         *        Content redaction is performed at the segment level; PII specified in PiiEntityTypes is redacted upon
         *        complete transcription of an audio segment.
         *        </p>
         *        <p>
         *        You can’t set ContentRedactionType and ContentIdentificationType in the same request. If you set both,
         *        your request returns a <code>BadRequestException</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         *        personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentRedactionType(String contentRedactionType);

        /**
         * <p>
         * Redacts all personally identifiable information (PII) identified in your transcript.
         * </p>
         * <p>
         * Content redaction is performed at the segment level; PII specified in PiiEntityTypes is redacted upon
         * complete transcription of an audio segment.
         * </p>
         * <p>
         * You can’t set ContentRedactionType and ContentIdentificationType in the same request. If you set both, your
         * request returns a <code>BadRequestException</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         * personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param contentRedactionType
         *        Redacts all personally identifiable information (PII) identified in your transcript.</p>
         *        <p>
         *        Content redaction is performed at the segment level; PII specified in PiiEntityTypes is redacted upon
         *        complete transcription of an audio segment.
         *        </p>
         *        <p>
         *        You can’t set ContentRedactionType and ContentIdentificationType in the same request. If you set both,
         *        your request returns a <code>BadRequestException</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         *        personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentRedactionType(ContentType contentRedactionType);

        /**
         * <p>
         * The types of personally identifiable information (PII) to redact from a transcript. You can include as many
         * types as you'd like, or you can select <code>ALL</code>.
         * </p>
         * <p>
         * To include <code>PiiEntityTypes</code> in your Call Analytics request, you must also include
         * <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>, but you can't include both.
         * </p>
         * <p>
         * Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>,
         * <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>,
         * <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>, <code>NAME</code>, <code>PHONE</code>, <code>PIN</code>, <code>SSN</code>, or <code>ALL</code>.
         * </p>
         * <p>
         * If you leave this parameter empty, the default behavior is equivalent to <code>ALL</code>.
         * </p>
         * 
         * @param piiEntityTypes
         *        The types of personally identifiable information (PII) to redact from a transcript. You can include as
         *        many types as you'd like, or you can select <code>ALL</code>.</p>
         *        <p>
         *        To include <code>PiiEntityTypes</code> in your Call Analytics request, you must also include
         *        <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>, but you can't include
         *        both.
         *        </p>
         *        <p>
         *        Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>,
         *        <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>, <code>NAME</code>, <code>PHONE</code>,
         *        <code>PIN</code>, <code>SSN</code>, or <code>ALL</code>.
         *        </p>
         *        <p>
         *        If you leave this parameter empty, the default behavior is equivalent to <code>ALL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder piiEntityTypes(String piiEntityTypes);

        /**
         * <p>
         * The name of the custom language model that you want to use when processing your transcription. Note that
         * language model names are case sensitive.
         * </p>
         * <p>
         * The language of the specified language model must match the language code you specify in your transcription
         * request. If the languages don't match, the custom language model isn't applied. There are no errors or
         * warnings associated with a language mismatch.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language
         * models</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param languageModelName
         *        The name of the custom language model that you want to use when processing your transcription. Note
         *        that language model names are case sensitive.</p>
         *        <p>
         *        The language of the specified language model must match the language code you specify in your
         *        transcription request. If the languages don't match, the custom language model isn't applied. There
         *        are no errors or warnings associated with a language mismatch.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language
         *        models</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageModelName(String languageModelName);

        /**
         * <p>
         * If true, <code>TranscriptEvents</code> with <code>IsPartial: true</code> are filtered out of the insights
         * target.
         * </p>
         * 
         * @param filterPartialResults
         *        If true, <code>TranscriptEvents</code> with <code>IsPartial: true</code> are filtered out of the
         *        insights target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPartialResults(Boolean filterPartialResults);

        /**
         * <p>
         * Turns language identification on or off.
         * </p>
         * 
         * @param identifyLanguage
         *        Turns language identification on or off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifyLanguage(Boolean identifyLanguage);

        /**
         * <p>
         * The language options for the transcription, such as automatic language detection.
         * </p>
         * 
         * @param languageOptions
         *        The language options for the transcription, such as automatic language detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageOptions(String languageOptions);

        /**
         * <p>
         * The preferred language for the transcription.
         * </p>
         * 
         * @param preferredLanguage
         *        The preferred language for the transcription.
         * @see CallAnalyticsLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAnalyticsLanguageCode
         */
        Builder preferredLanguage(String preferredLanguage);

        /**
         * <p>
         * The preferred language for the transcription.
         * </p>
         * 
         * @param preferredLanguage
         *        The preferred language for the transcription.
         * @see CallAnalyticsLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAnalyticsLanguageCode
         */
        Builder preferredLanguage(CallAnalyticsLanguageCode preferredLanguage);

        /**
         * <p>
         * The names of the custom vocabulary or vocabularies used during transcription.
         * </p>
         * 
         * @param vocabularyNames
         *        The names of the custom vocabulary or vocabularies used during transcription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyNames(String vocabularyNames);

        /**
         * <p>
         * The names of the custom vocabulary filter or filters using during transcription.
         * </p>
         * 
         * @param vocabularyFilterNames
         *        The names of the custom vocabulary filter or filters using during transcription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterNames(String vocabularyFilterNames);
    }

    static final class BuilderImpl implements Builder {
        private String languageCode;

        private String vocabularyName;

        private String vocabularyFilterName;

        private String vocabularyFilterMethod;

        private Boolean showSpeakerLabel;

        private Boolean enablePartialResultsStabilization;

        private String partialResultsStability;

        private String contentIdentificationType;

        private String contentRedactionType;

        private String piiEntityTypes;

        private String languageModelName;

        private Boolean filterPartialResults;

        private Boolean identifyLanguage;

        private String languageOptions;

        private String preferredLanguage;

        private String vocabularyNames;

        private String vocabularyFilterNames;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonTranscribeProcessorConfiguration model) {
            languageCode(model.languageCode);
            vocabularyName(model.vocabularyName);
            vocabularyFilterName(model.vocabularyFilterName);
            vocabularyFilterMethod(model.vocabularyFilterMethod);
            showSpeakerLabel(model.showSpeakerLabel);
            enablePartialResultsStabilization(model.enablePartialResultsStabilization);
            partialResultsStability(model.partialResultsStability);
            contentIdentificationType(model.contentIdentificationType);
            contentRedactionType(model.contentRedactionType);
            piiEntityTypes(model.piiEntityTypes);
            languageModelName(model.languageModelName);
            filterPartialResults(model.filterPartialResults);
            identifyLanguage(model.identifyLanguage);
            languageOptions(model.languageOptions);
            preferredLanguage(model.preferredLanguage);
            vocabularyNames(model.vocabularyNames);
            vocabularyFilterNames(model.vocabularyFilterNames);
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(CallAnalyticsLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getVocabularyFilterName() {
            return vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        public final Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final Boolean getShowSpeakerLabel() {
            return showSpeakerLabel;
        }

        public final void setShowSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
        }

        @Override
        public final Builder showSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
            return this;
        }

        public final Boolean getEnablePartialResultsStabilization() {
            return enablePartialResultsStabilization;
        }

        public final void setEnablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
        }

        @Override
        public final Builder enablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
            return this;
        }

        public final String getPartialResultsStability() {
            return partialResultsStability;
        }

        public final void setPartialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
        }

        @Override
        public final Builder partialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
            return this;
        }

        @Override
        public final Builder partialResultsStability(PartialResultsStability partialResultsStability) {
            this.partialResultsStability(partialResultsStability == null ? null : partialResultsStability.toString());
            return this;
        }

        public final String getContentIdentificationType() {
            return contentIdentificationType;
        }

        public final void setContentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
        }

        @Override
        public final Builder contentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
            return this;
        }

        @Override
        public final Builder contentIdentificationType(ContentType contentIdentificationType) {
            this.contentIdentificationType(contentIdentificationType == null ? null : contentIdentificationType.toString());
            return this;
        }

        public final String getContentRedactionType() {
            return contentRedactionType;
        }

        public final void setContentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
        }

        @Override
        public final Builder contentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
            return this;
        }

        @Override
        public final Builder contentRedactionType(ContentType contentRedactionType) {
            this.contentRedactionType(contentRedactionType == null ? null : contentRedactionType.toString());
            return this;
        }

        public final String getPiiEntityTypes() {
            return piiEntityTypes;
        }

        public final void setPiiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
        }

        @Override
        public final Builder piiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
            return this;
        }

        public final String getLanguageModelName() {
            return languageModelName;
        }

        public final void setLanguageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
        }

        @Override
        public final Builder languageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
            return this;
        }

        public final Boolean getFilterPartialResults() {
            return filterPartialResults;
        }

        public final void setFilterPartialResults(Boolean filterPartialResults) {
            this.filterPartialResults = filterPartialResults;
        }

        @Override
        public final Builder filterPartialResults(Boolean filterPartialResults) {
            this.filterPartialResults = filterPartialResults;
            return this;
        }

        public final Boolean getIdentifyLanguage() {
            return identifyLanguage;
        }

        public final void setIdentifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
        }

        @Override
        public final Builder identifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
            return this;
        }

        public final String getLanguageOptions() {
            return languageOptions;
        }

        public final void setLanguageOptions(String languageOptions) {
            this.languageOptions = languageOptions;
        }

        @Override
        public final Builder languageOptions(String languageOptions) {
            this.languageOptions = languageOptions;
            return this;
        }

        public final String getPreferredLanguage() {
            return preferredLanguage;
        }

        public final void setPreferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
        }

        @Override
        public final Builder preferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            return this;
        }

        @Override
        public final Builder preferredLanguage(CallAnalyticsLanguageCode preferredLanguage) {
            this.preferredLanguage(preferredLanguage == null ? null : preferredLanguage.toString());
            return this;
        }

        public final String getVocabularyNames() {
            return vocabularyNames;
        }

        public final void setVocabularyNames(String vocabularyNames) {
            this.vocabularyNames = vocabularyNames;
        }

        @Override
        public final Builder vocabularyNames(String vocabularyNames) {
            this.vocabularyNames = vocabularyNames;
            return this;
        }

        public final String getVocabularyFilterNames() {
            return vocabularyFilterNames;
        }

        public final void setVocabularyFilterNames(String vocabularyFilterNames) {
            this.vocabularyFilterNames = vocabularyFilterNames;
        }

        @Override
        public final Builder vocabularyFilterNames(String vocabularyFilterNames) {
            this.vocabularyFilterNames = vocabularyFilterNames;
            return this;
        }

        @Override
        public AmazonTranscribeProcessorConfiguration build() {
            return new AmazonTranscribeProcessorConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
