/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMediaPipelineResponse extends ChimeSdkMediaPipelinesResponse implements
        ToCopyableBuilder<GetMediaPipelineResponse.Builder, GetMediaPipelineResponse> {
    private static final SdkField<MediaPipeline> MEDIA_PIPELINE_FIELD = SdkField
            .<MediaPipeline> builder(MarshallingType.SDK_POJO).memberName("MediaPipeline")
            .getter(getter(GetMediaPipelineResponse::mediaPipeline)).setter(setter(Builder::mediaPipeline))
            .constructor(MediaPipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPipeline").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_PIPELINE_FIELD));

    private final MediaPipeline mediaPipeline;

    private GetMediaPipelineResponse(BuilderImpl builder) {
        super(builder);
        this.mediaPipeline = builder.mediaPipeline;
    }

    /**
     * <p>
     * The media pipeline object.
     * </p>
     * 
     * @return The media pipeline object.
     */
    public final MediaPipeline mediaPipeline() {
        return mediaPipeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mediaPipeline());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMediaPipelineResponse)) {
            return false;
        }
        GetMediaPipelineResponse other = (GetMediaPipelineResponse) obj;
        return Objects.equals(mediaPipeline(), other.mediaPipeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMediaPipelineResponse").add("MediaPipeline", mediaPipeline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaPipeline":
            return Optional.ofNullable(clazz.cast(mediaPipeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMediaPipelineResponse, T> g) {
        return obj -> g.apply((GetMediaPipelineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMediaPipelinesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMediaPipelineResponse> {
        /**
         * <p>
         * The media pipeline object.
         * </p>
         * 
         * @param mediaPipeline
         *        The media pipeline object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPipeline(MediaPipeline mediaPipeline);

        /**
         * <p>
         * The media pipeline object.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaPipeline.Builder} avoiding the need
         * to create one manually via {@link MediaPipeline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaPipeline.Builder#build()} is called immediately and its
         * result is passed to {@link #mediaPipeline(MediaPipeline)}.
         * 
         * @param mediaPipeline
         *        a consumer that will call methods on {@link MediaPipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaPipeline(MediaPipeline)
         */
        default Builder mediaPipeline(Consumer<MediaPipeline.Builder> mediaPipeline) {
            return mediaPipeline(MediaPipeline.builder().applyMutation(mediaPipeline).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesResponse.BuilderImpl implements Builder {
        private MediaPipeline mediaPipeline;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMediaPipelineResponse model) {
            super(model);
            mediaPipeline(model.mediaPipeline);
        }

        public final MediaPipeline.Builder getMediaPipeline() {
            return mediaPipeline != null ? mediaPipeline.toBuilder() : null;
        }

        public final void setMediaPipeline(MediaPipeline.BuilderImpl mediaPipeline) {
            this.mediaPipeline = mediaPipeline != null ? mediaPipeline.build() : null;
        }

        @Override
        public final Builder mediaPipeline(MediaPipeline mediaPipeline) {
            this.mediaPipeline = mediaPipeline;
            return this;
        }

        @Override
        public GetMediaPipelineResponse build() {
            return new GetMediaPipelineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
