/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The runtime configuration settings for the Kinesis video stream source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisVideoStreamSourceRuntimeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisVideoStreamSourceRuntimeConfiguration.Builder, KinesisVideoStreamSourceRuntimeConfiguration> {
    private static final SdkField<List<StreamConfiguration>> STREAMS_FIELD = SdkField
            .<List<StreamConfiguration>> builder(MarshallingType.LIST)
            .memberName("Streams")
            .getter(getter(KinesisVideoStreamSourceRuntimeConfiguration::streams))
            .setter(setter(Builder::streams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Streams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StreamConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(StreamConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MEDIA_ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaEncoding").getter(getter(KinesisVideoStreamSourceRuntimeConfiguration::mediaEncodingAsString))
            .setter(setter(Builder::mediaEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaEncoding").build()).build();

    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MediaSampleRate").getter(getter(KinesisVideoStreamSourceRuntimeConfiguration::mediaSampleRate))
            .setter(setter(Builder::mediaSampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaSampleRate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMS_FIELD,
            MEDIA_ENCODING_FIELD, MEDIA_SAMPLE_RATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<StreamConfiguration> streams;

    private final String mediaEncoding;

    private final Integer mediaSampleRate;

    private KinesisVideoStreamSourceRuntimeConfiguration(BuilderImpl builder) {
        this.streams = builder.streams;
        this.mediaEncoding = builder.mediaEncoding;
        this.mediaSampleRate = builder.mediaSampleRate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Streams property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStreams() {
        return streams != null && !(streams instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The streams in the source runtime configuration of a Kinesis video stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStreams} method.
     * </p>
     * 
     * @return The streams in the source runtime configuration of a Kinesis video stream.
     */
    public final List<StreamConfiguration> streams() {
        return streams;
    }

    /**
     * <p>
     * Specifies the encoding of your input audio. Supported format: PCM (only signed 16-bit little-endian audio
     * formats, which does not include WAV)
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a> in the
     * <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaEncoding}
     * will return {@link MediaEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaEncodingAsString}.
     * </p>
     * 
     * @return Specifies the encoding of your input audio. Supported format: PCM (only signed 16-bit little-endian audio
     *         formats, which does not include WAV)</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>
     *         in the <i>Amazon Transcribe Developer Guide</i>.
     * @see MediaEncoding
     */
    public final MediaEncoding mediaEncoding() {
        return MediaEncoding.fromValue(mediaEncoding);
    }

    /**
     * <p>
     * Specifies the encoding of your input audio. Supported format: PCM (only signed 16-bit little-endian audio
     * formats, which does not include WAV)
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a> in the
     * <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaEncoding}
     * will return {@link MediaEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaEncodingAsString}.
     * </p>
     * 
     * @return Specifies the encoding of your input audio. Supported format: PCM (only signed 16-bit little-endian audio
     *         formats, which does not include WAV)</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>
     *         in the <i>Amazon Transcribe Developer Guide</i>.
     * @see MediaEncoding
     */
    public final String mediaEncodingAsString() {
        return mediaEncoding;
    }

    /**
     * <p>
     * The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is typically around
     * 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify
     * must match that of your audio.
     * </p>
     * <p>
     * Valid Range: Minimum value of 8000. Maximum value of 48000.
     * </p>
     * 
     * @return The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is typically
     *         around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample
     *         rate you specify must match that of your audio.</p>
     *         <p>
     *         Valid Range: Minimum value of 8000. Maximum value of 48000.
     */
    public final Integer mediaSampleRate() {
        return mediaSampleRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStreams() ? streams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(mediaEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mediaSampleRate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisVideoStreamSourceRuntimeConfiguration)) {
            return false;
        }
        KinesisVideoStreamSourceRuntimeConfiguration other = (KinesisVideoStreamSourceRuntimeConfiguration) obj;
        return hasStreams() == other.hasStreams() && Objects.equals(streams(), other.streams())
                && Objects.equals(mediaEncodingAsString(), other.mediaEncodingAsString())
                && Objects.equals(mediaSampleRate(), other.mediaSampleRate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisVideoStreamSourceRuntimeConfiguration").add("Streams", hasStreams() ? streams() : null)
                .add("MediaEncoding", mediaEncodingAsString()).add("MediaSampleRate", mediaSampleRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Streams":
            return Optional.ofNullable(clazz.cast(streams()));
        case "MediaEncoding":
            return Optional.ofNullable(clazz.cast(mediaEncodingAsString()));
        case "MediaSampleRate":
            return Optional.ofNullable(clazz.cast(mediaSampleRate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisVideoStreamSourceRuntimeConfiguration, T> g) {
        return obj -> g.apply((KinesisVideoStreamSourceRuntimeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisVideoStreamSourceRuntimeConfiguration> {
        /**
         * <p>
         * The streams in the source runtime configuration of a Kinesis video stream.
         * </p>
         * 
         * @param streams
         *        The streams in the source runtime configuration of a Kinesis video stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(Collection<StreamConfiguration> streams);

        /**
         * <p>
         * The streams in the source runtime configuration of a Kinesis video stream.
         * </p>
         * 
         * @param streams
         *        The streams in the source runtime configuration of a Kinesis video stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(StreamConfiguration... streams);

        /**
         * <p>
         * The streams in the source runtime configuration of a Kinesis video stream.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.StreamConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.StreamConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.StreamConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #streams(List<StreamConfiguration>)}.
         * 
         * @param streams
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.StreamConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streams(java.util.Collection<StreamConfiguration>)
         */
        Builder streams(Consumer<StreamConfiguration.Builder>... streams);

        /**
         * <p>
         * Specifies the encoding of your input audio. Supported format: PCM (only signed 16-bit little-endian audio
         * formats, which does not include WAV)
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a> in
         * the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param mediaEncoding
         *        Specifies the encoding of your input audio. Supported format: PCM (only signed 16-bit little-endian
         *        audio formats, which does not include WAV)</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media
         *        formats</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @see MediaEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaEncoding
         */
        Builder mediaEncoding(String mediaEncoding);

        /**
         * <p>
         * Specifies the encoding of your input audio. Supported format: PCM (only signed 16-bit little-endian audio
         * formats, which does not include WAV)
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a> in
         * the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param mediaEncoding
         *        Specifies the encoding of your input audio. Supported format: PCM (only signed 16-bit little-endian
         *        audio formats, which does not include WAV)</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media
         *        formats</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @see MediaEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaEncoding
         */
        Builder mediaEncoding(MediaEncoding mediaEncoding);

        /**
         * <p>
         * The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is typically
         * around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate
         * you specify must match that of your audio.
         * </p>
         * <p>
         * Valid Range: Minimum value of 8000. Maximum value of 48000.
         * </p>
         * 
         * @param mediaSampleRate
         *        The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is
         *        typically around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that
         *        the sample rate you specify must match that of your audio.</p>
         *        <p>
         *        Valid Range: Minimum value of 8000. Maximum value of 48000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaSampleRate(Integer mediaSampleRate);
    }

    static final class BuilderImpl implements Builder {
        private List<StreamConfiguration> streams = DefaultSdkAutoConstructList.getInstance();

        private String mediaEncoding;

        private Integer mediaSampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisVideoStreamSourceRuntimeConfiguration model) {
            streams(model.streams);
            mediaEncoding(model.mediaEncoding);
            mediaSampleRate(model.mediaSampleRate);
        }

        public final List<StreamConfiguration.Builder> getStreams() {
            List<StreamConfiguration.Builder> result = StreamsCopier.copyToBuilder(this.streams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreams(Collection<StreamConfiguration.BuilderImpl> streams) {
            this.streams = StreamsCopier.copyFromBuilder(streams);
        }

        @Override
        public final Builder streams(Collection<StreamConfiguration> streams) {
            this.streams = StreamsCopier.copy(streams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(StreamConfiguration... streams) {
            streams(Arrays.asList(streams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(Consumer<StreamConfiguration.Builder>... streams) {
            streams(Stream.of(streams).map(c -> StreamConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMediaEncoding() {
            return mediaEncoding;
        }

        public final void setMediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
        }

        @Override
        public final Builder mediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
            return this;
        }

        @Override
        public final Builder mediaEncoding(MediaEncoding mediaEncoding) {
            this.mediaEncoding(mediaEncoding == null ? null : mediaEncoding.toString());
            return this;
        }

        public final Integer getMediaSampleRate() {
            return mediaSampleRate;
        }

        public final void setMediaSampleRate(Integer mediaSampleRate) {
            this.mediaSampleRate = mediaSampleRate;
        }

        @Override
        public final Builder mediaSampleRate(Integer mediaSampleRate) {
            this.mediaSampleRate = mediaSampleRate;
            return this;
        }

        @Override
        public KinesisVideoStreamSourceRuntimeConfiguration build() {
            return new KinesisVideoStreamSourceRuntimeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
