/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmediapipelines.ChimeSdkMediaPipelinesClient;
import software.amazon.awssdk.services.chimesdkmediapipelines.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesResponse;

public class ListMediaPipelinesIterable
implements SdkIterable<ListMediaPipelinesResponse> {
    private final ChimeSdkMediaPipelinesClient client;
    private final ListMediaPipelinesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMediaPipelinesIterable(ChimeSdkMediaPipelinesClient client, ListMediaPipelinesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMediaPipelinesResponseFetcher();
    }

    public Iterator<ListMediaPipelinesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMediaPipelinesResponseFetcher
    implements SyncPageFetcher<ListMediaPipelinesResponse> {
        private ListMediaPipelinesResponseFetcher() {
        }

        public boolean hasNextPage(ListMediaPipelinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMediaPipelinesResponse nextPage(ListMediaPipelinesResponse previousPage) {
            if (previousPage == null) {
                return ListMediaPipelinesIterable.this.client.listMediaPipelines(ListMediaPipelinesIterable.this.firstRequest);
            }
            return ListMediaPipelinesIterable.this.client.listMediaPipelines((ListMediaPipelinesRequest)((Object)ListMediaPipelinesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

