/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMediaCapturePipelineRequest extends ChimeSdkMediaPipelinesRequest implements
        ToCopyableBuilder<GetMediaCapturePipelineRequest.Builder, GetMediaCapturePipelineRequest> {
    private static final SdkField<String> MEDIA_PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaPipelineId").getter(getter(GetMediaCapturePipelineRequest::mediaPipelineId))
            .setter(setter(Builder::mediaPipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("mediaPipelineId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_PIPELINE_ID_FIELD));

    private final String mediaPipelineId;

    private GetMediaCapturePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.mediaPipelineId = builder.mediaPipelineId;
    }

    /**
     * <p>
     * The ID of the pipeline that you want to get.
     * </p>
     * 
     * @return The ID of the pipeline that you want to get.
     */
    public final String mediaPipelineId() {
        return mediaPipelineId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mediaPipelineId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMediaCapturePipelineRequest)) {
            return false;
        }
        GetMediaCapturePipelineRequest other = (GetMediaCapturePipelineRequest) obj;
        return Objects.equals(mediaPipelineId(), other.mediaPipelineId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMediaCapturePipelineRequest").add("MediaPipelineId", mediaPipelineId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaPipelineId":
            return Optional.ofNullable(clazz.cast(mediaPipelineId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMediaCapturePipelineRequest, T> g) {
        return obj -> g.apply((GetMediaCapturePipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMediaPipelinesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMediaCapturePipelineRequest> {
        /**
         * <p>
         * The ID of the pipeline that you want to get.
         * </p>
         * 
         * @param mediaPipelineId
         *        The ID of the pipeline that you want to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPipelineId(String mediaPipelineId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesRequest.BuilderImpl implements Builder {
        private String mediaPipelineId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMediaCapturePipelineRequest model) {
            super(model);
            mediaPipelineId(model.mediaPipelineId);
        }

        public final String getMediaPipelineId() {
            return mediaPipelineId;
        }

        public final void setMediaPipelineId(String mediaPipelineId) {
            this.mediaPipelineId = mediaPipelineId;
        }

        @Override
        public final Builder mediaPipelineId(String mediaPipelineId) {
            this.mediaPipelineId = mediaPipelineId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMediaCapturePipelineRequest build() {
            return new GetMediaCapturePipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
