/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content configuration object's data channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataChannelConcatenationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataChannelConcatenationConfiguration.Builder, DataChannelConcatenationConfiguration> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DataChannelConcatenationConfiguration::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String state;

    private DataChannelConcatenationConfiguration(BuilderImpl builder) {
        this.state = builder.state;
    }

    /**
     * <p>
     * Enables or disables the configuration object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ArtifactsConcatenationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return Enables or disables the configuration object.
     * @see ArtifactsConcatenationState
     */
    public final ArtifactsConcatenationState state() {
        return ArtifactsConcatenationState.fromValue(state);
    }

    /**
     * <p>
     * Enables or disables the configuration object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ArtifactsConcatenationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return Enables or disables the configuration object.
     * @see ArtifactsConcatenationState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataChannelConcatenationConfiguration)) {
            return false;
        }
        DataChannelConcatenationConfiguration other = (DataChannelConcatenationConfiguration) obj;
        return Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataChannelConcatenationConfiguration").add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataChannelConcatenationConfiguration, T> g) {
        return obj -> g.apply((DataChannelConcatenationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataChannelConcatenationConfiguration> {
        /**
         * <p>
         * Enables or disables the configuration object.
         * </p>
         * 
         * @param state
         *        Enables or disables the configuration object.
         * @see ArtifactsConcatenationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactsConcatenationState
         */
        Builder state(String state);

        /**
         * <p>
         * Enables or disables the configuration object.
         * </p>
         * 
         * @param state
         *        Enables or disables the configuration object.
         * @see ArtifactsConcatenationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactsConcatenationState
         */
        Builder state(ArtifactsConcatenationState state);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(DataChannelConcatenationConfiguration model) {
            state(model.state);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ArtifactsConcatenationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public DataChannelConcatenationConfiguration build() {
            return new DataChannelConcatenationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
