/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source type and media pipeline configuration settings in a configuration object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConcatenationSource implements SdkPojo, Serializable,
        ToCopyableBuilder<ConcatenationSource.Builder, ConcatenationSource> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ConcatenationSource::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<MediaCapturePipelineSourceConfiguration> MEDIA_CAPTURE_PIPELINE_SOURCE_CONFIGURATION_FIELD = SdkField
            .<MediaCapturePipelineSourceConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("MediaCapturePipelineSourceConfiguration")
            .getter(getter(ConcatenationSource::mediaCapturePipelineSourceConfiguration))
            .setter(setter(Builder::mediaCapturePipelineSourceConfiguration))
            .constructor(MediaCapturePipelineSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MediaCapturePipelineSourceConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            MEDIA_CAPTURE_PIPELINE_SOURCE_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final MediaCapturePipelineSourceConfiguration mediaCapturePipelineSourceConfiguration;

    private ConcatenationSource(BuilderImpl builder) {
        this.type = builder.type;
        this.mediaCapturePipelineSourceConfiguration = builder.mediaCapturePipelineSourceConfiguration;
    }

    /**
     * <p>
     * The type of concatenation source in a configuration object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConcatenationSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of concatenation source in a configuration object.
     * @see ConcatenationSourceType
     */
    public final ConcatenationSourceType type() {
        return ConcatenationSourceType.fromValue(type);
    }

    /**
     * <p>
     * The type of concatenation source in a configuration object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConcatenationSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of concatenation source in a configuration object.
     * @see ConcatenationSourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The concatenation settings for the media pipeline in a configuration object.
     * </p>
     * 
     * @return The concatenation settings for the media pipeline in a configuration object.
     */
    public final MediaCapturePipelineSourceConfiguration mediaCapturePipelineSourceConfiguration() {
        return mediaCapturePipelineSourceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mediaCapturePipelineSourceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConcatenationSource)) {
            return false;
        }
        ConcatenationSource other = (ConcatenationSource) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(mediaCapturePipelineSourceConfiguration(), other.mediaCapturePipelineSourceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConcatenationSource").add("Type", typeAsString())
                .add("MediaCapturePipelineSourceConfiguration", mediaCapturePipelineSourceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "MediaCapturePipelineSourceConfiguration":
            return Optional.ofNullable(clazz.cast(mediaCapturePipelineSourceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConcatenationSource, T> g) {
        return obj -> g.apply((ConcatenationSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConcatenationSource> {
        /**
         * <p>
         * The type of concatenation source in a configuration object.
         * </p>
         * 
         * @param type
         *        The type of concatenation source in a configuration object.
         * @see ConcatenationSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConcatenationSourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of concatenation source in a configuration object.
         * </p>
         * 
         * @param type
         *        The type of concatenation source in a configuration object.
         * @see ConcatenationSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConcatenationSourceType
         */
        Builder type(ConcatenationSourceType type);

        /**
         * <p>
         * The concatenation settings for the media pipeline in a configuration object.
         * </p>
         * 
         * @param mediaCapturePipelineSourceConfiguration
         *        The concatenation settings for the media pipeline in a configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaCapturePipelineSourceConfiguration(
                MediaCapturePipelineSourceConfiguration mediaCapturePipelineSourceConfiguration);

        /**
         * <p>
         * The concatenation settings for the media pipeline in a configuration object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MediaCapturePipelineSourceConfiguration.Builder} avoiding the need to create one manually via
         * {@link MediaCapturePipelineSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaCapturePipelineSourceConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #mediaCapturePipelineSourceConfiguration(MediaCapturePipelineSourceConfiguration)}.
         * 
         * @param mediaCapturePipelineSourceConfiguration
         *        a consumer that will call methods on {@link MediaCapturePipelineSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaCapturePipelineSourceConfiguration(MediaCapturePipelineSourceConfiguration)
         */
        default Builder mediaCapturePipelineSourceConfiguration(
                Consumer<MediaCapturePipelineSourceConfiguration.Builder> mediaCapturePipelineSourceConfiguration) {
            return mediaCapturePipelineSourceConfiguration(MediaCapturePipelineSourceConfiguration.builder()
                    .applyMutation(mediaCapturePipelineSourceConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private MediaCapturePipelineSourceConfiguration mediaCapturePipelineSourceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ConcatenationSource model) {
            type(model.type);
            mediaCapturePipelineSourceConfiguration(model.mediaCapturePipelineSourceConfiguration);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ConcatenationSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final MediaCapturePipelineSourceConfiguration.Builder getMediaCapturePipelineSourceConfiguration() {
            return mediaCapturePipelineSourceConfiguration != null ? mediaCapturePipelineSourceConfiguration.toBuilder() : null;
        }

        public final void setMediaCapturePipelineSourceConfiguration(
                MediaCapturePipelineSourceConfiguration.BuilderImpl mediaCapturePipelineSourceConfiguration) {
            this.mediaCapturePipelineSourceConfiguration = mediaCapturePipelineSourceConfiguration != null ? mediaCapturePipelineSourceConfiguration
                    .build() : null;
        }

        @Override
        public final Builder mediaCapturePipelineSourceConfiguration(
                MediaCapturePipelineSourceConfiguration mediaCapturePipelineSourceConfiguration) {
            this.mediaCapturePipelineSourceConfiguration = mediaCapturePipelineSourceConfiguration;
            return this;
        }

        @Override
        public ConcatenationSource build() {
            return new ConcatenationSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
