/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMediaPipelineKinesisVideoStreamPoolResponse extends ChimeSdkMediaPipelinesResponse
        implements
        ToCopyableBuilder<CreateMediaPipelineKinesisVideoStreamPoolResponse.Builder, CreateMediaPipelineKinesisVideoStreamPoolResponse> {
    private static final SdkField<KinesisVideoStreamPoolConfiguration> KINESIS_VIDEO_STREAM_POOL_CONFIGURATION_FIELD = SdkField
            .<KinesisVideoStreamPoolConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisVideoStreamPoolConfiguration")
            .getter(getter(CreateMediaPipelineKinesisVideoStreamPoolResponse::kinesisVideoStreamPoolConfiguration))
            .setter(setter(Builder::kinesisVideoStreamPoolConfiguration))
            .constructor(KinesisVideoStreamPoolConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("KinesisVideoStreamPoolConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(KINESIS_VIDEO_STREAM_POOL_CONFIGURATION_FIELD));

    private final KinesisVideoStreamPoolConfiguration kinesisVideoStreamPoolConfiguration;

    private CreateMediaPipelineKinesisVideoStreamPoolResponse(BuilderImpl builder) {
        super(builder);
        this.kinesisVideoStreamPoolConfiguration = builder.kinesisVideoStreamPoolConfiguration;
    }

    /**
     * <p>
     * The configuration for applying the streams to the pool.
     * </p>
     * <note>
     * <p/>
     * </note>
     * 
     * @return The configuration for applying the streams to the pool.
     *         </p>
     *         <note>
     *         <p/>
     */
    public final KinesisVideoStreamPoolConfiguration kinesisVideoStreamPoolConfiguration() {
        return kinesisVideoStreamPoolConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(kinesisVideoStreamPoolConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMediaPipelineKinesisVideoStreamPoolResponse)) {
            return false;
        }
        CreateMediaPipelineKinesisVideoStreamPoolResponse other = (CreateMediaPipelineKinesisVideoStreamPoolResponse) obj;
        return Objects.equals(kinesisVideoStreamPoolConfiguration(), other.kinesisVideoStreamPoolConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMediaPipelineKinesisVideoStreamPoolResponse")
                .add("KinesisVideoStreamPoolConfiguration", kinesisVideoStreamPoolConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KinesisVideoStreamPoolConfiguration":
            return Optional.ofNullable(clazz.cast(kinesisVideoStreamPoolConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMediaPipelineKinesisVideoStreamPoolResponse, T> g) {
        return obj -> g.apply((CreateMediaPipelineKinesisVideoStreamPoolResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMediaPipelinesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMediaPipelineKinesisVideoStreamPoolResponse> {
        /**
         * <p>
         * The configuration for applying the streams to the pool.
         * </p>
         * <note>
         * <p/>
         * </note>
         * 
         * @param kinesisVideoStreamPoolConfiguration
         *        The configuration for applying the streams to the pool.
         *        </p>
         *        <note>
         *        <p/>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisVideoStreamPoolConfiguration(KinesisVideoStreamPoolConfiguration kinesisVideoStreamPoolConfiguration);

        /**
         * <p>
         * The configuration for applying the streams to the pool.
         * </p>
         * <note>
         * <p/>
         * </note> This is a convenience method that creates an instance of the
         * {@link KinesisVideoStreamPoolConfiguration.Builder} avoiding the need to create one manually via
         * {@link KinesisVideoStreamPoolConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisVideoStreamPoolConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kinesisVideoStreamPoolConfiguration(KinesisVideoStreamPoolConfiguration)}.
         * 
         * @param kinesisVideoStreamPoolConfiguration
         *        a consumer that will call methods on {@link KinesisVideoStreamPoolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisVideoStreamPoolConfiguration(KinesisVideoStreamPoolConfiguration)
         */
        default Builder kinesisVideoStreamPoolConfiguration(
                Consumer<KinesisVideoStreamPoolConfiguration.Builder> kinesisVideoStreamPoolConfiguration) {
            return kinesisVideoStreamPoolConfiguration(KinesisVideoStreamPoolConfiguration.builder()
                    .applyMutation(kinesisVideoStreamPoolConfiguration).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesResponse.BuilderImpl implements Builder {
        private KinesisVideoStreamPoolConfiguration kinesisVideoStreamPoolConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMediaPipelineKinesisVideoStreamPoolResponse model) {
            super(model);
            kinesisVideoStreamPoolConfiguration(model.kinesisVideoStreamPoolConfiguration);
        }

        public final KinesisVideoStreamPoolConfiguration.Builder getKinesisVideoStreamPoolConfiguration() {
            return kinesisVideoStreamPoolConfiguration != null ? kinesisVideoStreamPoolConfiguration.toBuilder() : null;
        }

        public final void setKinesisVideoStreamPoolConfiguration(
                KinesisVideoStreamPoolConfiguration.BuilderImpl kinesisVideoStreamPoolConfiguration) {
            this.kinesisVideoStreamPoolConfiguration = kinesisVideoStreamPoolConfiguration != null ? kinesisVideoStreamPoolConfiguration
                    .build() : null;
        }

        @Override
        public final Builder kinesisVideoStreamPoolConfiguration(
                KinesisVideoStreamPoolConfiguration kinesisVideoStreamPoolConfiguration) {
            this.kinesisVideoStreamPoolConfiguration = kinesisVideoStreamPoolConfiguration;
            return this;
        }

        @Override
        public CreateMediaPipelineKinesisVideoStreamPoolResponse build() {
            return new CreateMediaPipelineKinesisVideoStreamPoolResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
