/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMediaInsightsPipelineConfigurationsResponse extends ChimeSdkMediaPipelinesResponse
        implements
        ToCopyableBuilder<ListMediaInsightsPipelineConfigurationsResponse.Builder, ListMediaInsightsPipelineConfigurationsResponse> {
    private static final SdkField<List<MediaInsightsPipelineConfigurationSummary>> MEDIA_INSIGHTS_PIPELINE_CONFIGURATIONS_FIELD = SdkField
            .<List<MediaInsightsPipelineConfigurationSummary>> builder(MarshallingType.LIST)
            .memberName("MediaInsightsPipelineConfigurations")
            .getter(getter(ListMediaInsightsPipelineConfigurationsResponse::mediaInsightsPipelineConfigurations))
            .setter(setter(Builder::mediaInsightsPipelineConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MediaInsightsPipelineConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaInsightsPipelineConfigurationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaInsightsPipelineConfigurationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMediaInsightsPipelineConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MEDIA_INSIGHTS_PIPELINE_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<MediaInsightsPipelineConfigurationSummary> mediaInsightsPipelineConfigurations;

    private final String nextToken;

    private ListMediaInsightsPipelineConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.mediaInsightsPipelineConfigurations = builder.mediaInsightsPipelineConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaInsightsPipelineConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasMediaInsightsPipelineConfigurations() {
        return mediaInsightsPipelineConfigurations != null
                && !(mediaInsightsPipelineConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The requested list of media insights pipeline configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaInsightsPipelineConfigurations}
     * method.
     * </p>
     * 
     * @return The requested list of media insights pipeline configurations.
     */
    public final List<MediaInsightsPipelineConfigurationSummary> mediaInsightsPipelineConfigurations() {
        return mediaInsightsPipelineConfigurations;
    }

    /**
     * <p>
     * The token used to return the next page of results.
     * </p>
     * 
     * @return The token used to return the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasMediaInsightsPipelineConfigurations() ? mediaInsightsPipelineConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMediaInsightsPipelineConfigurationsResponse)) {
            return false;
        }
        ListMediaInsightsPipelineConfigurationsResponse other = (ListMediaInsightsPipelineConfigurationsResponse) obj;
        return hasMediaInsightsPipelineConfigurations() == other.hasMediaInsightsPipelineConfigurations()
                && Objects.equals(mediaInsightsPipelineConfigurations(), other.mediaInsightsPipelineConfigurations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListMediaInsightsPipelineConfigurationsResponse")
                .add("MediaInsightsPipelineConfigurations",
                        hasMediaInsightsPipelineConfigurations() ? mediaInsightsPipelineConfigurations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaInsightsPipelineConfigurations":
            return Optional.ofNullable(clazz.cast(mediaInsightsPipelineConfigurations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMediaInsightsPipelineConfigurationsResponse, T> g) {
        return obj -> g.apply((ListMediaInsightsPipelineConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMediaPipelinesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMediaInsightsPipelineConfigurationsResponse> {
        /**
         * <p>
         * The requested list of media insights pipeline configurations.
         * </p>
         * 
         * @param mediaInsightsPipelineConfigurations
         *        The requested list of media insights pipeline configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaInsightsPipelineConfigurations(
                Collection<MediaInsightsPipelineConfigurationSummary> mediaInsightsPipelineConfigurations);

        /**
         * <p>
         * The requested list of media insights pipeline configurations.
         * </p>
         * 
         * @param mediaInsightsPipelineConfigurations
         *        The requested list of media insights pipeline configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaInsightsPipelineConfigurations(
                MediaInsightsPipelineConfigurationSummary... mediaInsightsPipelineConfigurations);

        /**
         * <p>
         * The requested list of media insights pipeline configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #mediaInsightsPipelineConfigurations(List<MediaInsightsPipelineConfigurationSummary>)}.
         * 
         * @param mediaInsightsPipelineConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaInsightsPipelineConfigurations(java.util.Collection<MediaInsightsPipelineConfigurationSummary>)
         */
        Builder mediaInsightsPipelineConfigurations(
                Consumer<MediaInsightsPipelineConfigurationSummary.Builder>... mediaInsightsPipelineConfigurations);

        /**
         * <p>
         * The token used to return the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token used to return the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesResponse.BuilderImpl implements Builder {
        private List<MediaInsightsPipelineConfigurationSummary> mediaInsightsPipelineConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMediaInsightsPipelineConfigurationsResponse model) {
            super(model);
            mediaInsightsPipelineConfigurations(model.mediaInsightsPipelineConfigurations);
            nextToken(model.nextToken);
        }

        public final List<MediaInsightsPipelineConfigurationSummary.Builder> getMediaInsightsPipelineConfigurations() {
            List<MediaInsightsPipelineConfigurationSummary.Builder> result = MediaInsightsPipelineConfigurationSummaryListCopier
                    .copyToBuilder(this.mediaInsightsPipelineConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaInsightsPipelineConfigurations(
                Collection<MediaInsightsPipelineConfigurationSummary.BuilderImpl> mediaInsightsPipelineConfigurations) {
            this.mediaInsightsPipelineConfigurations = MediaInsightsPipelineConfigurationSummaryListCopier
                    .copyFromBuilder(mediaInsightsPipelineConfigurations);
        }

        @Override
        public final Builder mediaInsightsPipelineConfigurations(
                Collection<MediaInsightsPipelineConfigurationSummary> mediaInsightsPipelineConfigurations) {
            this.mediaInsightsPipelineConfigurations = MediaInsightsPipelineConfigurationSummaryListCopier
                    .copy(mediaInsightsPipelineConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaInsightsPipelineConfigurations(
                MediaInsightsPipelineConfigurationSummary... mediaInsightsPipelineConfigurations) {
            mediaInsightsPipelineConfigurations(Arrays.asList(mediaInsightsPipelineConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaInsightsPipelineConfigurations(
                Consumer<MediaInsightsPipelineConfigurationSummary.Builder>... mediaInsightsPipelineConfigurations) {
            mediaInsightsPipelineConfigurations(Stream.of(mediaInsightsPipelineConfigurations)
                    .map(c -> MediaInsightsPipelineConfigurationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMediaInsightsPipelineConfigurationsResponse build() {
            return new ListMediaInsightsPipelineConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
