/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A media pipeline object consisting of an ID, source type, source ARN, a sink type, a sink ARN, and a configuration
 * object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaCapturePipeline implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaCapturePipeline.Builder, MediaCapturePipeline> {
    private static final SdkField<String> MEDIA_PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaPipelineId").getter(getter(MediaCapturePipeline::mediaPipelineId))
            .setter(setter(Builder::mediaPipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPipelineId").build()).build();

    private static final SdkField<String> MEDIA_PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaPipelineArn").getter(getter(MediaCapturePipeline::mediaPipelineArn))
            .setter(setter(Builder::mediaPipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPipelineArn").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(MediaCapturePipeline::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(MediaCapturePipeline::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(MediaCapturePipeline::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SINK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SinkType").getter(getter(MediaCapturePipeline::sinkTypeAsString)).setter(setter(Builder::sinkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkType").build()).build();

    private static final SdkField<String> SINK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SinkArn").getter(getter(MediaCapturePipeline::sinkArn)).setter(setter(Builder::sinkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkArn").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(MediaCapturePipeline::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(MediaCapturePipeline::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ChimeSdkMeetingConfiguration> CHIME_SDK_MEETING_CONFIGURATION_FIELD = SdkField
            .<ChimeSdkMeetingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ChimeSdkMeetingConfiguration")
            .getter(getter(MediaCapturePipeline::chimeSdkMeetingConfiguration))
            .setter(setter(Builder::chimeSdkMeetingConfiguration))
            .constructor(ChimeSdkMeetingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChimeSdkMeetingConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_PIPELINE_ID_FIELD,
            MEDIA_PIPELINE_ARN_FIELD, SOURCE_TYPE_FIELD, SOURCE_ARN_FIELD, STATUS_FIELD, SINK_TYPE_FIELD, SINK_ARN_FIELD,
            CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD, CHIME_SDK_MEETING_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mediaPipelineId;

    private final String mediaPipelineArn;

    private final String sourceType;

    private final String sourceArn;

    private final String status;

    private final String sinkType;

    private final String sinkArn;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private final ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration;

    private MediaCapturePipeline(BuilderImpl builder) {
        this.mediaPipelineId = builder.mediaPipelineId;
        this.mediaPipelineArn = builder.mediaPipelineArn;
        this.sourceType = builder.sourceType;
        this.sourceArn = builder.sourceArn;
        this.status = builder.status;
        this.sinkType = builder.sinkType;
        this.sinkArn = builder.sinkArn;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
        this.chimeSdkMeetingConfiguration = builder.chimeSdkMeetingConfiguration;
    }

    /**
     * <p>
     * The ID of a media pipeline.
     * </p>
     * 
     * @return The ID of a media pipeline.
     */
    public final String mediaPipelineId() {
        return mediaPipelineId;
    }

    /**
     * <p>
     * The ARN of the media capture pipeline
     * </p>
     * 
     * @return The ARN of the media capture pipeline
     */
    public final String mediaPipelineArn() {
        return mediaPipelineArn;
    }

    /**
     * <p>
     * Source type from which media artifacts are saved. You must use <code>ChimeMeeting</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link MediaPipelineSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Source type from which media artifacts are saved. You must use <code>ChimeMeeting</code>.
     * @see MediaPipelineSourceType
     */
    public final MediaPipelineSourceType sourceType() {
        return MediaPipelineSourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * Source type from which media artifacts are saved. You must use <code>ChimeMeeting</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link MediaPipelineSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Source type from which media artifacts are saved. You must use <code>ChimeMeeting</code>.
     * @see MediaPipelineSourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * <p>
     * ARN of the source from which the media artifacts are saved.
     * </p>
     * 
     * @return ARN of the source from which the media artifacts are saved.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * The status of the media pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MediaPipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the media pipeline.
     * @see MediaPipelineStatus
     */
    public final MediaPipelineStatus status() {
        return MediaPipelineStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the media pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MediaPipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the media pipeline.
     * @see MediaPipelineStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Destination type to which the media artifacts are saved. You must use an S3 Bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sinkType} will
     * return {@link MediaPipelineSinkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sinkTypeAsString}.
     * </p>
     * 
     * @return Destination type to which the media artifacts are saved. You must use an S3 Bucket.
     * @see MediaPipelineSinkType
     */
    public final MediaPipelineSinkType sinkType() {
        return MediaPipelineSinkType.fromValue(sinkType);
    }

    /**
     * <p>
     * Destination type to which the media artifacts are saved. You must use an S3 Bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sinkType} will
     * return {@link MediaPipelineSinkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sinkTypeAsString}.
     * </p>
     * 
     * @return Destination type to which the media artifacts are saved. You must use an S3 Bucket.
     * @see MediaPipelineSinkType
     */
    public final String sinkTypeAsString() {
        return sinkType;
    }

    /**
     * <p>
     * ARN of the destination to which the media artifacts are saved.
     * </p>
     * 
     * @return ARN of the destination to which the media artifacts are saved.
     */
    public final String sinkArn() {
        return sinkArn;
    }

    /**
     * <p>
     * The time at which the pipeline was created, in ISO 8601 format.
     * </p>
     * 
     * @return The time at which the pipeline was created, in ISO 8601 format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time at which the pipeline was updated, in ISO 8601 format.
     * </p>
     * 
     * @return The time at which the pipeline was updated, in ISO 8601 format.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    /**
     * <p>
     * The configuration for a specified media pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.
     * </p>
     * 
     * @return The configuration for a specified media pipeline. <code>SourceType</code> must be
     *         <code>ChimeSdkMeeting</code>.
     */
    public final ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration() {
        return chimeSdkMeetingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mediaPipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(mediaPipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sinkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sinkArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(chimeSdkMeetingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaCapturePipeline)) {
            return false;
        }
        MediaCapturePipeline other = (MediaCapturePipeline) obj;
        return Objects.equals(mediaPipelineId(), other.mediaPipelineId())
                && Objects.equals(mediaPipelineArn(), other.mediaPipelineArn())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString())
                && Objects.equals(sourceArn(), other.sourceArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(sinkTypeAsString(), other.sinkTypeAsString()) && Objects.equals(sinkArn(), other.sinkArn())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp())
                && Objects.equals(chimeSdkMeetingConfiguration(), other.chimeSdkMeetingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaCapturePipeline").add("MediaPipelineId", mediaPipelineId())
                .add("MediaPipelineArn", mediaPipelineArn()).add("SourceType", sourceTypeAsString())
                .add("SourceArn", sourceArn() == null ? null : "*** Sensitive Data Redacted ***").add("Status", statusAsString())
                .add("SinkType", sinkTypeAsString()).add("SinkArn", sinkArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreatedTimestamp", createdTimestamp()).add("UpdatedTimestamp", updatedTimestamp())
                .add("ChimeSdkMeetingConfiguration", chimeSdkMeetingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaPipelineId":
            return Optional.ofNullable(clazz.cast(mediaPipelineId()));
        case "MediaPipelineArn":
            return Optional.ofNullable(clazz.cast(mediaPipelineArn()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SinkType":
            return Optional.ofNullable(clazz.cast(sinkTypeAsString()));
        case "SinkArn":
            return Optional.ofNullable(clazz.cast(sinkArn()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        case "ChimeSdkMeetingConfiguration":
            return Optional.ofNullable(clazz.cast(chimeSdkMeetingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaCapturePipeline, T> g) {
        return obj -> g.apply((MediaCapturePipeline) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaCapturePipeline> {
        /**
         * <p>
         * The ID of a media pipeline.
         * </p>
         * 
         * @param mediaPipelineId
         *        The ID of a media pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPipelineId(String mediaPipelineId);

        /**
         * <p>
         * The ARN of the media capture pipeline
         * </p>
         * 
         * @param mediaPipelineArn
         *        The ARN of the media capture pipeline
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPipelineArn(String mediaPipelineArn);

        /**
         * <p>
         * Source type from which media artifacts are saved. You must use <code>ChimeMeeting</code>.
         * </p>
         * 
         * @param sourceType
         *        Source type from which media artifacts are saved. You must use <code>ChimeMeeting</code>.
         * @see MediaPipelineSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * Source type from which media artifacts are saved. You must use <code>ChimeMeeting</code>.
         * </p>
         * 
         * @param sourceType
         *        Source type from which media artifacts are saved. You must use <code>ChimeMeeting</code>.
         * @see MediaPipelineSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineSourceType
         */
        Builder sourceType(MediaPipelineSourceType sourceType);

        /**
         * <p>
         * ARN of the source from which the media artifacts are saved.
         * </p>
         * 
         * @param sourceArn
         *        ARN of the source from which the media artifacts are saved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The status of the media pipeline.
         * </p>
         * 
         * @param status
         *        The status of the media pipeline.
         * @see MediaPipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the media pipeline.
         * </p>
         * 
         * @param status
         *        The status of the media pipeline.
         * @see MediaPipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineStatus
         */
        Builder status(MediaPipelineStatus status);

        /**
         * <p>
         * Destination type to which the media artifacts are saved. You must use an S3 Bucket.
         * </p>
         * 
         * @param sinkType
         *        Destination type to which the media artifacts are saved. You must use an S3 Bucket.
         * @see MediaPipelineSinkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineSinkType
         */
        Builder sinkType(String sinkType);

        /**
         * <p>
         * Destination type to which the media artifacts are saved. You must use an S3 Bucket.
         * </p>
         * 
         * @param sinkType
         *        Destination type to which the media artifacts are saved. You must use an S3 Bucket.
         * @see MediaPipelineSinkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineSinkType
         */
        Builder sinkType(MediaPipelineSinkType sinkType);

        /**
         * <p>
         * ARN of the destination to which the media artifacts are saved.
         * </p>
         * 
         * @param sinkArn
         *        ARN of the destination to which the media artifacts are saved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinkArn(String sinkArn);

        /**
         * <p>
         * The time at which the pipeline was created, in ISO 8601 format.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which the pipeline was created, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time at which the pipeline was updated, in ISO 8601 format.
         * </p>
         * 
         * @param updatedTimestamp
         *        The time at which the pipeline was updated, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);

        /**
         * <p>
         * The configuration for a specified media pipeline. <code>SourceType</code> must be
         * <code>ChimeSdkMeeting</code>.
         * </p>
         * 
         * @param chimeSdkMeetingConfiguration
         *        The configuration for a specified media pipeline. <code>SourceType</code> must be
         *        <code>ChimeSdkMeeting</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration);

        /**
         * <p>
         * The configuration for a specified media pipeline. <code>SourceType</code> must be
         * <code>ChimeSdkMeeting</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChimeSdkMeetingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ChimeSdkMeetingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChimeSdkMeetingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration)}.
         * 
         * @param chimeSdkMeetingConfiguration
         *        a consumer that will call methods on {@link ChimeSdkMeetingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration)
         */
        default Builder chimeSdkMeetingConfiguration(Consumer<ChimeSdkMeetingConfiguration.Builder> chimeSdkMeetingConfiguration) {
            return chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration.builder()
                    .applyMutation(chimeSdkMeetingConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String mediaPipelineId;

        private String mediaPipelineArn;

        private String sourceType;

        private String sourceArn;

        private String status;

        private String sinkType;

        private String sinkArn;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaCapturePipeline model) {
            mediaPipelineId(model.mediaPipelineId);
            mediaPipelineArn(model.mediaPipelineArn);
            sourceType(model.sourceType);
            sourceArn(model.sourceArn);
            status(model.status);
            sinkType(model.sinkType);
            sinkArn(model.sinkArn);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
            chimeSdkMeetingConfiguration(model.chimeSdkMeetingConfiguration);
        }

        public final String getMediaPipelineId() {
            return mediaPipelineId;
        }

        public final void setMediaPipelineId(String mediaPipelineId) {
            this.mediaPipelineId = mediaPipelineId;
        }

        @Override
        public final Builder mediaPipelineId(String mediaPipelineId) {
            this.mediaPipelineId = mediaPipelineId;
            return this;
        }

        public final String getMediaPipelineArn() {
            return mediaPipelineArn;
        }

        public final void setMediaPipelineArn(String mediaPipelineArn) {
            this.mediaPipelineArn = mediaPipelineArn;
        }

        @Override
        public final Builder mediaPipelineArn(String mediaPipelineArn) {
            this.mediaPipelineArn = mediaPipelineArn;
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(MediaPipelineSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MediaPipelineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSinkType() {
            return sinkType;
        }

        public final void setSinkType(String sinkType) {
            this.sinkType = sinkType;
        }

        @Override
        public final Builder sinkType(String sinkType) {
            this.sinkType = sinkType;
            return this;
        }

        @Override
        public final Builder sinkType(MediaPipelineSinkType sinkType) {
            this.sinkType(sinkType == null ? null : sinkType.toString());
            return this;
        }

        public final String getSinkArn() {
            return sinkArn;
        }

        public final void setSinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
        }

        @Override
        public final Builder sinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final ChimeSdkMeetingConfiguration.Builder getChimeSdkMeetingConfiguration() {
            return chimeSdkMeetingConfiguration != null ? chimeSdkMeetingConfiguration.toBuilder() : null;
        }

        public final void setChimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration.BuilderImpl chimeSdkMeetingConfiguration) {
            this.chimeSdkMeetingConfiguration = chimeSdkMeetingConfiguration != null ? chimeSdkMeetingConfiguration.build()
                    : null;
        }

        @Override
        public final Builder chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration) {
            this.chimeSdkMeetingConfiguration = chimeSdkMeetingConfiguration;
            return this;
        }

        @Override
        public MediaCapturePipeline build() {
            return new MediaCapturePipeline(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
