/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Concatenates audio and video data from one or more data streams.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaConcatenationPipeline implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaConcatenationPipeline.Builder, MediaConcatenationPipeline> {
    private static final SdkField<String> MEDIA_PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaPipelineId").getter(getter(MediaConcatenationPipeline::mediaPipelineId))
            .setter(setter(Builder::mediaPipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPipelineId").build()).build();

    private static final SdkField<String> MEDIA_PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaPipelineArn").getter(getter(MediaConcatenationPipeline::mediaPipelineArn))
            .setter(setter(Builder::mediaPipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPipelineArn").build()).build();

    private static final SdkField<List<ConcatenationSource>> SOURCES_FIELD = SdkField
            .<List<ConcatenationSource>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(MediaConcatenationPipeline::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConcatenationSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConcatenationSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ConcatenationSink>> SINKS_FIELD = SdkField
            .<List<ConcatenationSink>> builder(MarshallingType.LIST)
            .memberName("Sinks")
            .getter(getter(MediaConcatenationPipeline::sinks))
            .setter(setter(Builder::sinks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sinks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConcatenationSink> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConcatenationSink::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(MediaConcatenationPipeline::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(MediaConcatenationPipeline::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(MediaConcatenationPipeline::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(MEDIA_PIPELINE_ID_FIELD, MEDIA_PIPELINE_ARN_FIELD, SOURCES_FIELD, SINKS_FIELD,
                    STATUS_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mediaPipelineId;

    private final String mediaPipelineArn;

    private final List<ConcatenationSource> sources;

    private final List<ConcatenationSink> sinks;

    private final String status;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private MediaConcatenationPipeline(BuilderImpl builder) {
        this.mediaPipelineId = builder.mediaPipelineId;
        this.mediaPipelineArn = builder.mediaPipelineArn;
        this.sources = builder.sources;
        this.sinks = builder.sinks;
        this.status = builder.status;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    /**
     * <p>
     * The ID of the media pipeline being concatenated.
     * </p>
     * 
     * @return The ID of the media pipeline being concatenated.
     */
    public final String mediaPipelineId() {
        return mediaPipelineId;
    }

    /**
     * <p>
     * The ARN of the media pipeline that you specify in the <code>SourceConfiguration</code> object.
     * </p>
     * 
     * @return The ARN of the media pipeline that you specify in the <code>SourceConfiguration</code> object.
     */
    public final String mediaPipelineArn() {
        return mediaPipelineArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data sources being concatenated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The data sources being concatenated.
     */
    public final List<ConcatenationSource> sources() {
        return sources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sinks property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSinks() {
        return sinks != null && !(sinks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data sinks of the concatenation pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSinks} method.
     * </p>
     * 
     * @return The data sinks of the concatenation pipeline.
     */
    public final List<ConcatenationSink> sinks() {
        return sinks;
    }

    /**
     * <p>
     * The status of the concatenation pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MediaPipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the concatenation pipeline.
     * @see MediaPipelineStatus
     */
    public final MediaPipelineStatus status() {
        return MediaPipelineStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the concatenation pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MediaPipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the concatenation pipeline.
     * @see MediaPipelineStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time at which the concatenation pipeline was created.
     * </p>
     * 
     * @return The time at which the concatenation pipeline was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time at which the concatenation pipeline was last updated.
     * </p>
     * 
     * @return The time at which the concatenation pipeline was last updated.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mediaPipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(mediaPipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSinks() ? sinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaConcatenationPipeline)) {
            return false;
        }
        MediaConcatenationPipeline other = (MediaConcatenationPipeline) obj;
        return Objects.equals(mediaPipelineId(), other.mediaPipelineId())
                && Objects.equals(mediaPipelineArn(), other.mediaPipelineArn()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources()) && hasSinks() == other.hasSinks()
                && Objects.equals(sinks(), other.sinks()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaConcatenationPipeline").add("MediaPipelineId", mediaPipelineId())
                .add("MediaPipelineArn", mediaPipelineArn()).add("Sources", hasSources() ? sources() : null)
                .add("Sinks", hasSinks() ? sinks() : null).add("Status", statusAsString())
                .add("CreatedTimestamp", createdTimestamp()).add("UpdatedTimestamp", updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaPipelineId":
            return Optional.ofNullable(clazz.cast(mediaPipelineId()));
        case "MediaPipelineArn":
            return Optional.ofNullable(clazz.cast(mediaPipelineArn()));
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "Sinks":
            return Optional.ofNullable(clazz.cast(sinks()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaConcatenationPipeline, T> g) {
        return obj -> g.apply((MediaConcatenationPipeline) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaConcatenationPipeline> {
        /**
         * <p>
         * The ID of the media pipeline being concatenated.
         * </p>
         * 
         * @param mediaPipelineId
         *        The ID of the media pipeline being concatenated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPipelineId(String mediaPipelineId);

        /**
         * <p>
         * The ARN of the media pipeline that you specify in the <code>SourceConfiguration</code> object.
         * </p>
         * 
         * @param mediaPipelineArn
         *        The ARN of the media pipeline that you specify in the <code>SourceConfiguration</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPipelineArn(String mediaPipelineArn);

        /**
         * <p>
         * The data sources being concatenated.
         * </p>
         * 
         * @param sources
         *        The data sources being concatenated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<ConcatenationSource> sources);

        /**
         * <p>
         * The data sources being concatenated.
         * </p>
         * 
         * @param sources
         *        The data sources being concatenated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(ConcatenationSource... sources);

        /**
         * <p>
         * The data sources being concatenated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSource.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSource.Builder#build()} is
         * called immediately and its result is passed to {@link #sources(List<ConcatenationSource>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<ConcatenationSource>)
         */
        Builder sources(Consumer<ConcatenationSource.Builder>... sources);

        /**
         * <p>
         * The data sinks of the concatenation pipeline.
         * </p>
         * 
         * @param sinks
         *        The data sinks of the concatenation pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinks(Collection<ConcatenationSink> sinks);

        /**
         * <p>
         * The data sinks of the concatenation pipeline.
         * </p>
         * 
         * @param sinks
         *        The data sinks of the concatenation pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinks(ConcatenationSink... sinks);

        /**
         * <p>
         * The data sinks of the concatenation pipeline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSink.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSink#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSink.Builder#build()} is
         * called immediately and its result is passed to {@link #sinks(List<ConcatenationSink>)}.
         * 
         * @param sinks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSink.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sinks(java.util.Collection<ConcatenationSink>)
         */
        Builder sinks(Consumer<ConcatenationSink.Builder>... sinks);

        /**
         * <p>
         * The status of the concatenation pipeline.
         * </p>
         * 
         * @param status
         *        The status of the concatenation pipeline.
         * @see MediaPipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the concatenation pipeline.
         * </p>
         * 
         * @param status
         *        The status of the concatenation pipeline.
         * @see MediaPipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineStatus
         */
        Builder status(MediaPipelineStatus status);

        /**
         * <p>
         * The time at which the concatenation pipeline was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which the concatenation pipeline was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time at which the concatenation pipeline was last updated.
         * </p>
         * 
         * @param updatedTimestamp
         *        The time at which the concatenation pipeline was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String mediaPipelineId;

        private String mediaPipelineArn;

        private List<ConcatenationSource> sources = DefaultSdkAutoConstructList.getInstance();

        private List<ConcatenationSink> sinks = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaConcatenationPipeline model) {
            mediaPipelineId(model.mediaPipelineId);
            mediaPipelineArn(model.mediaPipelineArn);
            sources(model.sources);
            sinks(model.sinks);
            status(model.status);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
        }

        public final String getMediaPipelineId() {
            return mediaPipelineId;
        }

        public final void setMediaPipelineId(String mediaPipelineId) {
            this.mediaPipelineId = mediaPipelineId;
        }

        @Override
        public final Builder mediaPipelineId(String mediaPipelineId) {
            this.mediaPipelineId = mediaPipelineId;
            return this;
        }

        public final String getMediaPipelineArn() {
            return mediaPipelineArn;
        }

        public final void setMediaPipelineArn(String mediaPipelineArn) {
            this.mediaPipelineArn = mediaPipelineArn;
        }

        @Override
        public final Builder mediaPipelineArn(String mediaPipelineArn) {
            this.mediaPipelineArn = mediaPipelineArn;
            return this;
        }

        public final List<ConcatenationSource.Builder> getSources() {
            List<ConcatenationSource.Builder> result = ConcatenationSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<ConcatenationSource.BuilderImpl> sources) {
            this.sources = ConcatenationSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<ConcatenationSource> sources) {
            this.sources = ConcatenationSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(ConcatenationSource... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<ConcatenationSource.Builder>... sources) {
            sources(Stream.of(sources).map(c -> ConcatenationSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ConcatenationSink.Builder> getSinks() {
            List<ConcatenationSink.Builder> result = ConcatenationSinkListCopier.copyToBuilder(this.sinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSinks(Collection<ConcatenationSink.BuilderImpl> sinks) {
            this.sinks = ConcatenationSinkListCopier.copyFromBuilder(sinks);
        }

        @Override
        public final Builder sinks(Collection<ConcatenationSink> sinks) {
            this.sinks = ConcatenationSinkListCopier.copy(sinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(ConcatenationSink... sinks) {
            sinks(Arrays.asList(sinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(Consumer<ConcatenationSink.Builder>... sinks) {
            sinks(Stream.of(sinks).map(c -> ConcatenationSink.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MediaPipelineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        @Override
        public MediaConcatenationPipeline build() {
            return new MediaConcatenationPipeline(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
