/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the settings for a video tile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoAttribute implements SdkPojo, Serializable, ToCopyableBuilder<VideoAttribute.Builder, VideoAttribute> {
    private static final SdkField<Integer> CORNER_RADIUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CornerRadius").getter(getter(VideoAttribute::cornerRadius)).setter(setter(Builder::cornerRadius))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CornerRadius").build()).build();

    private static final SdkField<String> BORDER_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BorderColor").getter(getter(VideoAttribute::borderColorAsString)).setter(setter(Builder::borderColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderColor").build()).build();

    private static final SdkField<String> HIGHLIGHT_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HighlightColor").getter(getter(VideoAttribute::highlightColorAsString))
            .setter(setter(Builder::highlightColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HighlightColor").build()).build();

    private static final SdkField<Integer> BORDER_THICKNESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BorderThickness").getter(getter(VideoAttribute::borderThickness))
            .setter(setter(Builder::borderThickness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderThickness").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORNER_RADIUS_FIELD,
            BORDER_COLOR_FIELD, HIGHLIGHT_COLOR_FIELD, BORDER_THICKNESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer cornerRadius;

    private final String borderColor;

    private final String highlightColor;

    private final Integer borderThickness;

    private VideoAttribute(BuilderImpl builder) {
        this.cornerRadius = builder.cornerRadius;
        this.borderColor = builder.borderColor;
        this.highlightColor = builder.highlightColor;
        this.borderThickness = builder.borderThickness;
    }

    /**
     * <p>
     * Sets the corner radius of all video tiles.
     * </p>
     * 
     * @return Sets the corner radius of all video tiles.
     */
    public final Integer cornerRadius() {
        return cornerRadius;
    }

    /**
     * <p>
     * Defines the border color of all video tiles.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #borderColor} will
     * return {@link BorderColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #borderColorAsString}.
     * </p>
     * 
     * @return Defines the border color of all video tiles.
     * @see BorderColor
     */
    public final BorderColor borderColor() {
        return BorderColor.fromValue(borderColor);
    }

    /**
     * <p>
     * Defines the border color of all video tiles.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #borderColor} will
     * return {@link BorderColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #borderColorAsString}.
     * </p>
     * 
     * @return Defines the border color of all video tiles.
     * @see BorderColor
     */
    public final String borderColorAsString() {
        return borderColor;
    }

    /**
     * <p>
     * Defines the highlight color for the active video tile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #highlightColor}
     * will return {@link HighlightColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #highlightColorAsString}.
     * </p>
     * 
     * @return Defines the highlight color for the active video tile.
     * @see HighlightColor
     */
    public final HighlightColor highlightColor() {
        return HighlightColor.fromValue(highlightColor);
    }

    /**
     * <p>
     * Defines the highlight color for the active video tile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #highlightColor}
     * will return {@link HighlightColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #highlightColorAsString}.
     * </p>
     * 
     * @return Defines the highlight color for the active video tile.
     * @see HighlightColor
     */
    public final String highlightColorAsString() {
        return highlightColor;
    }

    /**
     * <p>
     * Defines the border thickness for all video tiles.
     * </p>
     * 
     * @return Defines the border thickness for all video tiles.
     */
    public final Integer borderThickness() {
        return borderThickness;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cornerRadius());
        hashCode = 31 * hashCode + Objects.hashCode(borderColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(highlightColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(borderThickness());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoAttribute)) {
            return false;
        }
        VideoAttribute other = (VideoAttribute) obj;
        return Objects.equals(cornerRadius(), other.cornerRadius())
                && Objects.equals(borderColorAsString(), other.borderColorAsString())
                && Objects.equals(highlightColorAsString(), other.highlightColorAsString())
                && Objects.equals(borderThickness(), other.borderThickness());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoAttribute").add("CornerRadius", cornerRadius()).add("BorderColor", borderColorAsString())
                .add("HighlightColor", highlightColorAsString()).add("BorderThickness", borderThickness()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CornerRadius":
            return Optional.ofNullable(clazz.cast(cornerRadius()));
        case "BorderColor":
            return Optional.ofNullable(clazz.cast(borderColorAsString()));
        case "HighlightColor":
            return Optional.ofNullable(clazz.cast(highlightColorAsString()));
        case "BorderThickness":
            return Optional.ofNullable(clazz.cast(borderThickness()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoAttribute, T> g) {
        return obj -> g.apply((VideoAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoAttribute> {
        /**
         * <p>
         * Sets the corner radius of all video tiles.
         * </p>
         * 
         * @param cornerRadius
         *        Sets the corner radius of all video tiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cornerRadius(Integer cornerRadius);

        /**
         * <p>
         * Defines the border color of all video tiles.
         * </p>
         * 
         * @param borderColor
         *        Defines the border color of all video tiles.
         * @see BorderColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BorderColor
         */
        Builder borderColor(String borderColor);

        /**
         * <p>
         * Defines the border color of all video tiles.
         * </p>
         * 
         * @param borderColor
         *        Defines the border color of all video tiles.
         * @see BorderColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BorderColor
         */
        Builder borderColor(BorderColor borderColor);

        /**
         * <p>
         * Defines the highlight color for the active video tile.
         * </p>
         * 
         * @param highlightColor
         *        Defines the highlight color for the active video tile.
         * @see HighlightColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HighlightColor
         */
        Builder highlightColor(String highlightColor);

        /**
         * <p>
         * Defines the highlight color for the active video tile.
         * </p>
         * 
         * @param highlightColor
         *        Defines the highlight color for the active video tile.
         * @see HighlightColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HighlightColor
         */
        Builder highlightColor(HighlightColor highlightColor);

        /**
         * <p>
         * Defines the border thickness for all video tiles.
         * </p>
         * 
         * @param borderThickness
         *        Defines the border thickness for all video tiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder borderThickness(Integer borderThickness);
    }

    static final class BuilderImpl implements Builder {
        private Integer cornerRadius;

        private String borderColor;

        private String highlightColor;

        private Integer borderThickness;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoAttribute model) {
            cornerRadius(model.cornerRadius);
            borderColor(model.borderColor);
            highlightColor(model.highlightColor);
            borderThickness(model.borderThickness);
        }

        public final Integer getCornerRadius() {
            return cornerRadius;
        }

        public final void setCornerRadius(Integer cornerRadius) {
            this.cornerRadius = cornerRadius;
        }

        @Override
        public final Builder cornerRadius(Integer cornerRadius) {
            this.cornerRadius = cornerRadius;
            return this;
        }

        public final String getBorderColor() {
            return borderColor;
        }

        public final void setBorderColor(String borderColor) {
            this.borderColor = borderColor;
        }

        @Override
        public final Builder borderColor(String borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        @Override
        public final Builder borderColor(BorderColor borderColor) {
            this.borderColor(borderColor == null ? null : borderColor.toString());
            return this;
        }

        public final String getHighlightColor() {
            return highlightColor;
        }

        public final void setHighlightColor(String highlightColor) {
            this.highlightColor = highlightColor;
        }

        @Override
        public final Builder highlightColor(String highlightColor) {
            this.highlightColor = highlightColor;
            return this;
        }

        @Override
        public final Builder highlightColor(HighlightColor highlightColor) {
            this.highlightColor(highlightColor == null ? null : highlightColor.toString());
            return this;
        }

        public final Integer getBorderThickness() {
            return borderThickness;
        }

        public final void setBorderThickness(Integer borderThickness) {
            this.borderThickness = borderThickness;
        }

        @Override
        public final Builder borderThickness(Integer borderThickness) {
            this.borderThickness = borderThickness;
            return this;
        }

        @Override
        public VideoAttribute build() {
            return new VideoAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
