/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMediaPipelinesRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElementsCopier;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMediaInsightsPipelineConfigurationRequest
extends ChimeSdkMediaPipelinesRequest
implements ToCopyableBuilder<Builder, UpdateMediaInsightsPipelineConfigurationRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(UpdateMediaInsightsPipelineConfigurationRequest.getter(UpdateMediaInsightsPipelineConfigurationRequest::identifier)).setter(UpdateMediaInsightsPipelineConfigurationRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<String> RESOURCE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceAccessRoleArn").getter(UpdateMediaInsightsPipelineConfigurationRequest.getter(UpdateMediaInsightsPipelineConfigurationRequest::resourceAccessRoleArn)).setter(UpdateMediaInsightsPipelineConfigurationRequest.setter(Builder::resourceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAccessRoleArn").build()}).build();
    private static final SdkField<RealTimeAlertConfiguration> REAL_TIME_ALERT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RealTimeAlertConfiguration").getter(UpdateMediaInsightsPipelineConfigurationRequest.getter(UpdateMediaInsightsPipelineConfigurationRequest::realTimeAlertConfiguration)).setter(UpdateMediaInsightsPipelineConfigurationRequest.setter(Builder::realTimeAlertConfiguration)).constructor(RealTimeAlertConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealTimeAlertConfiguration").build()}).build();
    private static final SdkField<List<MediaInsightsPipelineConfigurationElement>> ELEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Elements").getter(UpdateMediaInsightsPipelineConfigurationRequest.getter(UpdateMediaInsightsPipelineConfigurationRequest::elements)).setter(UpdateMediaInsightsPipelineConfigurationRequest.setter(Builder::elements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Elements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaInsightsPipelineConfigurationElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, RESOURCE_ACCESS_ROLE_ARN_FIELD, REAL_TIME_ALERT_CONFIGURATION_FIELD, ELEMENTS_FIELD));
    private final String identifier;
    private final String resourceAccessRoleArn;
    private final RealTimeAlertConfiguration realTimeAlertConfiguration;
    private final List<MediaInsightsPipelineConfigurationElement> elements;

    private UpdateMediaInsightsPipelineConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.resourceAccessRoleArn = builder.resourceAccessRoleArn;
        this.realTimeAlertConfiguration = builder.realTimeAlertConfiguration;
        this.elements = builder.elements;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String resourceAccessRoleArn() {
        return this.resourceAccessRoleArn;
    }

    public final RealTimeAlertConfiguration realTimeAlertConfiguration() {
        return this.realTimeAlertConfiguration;
    }

    public final boolean hasElements() {
        return this.elements != null && !(this.elements instanceof SdkAutoConstructList);
    }

    public final List<MediaInsightsPipelineConfigurationElement> elements() {
        return this.elements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.realTimeAlertConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElements() ? this.elements() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMediaInsightsPipelineConfigurationRequest)) {
            return false;
        }
        UpdateMediaInsightsPipelineConfigurationRequest other = (UpdateMediaInsightsPipelineConfigurationRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.resourceAccessRoleArn(), other.resourceAccessRoleArn()) && Objects.equals(this.realTimeAlertConfiguration(), other.realTimeAlertConfiguration()) && this.hasElements() == other.hasElements() && Objects.equals(this.elements(), other.elements());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMediaInsightsPipelineConfigurationRequest").add("Identifier", (Object)this.identifier()).add("ResourceAccessRoleArn", (Object)(this.resourceAccessRoleArn() == null ? null : "*** Sensitive Data Redacted ***")).add("RealTimeAlertConfiguration", (Object)this.realTimeAlertConfiguration()).add("Elements", this.hasElements() ? this.elements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "ResourceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.resourceAccessRoleArn()));
            }
            case "RealTimeAlertConfiguration": {
                return Optional.ofNullable(clazz.cast(this.realTimeAlertConfiguration()));
            }
            case "Elements": {
                return Optional.ofNullable(clazz.cast(this.elements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMediaInsightsPipelineConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateMediaInsightsPipelineConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMediaPipelinesRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private String resourceAccessRoleArn;
        private RealTimeAlertConfiguration realTimeAlertConfiguration;
        private List<MediaInsightsPipelineConfigurationElement> elements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMediaInsightsPipelineConfigurationRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.resourceAccessRoleArn(model.resourceAccessRoleArn);
            this.realTimeAlertConfiguration(model.realTimeAlertConfiguration);
            this.elements(model.elements);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getResourceAccessRoleArn() {
            return this.resourceAccessRoleArn;
        }

        public final void setResourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
        }

        @Override
        public final Builder resourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
            return this;
        }

        public final RealTimeAlertConfiguration.Builder getRealTimeAlertConfiguration() {
            return this.realTimeAlertConfiguration != null ? this.realTimeAlertConfiguration.toBuilder() : null;
        }

        public final void setRealTimeAlertConfiguration(RealTimeAlertConfiguration.BuilderImpl realTimeAlertConfiguration) {
            this.realTimeAlertConfiguration = realTimeAlertConfiguration != null ? realTimeAlertConfiguration.build() : null;
        }

        @Override
        public final Builder realTimeAlertConfiguration(RealTimeAlertConfiguration realTimeAlertConfiguration) {
            this.realTimeAlertConfiguration = realTimeAlertConfiguration;
            return this;
        }

        public final List<MediaInsightsPipelineConfigurationElement.Builder> getElements() {
            List<MediaInsightsPipelineConfigurationElement.Builder> result = MediaInsightsPipelineConfigurationElementsCopier.copyToBuilder(this.elements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElements(Collection<MediaInsightsPipelineConfigurationElement.BuilderImpl> elements) {
            this.elements = MediaInsightsPipelineConfigurationElementsCopier.copyFromBuilder(elements);
        }

        @Override
        public final Builder elements(Collection<MediaInsightsPipelineConfigurationElement> elements) {
            this.elements = MediaInsightsPipelineConfigurationElementsCopier.copy(elements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(MediaInsightsPipelineConfigurationElement ... elements) {
            this.elements(Arrays.asList(elements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(Consumer<MediaInsightsPipelineConfigurationElement.Builder> ... elements) {
            this.elements(Stream.of(elements).map(c -> (MediaInsightsPipelineConfigurationElement)((MediaInsightsPipelineConfigurationElement.Builder)MediaInsightsPipelineConfigurationElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMediaInsightsPipelineConfigurationRequest build() {
            return new UpdateMediaInsightsPipelineConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeSdkMediaPipelinesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMediaInsightsPipelineConfigurationRequest> {
        public Builder identifier(String var1);

        public Builder resourceAccessRoleArn(String var1);

        public Builder realTimeAlertConfiguration(RealTimeAlertConfiguration var1);

        default public Builder realTimeAlertConfiguration(Consumer<RealTimeAlertConfiguration.Builder> realTimeAlertConfiguration) {
            return this.realTimeAlertConfiguration((RealTimeAlertConfiguration)((RealTimeAlertConfiguration.Builder)RealTimeAlertConfiguration.builder().applyMutation(realTimeAlertConfiguration)).build());
        }

        public Builder elements(Collection<MediaInsightsPipelineConfigurationElement> var1);

        public Builder elements(MediaInsightsPipelineConfigurationElement ... var1);

        public Builder elements(Consumer<MediaInsightsPipelineConfigurationElement.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

