/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSourceType;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaCapturePipelineSourceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConcatenationSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConcatenationSource> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ConcatenationSource.getter(ConcatenationSource::typeAsString)).setter(ConcatenationSource.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<MediaCapturePipelineSourceConfiguration> MEDIA_CAPTURE_PIPELINE_SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaCapturePipelineSourceConfiguration").getter(ConcatenationSource.getter(ConcatenationSource::mediaCapturePipelineSourceConfiguration)).setter(ConcatenationSource.setter(Builder::mediaCapturePipelineSourceConfiguration)).constructor(MediaCapturePipelineSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaCapturePipelineSourceConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MEDIA_CAPTURE_PIPELINE_SOURCE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Type", TYPE_FIELD);
            this.put("MediaCapturePipelineSourceConfiguration", MEDIA_CAPTURE_PIPELINE_SOURCE_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final MediaCapturePipelineSourceConfiguration mediaCapturePipelineSourceConfiguration;

    private ConcatenationSource(BuilderImpl builder) {
        this.type = builder.type;
        this.mediaCapturePipelineSourceConfiguration = builder.mediaCapturePipelineSourceConfiguration;
    }

    public final ConcatenationSourceType type() {
        return ConcatenationSourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final MediaCapturePipelineSourceConfiguration mediaCapturePipelineSourceConfiguration() {
        return this.mediaCapturePipelineSourceConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaCapturePipelineSourceConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConcatenationSource)) {
            return false;
        }
        ConcatenationSource other = (ConcatenationSource)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.mediaCapturePipelineSourceConfiguration(), other.mediaCapturePipelineSourceConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ConcatenationSource").add("Type", (Object)this.typeAsString()).add("MediaCapturePipelineSourceConfiguration", (Object)this.mediaCapturePipelineSourceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "MediaCapturePipelineSourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.mediaCapturePipelineSourceConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConcatenationSource, T> g) {
        return obj -> g.apply((ConcatenationSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private MediaCapturePipelineSourceConfiguration mediaCapturePipelineSourceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ConcatenationSource model) {
            this.type(model.type);
            this.mediaCapturePipelineSourceConfiguration(model.mediaCapturePipelineSourceConfiguration);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ConcatenationSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final MediaCapturePipelineSourceConfiguration.Builder getMediaCapturePipelineSourceConfiguration() {
            return this.mediaCapturePipelineSourceConfiguration != null ? this.mediaCapturePipelineSourceConfiguration.toBuilder() : null;
        }

        public final void setMediaCapturePipelineSourceConfiguration(MediaCapturePipelineSourceConfiguration.BuilderImpl mediaCapturePipelineSourceConfiguration) {
            this.mediaCapturePipelineSourceConfiguration = mediaCapturePipelineSourceConfiguration != null ? mediaCapturePipelineSourceConfiguration.build() : null;
        }

        @Override
        public final Builder mediaCapturePipelineSourceConfiguration(MediaCapturePipelineSourceConfiguration mediaCapturePipelineSourceConfiguration) {
            this.mediaCapturePipelineSourceConfiguration = mediaCapturePipelineSourceConfiguration;
            return this;
        }

        public ConcatenationSource build() {
            return new ConcatenationSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConcatenationSource> {
        public Builder type(String var1);

        public Builder type(ConcatenationSourceType var1);

        public Builder mediaCapturePipelineSourceConfiguration(MediaCapturePipelineSourceConfiguration var1);

        default public Builder mediaCapturePipelineSourceConfiguration(Consumer<MediaCapturePipelineSourceConfiguration.Builder> mediaCapturePipelineSourceConfiguration) {
            return this.mediaCapturePipelineSourceConfiguration((MediaCapturePipelineSourceConfiguration)((MediaCapturePipelineSourceConfiguration.Builder)MediaCapturePipelineSourceConfiguration.builder().applyMutation(mediaCapturePipelineSourceConfiguration)).build());
        }
    }
}

