/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMediaPipelinesRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElementsCopier;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMediaInsightsPipelineConfigurationRequest
extends ChimeSdkMediaPipelinesRequest
implements ToCopyableBuilder<Builder, CreateMediaInsightsPipelineConfigurationRequest> {
    private static final SdkField<String> MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaInsightsPipelineConfigurationName").getter(CreateMediaInsightsPipelineConfigurationRequest.getter(CreateMediaInsightsPipelineConfigurationRequest::mediaInsightsPipelineConfigurationName)).setter(CreateMediaInsightsPipelineConfigurationRequest.setter(Builder::mediaInsightsPipelineConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaInsightsPipelineConfigurationName").build()}).build();
    private static final SdkField<String> RESOURCE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceAccessRoleArn").getter(CreateMediaInsightsPipelineConfigurationRequest.getter(CreateMediaInsightsPipelineConfigurationRequest::resourceAccessRoleArn)).setter(CreateMediaInsightsPipelineConfigurationRequest.setter(Builder::resourceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAccessRoleArn").build()}).build();
    private static final SdkField<RealTimeAlertConfiguration> REAL_TIME_ALERT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RealTimeAlertConfiguration").getter(CreateMediaInsightsPipelineConfigurationRequest.getter(CreateMediaInsightsPipelineConfigurationRequest::realTimeAlertConfiguration)).setter(CreateMediaInsightsPipelineConfigurationRequest.setter(Builder::realTimeAlertConfiguration)).constructor(RealTimeAlertConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealTimeAlertConfiguration").build()}).build();
    private static final SdkField<List<MediaInsightsPipelineConfigurationElement>> ELEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Elements").getter(CreateMediaInsightsPipelineConfigurationRequest.getter(CreateMediaInsightsPipelineConfigurationRequest::elements)).setter(CreateMediaInsightsPipelineConfigurationRequest.setter(Builder::elements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Elements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaInsightsPipelineConfigurationElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateMediaInsightsPipelineConfigurationRequest.getter(CreateMediaInsightsPipelineConfigurationRequest::tags)).setter(CreateMediaInsightsPipelineConfigurationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateMediaInsightsPipelineConfigurationRequest.getter(CreateMediaInsightsPipelineConfigurationRequest::clientRequestToken)).setter(CreateMediaInsightsPipelineConfigurationRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_NAME_FIELD, RESOURCE_ACCESS_ROLE_ARN_FIELD, REAL_TIME_ALERT_CONFIGURATION_FIELD, ELEMENTS_FIELD, TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MediaInsightsPipelineConfigurationName", MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_NAME_FIELD);
            this.put("ResourceAccessRoleArn", RESOURCE_ACCESS_ROLE_ARN_FIELD);
            this.put("RealTimeAlertConfiguration", REAL_TIME_ALERT_CONFIGURATION_FIELD);
            this.put("Elements", ELEMENTS_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        }
    });
    private final String mediaInsightsPipelineConfigurationName;
    private final String resourceAccessRoleArn;
    private final RealTimeAlertConfiguration realTimeAlertConfiguration;
    private final List<MediaInsightsPipelineConfigurationElement> elements;
    private final List<Tag> tags;
    private final String clientRequestToken;

    private CreateMediaInsightsPipelineConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.mediaInsightsPipelineConfigurationName = builder.mediaInsightsPipelineConfigurationName;
        this.resourceAccessRoleArn = builder.resourceAccessRoleArn;
        this.realTimeAlertConfiguration = builder.realTimeAlertConfiguration;
        this.elements = builder.elements;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String mediaInsightsPipelineConfigurationName() {
        return this.mediaInsightsPipelineConfigurationName;
    }

    public final String resourceAccessRoleArn() {
        return this.resourceAccessRoleArn;
    }

    public final RealTimeAlertConfiguration realTimeAlertConfiguration() {
        return this.realTimeAlertConfiguration;
    }

    public final boolean hasElements() {
        return this.elements != null && !(this.elements instanceof SdkAutoConstructList);
    }

    public final List<MediaInsightsPipelineConfigurationElement> elements() {
        return this.elements;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaInsightsPipelineConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.realTimeAlertConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElements() ? this.elements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMediaInsightsPipelineConfigurationRequest)) {
            return false;
        }
        CreateMediaInsightsPipelineConfigurationRequest other = (CreateMediaInsightsPipelineConfigurationRequest)((Object)obj);
        return Objects.equals(this.mediaInsightsPipelineConfigurationName(), other.mediaInsightsPipelineConfigurationName()) && Objects.equals(this.resourceAccessRoleArn(), other.resourceAccessRoleArn()) && Objects.equals(this.realTimeAlertConfiguration(), other.realTimeAlertConfiguration()) && this.hasElements() == other.hasElements() && Objects.equals(this.elements(), other.elements()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMediaInsightsPipelineConfigurationRequest").add("MediaInsightsPipelineConfigurationName", (Object)this.mediaInsightsPipelineConfigurationName()).add("ResourceAccessRoleArn", (Object)(this.resourceAccessRoleArn() == null ? null : "*** Sensitive Data Redacted ***")).add("RealTimeAlertConfiguration", (Object)this.realTimeAlertConfiguration()).add("Elements", this.hasElements() ? this.elements() : null).add("Tags", this.hasTags() ? this.tags() : null).add("ClientRequestToken", (Object)(this.clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaInsightsPipelineConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.mediaInsightsPipelineConfigurationName()));
            }
            case "ResourceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.resourceAccessRoleArn()));
            }
            case "RealTimeAlertConfiguration": {
                return Optional.ofNullable(clazz.cast(this.realTimeAlertConfiguration()));
            }
            case "Elements": {
                return Optional.ofNullable(clazz.cast(this.elements()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateMediaInsightsPipelineConfigurationRequest, T> g) {
        return obj -> g.apply((CreateMediaInsightsPipelineConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMediaPipelinesRequest.BuilderImpl
    implements Builder {
        private String mediaInsightsPipelineConfigurationName;
        private String resourceAccessRoleArn;
        private RealTimeAlertConfiguration realTimeAlertConfiguration;
        private List<MediaInsightsPipelineConfigurationElement> elements = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMediaInsightsPipelineConfigurationRequest model) {
            super(model);
            this.mediaInsightsPipelineConfigurationName(model.mediaInsightsPipelineConfigurationName);
            this.resourceAccessRoleArn(model.resourceAccessRoleArn);
            this.realTimeAlertConfiguration(model.realTimeAlertConfiguration);
            this.elements(model.elements);
            this.tags(model.tags);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getMediaInsightsPipelineConfigurationName() {
            return this.mediaInsightsPipelineConfigurationName;
        }

        public final void setMediaInsightsPipelineConfigurationName(String mediaInsightsPipelineConfigurationName) {
            this.mediaInsightsPipelineConfigurationName = mediaInsightsPipelineConfigurationName;
        }

        @Override
        public final Builder mediaInsightsPipelineConfigurationName(String mediaInsightsPipelineConfigurationName) {
            this.mediaInsightsPipelineConfigurationName = mediaInsightsPipelineConfigurationName;
            return this;
        }

        public final String getResourceAccessRoleArn() {
            return this.resourceAccessRoleArn;
        }

        public final void setResourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
        }

        @Override
        public final Builder resourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
            return this;
        }

        public final RealTimeAlertConfiguration.Builder getRealTimeAlertConfiguration() {
            return this.realTimeAlertConfiguration != null ? this.realTimeAlertConfiguration.toBuilder() : null;
        }

        public final void setRealTimeAlertConfiguration(RealTimeAlertConfiguration.BuilderImpl realTimeAlertConfiguration) {
            this.realTimeAlertConfiguration = realTimeAlertConfiguration != null ? realTimeAlertConfiguration.build() : null;
        }

        @Override
        public final Builder realTimeAlertConfiguration(RealTimeAlertConfiguration realTimeAlertConfiguration) {
            this.realTimeAlertConfiguration = realTimeAlertConfiguration;
            return this;
        }

        public final List<MediaInsightsPipelineConfigurationElement.Builder> getElements() {
            List<MediaInsightsPipelineConfigurationElement.Builder> result = MediaInsightsPipelineConfigurationElementsCopier.copyToBuilder(this.elements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElements(Collection<MediaInsightsPipelineConfigurationElement.BuilderImpl> elements) {
            this.elements = MediaInsightsPipelineConfigurationElementsCopier.copyFromBuilder(elements);
        }

        @Override
        public final Builder elements(Collection<MediaInsightsPipelineConfigurationElement> elements) {
            this.elements = MediaInsightsPipelineConfigurationElementsCopier.copy(elements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(MediaInsightsPipelineConfigurationElement ... elements) {
            this.elements(Arrays.asList(elements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(Consumer<MediaInsightsPipelineConfigurationElement.Builder> ... elements) {
            this.elements(Stream.of(elements).map(c -> (MediaInsightsPipelineConfigurationElement)((MediaInsightsPipelineConfigurationElement.Builder)MediaInsightsPipelineConfigurationElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMediaInsightsPipelineConfigurationRequest build() {
            return new CreateMediaInsightsPipelineConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkMediaPipelinesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMediaInsightsPipelineConfigurationRequest> {
        public Builder mediaInsightsPipelineConfigurationName(String var1);

        public Builder resourceAccessRoleArn(String var1);

        public Builder realTimeAlertConfiguration(RealTimeAlertConfiguration var1);

        default public Builder realTimeAlertConfiguration(Consumer<RealTimeAlertConfiguration.Builder> realTimeAlertConfiguration) {
            return this.realTimeAlertConfiguration((RealTimeAlertConfiguration)((RealTimeAlertConfiguration.Builder)RealTimeAlertConfiguration.builder().applyMutation(realTimeAlertConfiguration)).build());
        }

        public Builder elements(Collection<MediaInsightsPipelineConfigurationElement> var1);

        public Builder elements(MediaInsightsPipelineConfigurationElement ... var1);

        public Builder elements(Consumer<MediaInsightsPipelineConfigurationElement.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

