/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSinkConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSinkListCopier;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSourceConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSourceListCopier;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaLiveConnectorPipeline
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaLiveConnectorPipeline> {
    private static final SdkField<List<LiveConnectorSourceConfiguration>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(MediaLiveConnectorPipeline.getter(MediaLiveConnectorPipeline::sources)).setter(MediaLiveConnectorPipeline.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LiveConnectorSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LiveConnectorSinkConfiguration>> SINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sinks").getter(MediaLiveConnectorPipeline.getter(MediaLiveConnectorPipeline::sinks)).setter(MediaLiveConnectorPipeline.setter(Builder::sinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LiveConnectorSinkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MEDIA_PIPELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaPipelineId").getter(MediaLiveConnectorPipeline.getter(MediaLiveConnectorPipeline::mediaPipelineId)).setter(MediaLiveConnectorPipeline.setter(Builder::mediaPipelineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPipelineId").build()}).build();
    private static final SdkField<String> MEDIA_PIPELINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaPipelineArn").getter(MediaLiveConnectorPipeline.getter(MediaLiveConnectorPipeline::mediaPipelineArn)).setter(MediaLiveConnectorPipeline.setter(Builder::mediaPipelineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPipelineArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(MediaLiveConnectorPipeline.getter(MediaLiveConnectorPipeline::statusAsString)).setter(MediaLiveConnectorPipeline.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(MediaLiveConnectorPipeline.getter(MediaLiveConnectorPipeline::createdTimestamp)).setter(MediaLiveConnectorPipeline.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(MediaLiveConnectorPipeline.getter(MediaLiveConnectorPipeline::updatedTimestamp)).setter(MediaLiveConnectorPipeline.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCES_FIELD, SINKS_FIELD, MEDIA_PIPELINE_ID_FIELD, MEDIA_PIPELINE_ARN_FIELD, STATUS_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Sources", SOURCES_FIELD);
            this.put("Sinks", SINKS_FIELD);
            this.put("MediaPipelineId", MEDIA_PIPELINE_ID_FIELD);
            this.put("MediaPipelineArn", MEDIA_PIPELINE_ARN_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
            this.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<LiveConnectorSourceConfiguration> sources;
    private final List<LiveConnectorSinkConfiguration> sinks;
    private final String mediaPipelineId;
    private final String mediaPipelineArn;
    private final String status;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;

    private MediaLiveConnectorPipeline(BuilderImpl builder) {
        this.sources = builder.sources;
        this.sinks = builder.sinks;
        this.mediaPipelineId = builder.mediaPipelineId;
        this.mediaPipelineArn = builder.mediaPipelineArn;
        this.status = builder.status;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<LiveConnectorSourceConfiguration> sources() {
        return this.sources;
    }

    public final boolean hasSinks() {
        return this.sinks != null && !(this.sinks instanceof SdkAutoConstructList);
    }

    public final List<LiveConnectorSinkConfiguration> sinks() {
        return this.sinks;
    }

    public final String mediaPipelineId() {
        return this.mediaPipelineId;
    }

    public final String mediaPipelineArn() {
        return this.mediaPipelineArn;
    }

    public final MediaPipelineStatus status() {
        return MediaPipelineStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSinks() ? this.sinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaPipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaPipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaLiveConnectorPipeline)) {
            return false;
        }
        MediaLiveConnectorPipeline other = (MediaLiveConnectorPipeline)obj;
        return this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && this.hasSinks() == other.hasSinks() && Objects.equals(this.sinks(), other.sinks()) && Objects.equals(this.mediaPipelineId(), other.mediaPipelineId()) && Objects.equals(this.mediaPipelineArn(), other.mediaPipelineArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"MediaLiveConnectorPipeline").add("Sources", this.hasSources() ? this.sources() : null).add("Sinks", this.hasSinks() ? this.sinks() : null).add("MediaPipelineId", (Object)this.mediaPipelineId()).add("MediaPipelineArn", (Object)this.mediaPipelineArn()).add("Status", (Object)this.statusAsString()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "Sinks": {
                return Optional.ofNullable(clazz.cast(this.sinks()));
            }
            case "MediaPipelineId": {
                return Optional.ofNullable(clazz.cast(this.mediaPipelineId()));
            }
            case "MediaPipelineArn": {
                return Optional.ofNullable(clazz.cast(this.mediaPipelineArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MediaLiveConnectorPipeline, T> g) {
        return obj -> g.apply((MediaLiveConnectorPipeline)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<LiveConnectorSourceConfiguration> sources = DefaultSdkAutoConstructList.getInstance();
        private List<LiveConnectorSinkConfiguration> sinks = DefaultSdkAutoConstructList.getInstance();
        private String mediaPipelineId;
        private String mediaPipelineArn;
        private String status;
        private Instant createdTimestamp;
        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaLiveConnectorPipeline model) {
            this.sources(model.sources);
            this.sinks(model.sinks);
            this.mediaPipelineId(model.mediaPipelineId);
            this.mediaPipelineArn(model.mediaPipelineArn);
            this.status(model.status);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
        }

        public final List<LiveConnectorSourceConfiguration.Builder> getSources() {
            List<LiveConnectorSourceConfiguration.Builder> result = LiveConnectorSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<LiveConnectorSourceConfiguration.BuilderImpl> sources) {
            this.sources = LiveConnectorSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<LiveConnectorSourceConfiguration> sources) {
            this.sources = LiveConnectorSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(LiveConnectorSourceConfiguration ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<LiveConnectorSourceConfiguration.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (LiveConnectorSourceConfiguration)((LiveConnectorSourceConfiguration.Builder)LiveConnectorSourceConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LiveConnectorSinkConfiguration.Builder> getSinks() {
            List<LiveConnectorSinkConfiguration.Builder> result = LiveConnectorSinkListCopier.copyToBuilder(this.sinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSinks(Collection<LiveConnectorSinkConfiguration.BuilderImpl> sinks) {
            this.sinks = LiveConnectorSinkListCopier.copyFromBuilder(sinks);
        }

        @Override
        public final Builder sinks(Collection<LiveConnectorSinkConfiguration> sinks) {
            this.sinks = LiveConnectorSinkListCopier.copy(sinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(LiveConnectorSinkConfiguration ... sinks) {
            this.sinks(Arrays.asList(sinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(Consumer<LiveConnectorSinkConfiguration.Builder> ... sinks) {
            this.sinks(Stream.of(sinks).map(c -> (LiveConnectorSinkConfiguration)((LiveConnectorSinkConfiguration.Builder)LiveConnectorSinkConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMediaPipelineId() {
            return this.mediaPipelineId;
        }

        public final void setMediaPipelineId(String mediaPipelineId) {
            this.mediaPipelineId = mediaPipelineId;
        }

        @Override
        public final Builder mediaPipelineId(String mediaPipelineId) {
            this.mediaPipelineId = mediaPipelineId;
            return this;
        }

        public final String getMediaPipelineArn() {
            return this.mediaPipelineArn;
        }

        public final void setMediaPipelineArn(String mediaPipelineArn) {
            this.mediaPipelineArn = mediaPipelineArn;
        }

        @Override
        public final Builder mediaPipelineArn(String mediaPipelineArn) {
            this.mediaPipelineArn = mediaPipelineArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MediaPipelineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public MediaLiveConnectorPipeline build() {
            return new MediaLiveConnectorPipeline(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaLiveConnectorPipeline> {
        public Builder sources(Collection<LiveConnectorSourceConfiguration> var1);

        public Builder sources(LiveConnectorSourceConfiguration ... var1);

        public Builder sources(Consumer<LiveConnectorSourceConfiguration.Builder> ... var1);

        public Builder sinks(Collection<LiveConnectorSinkConfiguration> var1);

        public Builder sinks(LiveConnectorSinkConfiguration ... var1);

        public Builder sinks(Consumer<LiveConnectorSinkConfiguration.Builder> ... var1);

        public Builder mediaPipelineId(String var1);

        public Builder mediaPipelineArn(String var1);

        public Builder status(String var1);

        public Builder status(MediaPipelineStatus var1);

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);
    }
}

