/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CompositedVideoArtifactsConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorMuxType;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.SourceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChimeSdkMeetingLiveConnectorConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChimeSdkMeetingLiveConnectorConfiguration> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ChimeSdkMeetingLiveConnectorConfiguration.getter(ChimeSdkMeetingLiveConnectorConfiguration::arn)).setter(ChimeSdkMeetingLiveConnectorConfiguration.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> MUX_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MuxType").getter(ChimeSdkMeetingLiveConnectorConfiguration.getter(ChimeSdkMeetingLiveConnectorConfiguration::muxTypeAsString)).setter(ChimeSdkMeetingLiveConnectorConfiguration.setter(Builder::muxType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MuxType").build()}).build();
    private static final SdkField<CompositedVideoArtifactsConfiguration> COMPOSITED_VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CompositedVideo").getter(ChimeSdkMeetingLiveConnectorConfiguration.getter(ChimeSdkMeetingLiveConnectorConfiguration::compositedVideo)).setter(ChimeSdkMeetingLiveConnectorConfiguration.setter(Builder::compositedVideo)).constructor(CompositedVideoArtifactsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositedVideo").build()}).build();
    private static final SdkField<SourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceConfiguration").getter(ChimeSdkMeetingLiveConnectorConfiguration.getter(ChimeSdkMeetingLiveConnectorConfiguration::sourceConfiguration)).setter(ChimeSdkMeetingLiveConnectorConfiguration.setter(Builder::sourceConfiguration)).constructor(SourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, MUX_TYPE_FIELD, COMPOSITED_VIDEO_FIELD, SOURCE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("MuxType", MUX_TYPE_FIELD);
            this.put("CompositedVideo", COMPOSITED_VIDEO_FIELD);
            this.put("SourceConfiguration", SOURCE_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String muxType;
    private final CompositedVideoArtifactsConfiguration compositedVideo;
    private final SourceConfiguration sourceConfiguration;

    private ChimeSdkMeetingLiveConnectorConfiguration(BuilderImpl builder) {
        this.arn = builder.arn;
        this.muxType = builder.muxType;
        this.compositedVideo = builder.compositedVideo;
        this.sourceConfiguration = builder.sourceConfiguration;
    }

    public final String arn() {
        return this.arn;
    }

    public final LiveConnectorMuxType muxType() {
        return LiveConnectorMuxType.fromValue(this.muxType);
    }

    public final String muxTypeAsString() {
        return this.muxType;
    }

    public final CompositedVideoArtifactsConfiguration compositedVideo() {
        return this.compositedVideo;
    }

    public final SourceConfiguration sourceConfiguration() {
        return this.sourceConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.muxTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.compositedVideo());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChimeSdkMeetingLiveConnectorConfiguration)) {
            return false;
        }
        ChimeSdkMeetingLiveConnectorConfiguration other = (ChimeSdkMeetingLiveConnectorConfiguration)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.muxTypeAsString(), other.muxTypeAsString()) && Objects.equals(this.compositedVideo(), other.compositedVideo()) && Objects.equals(this.sourceConfiguration(), other.sourceConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ChimeSdkMeetingLiveConnectorConfiguration").add("Arn", (Object)(this.arn() == null ? null : "*** Sensitive Data Redacted ***")).add("MuxType", (Object)this.muxTypeAsString()).add("CompositedVideo", (Object)this.compositedVideo()).add("SourceConfiguration", (Object)this.sourceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "MuxType": {
                return Optional.ofNullable(clazz.cast(this.muxTypeAsString()));
            }
            case "CompositedVideo": {
                return Optional.ofNullable(clazz.cast(this.compositedVideo()));
            }
            case "SourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sourceConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ChimeSdkMeetingLiveConnectorConfiguration, T> g) {
        return obj -> g.apply((ChimeSdkMeetingLiveConnectorConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String muxType;
        private CompositedVideoArtifactsConfiguration compositedVideo;
        private SourceConfiguration sourceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ChimeSdkMeetingLiveConnectorConfiguration model) {
            this.arn(model.arn);
            this.muxType(model.muxType);
            this.compositedVideo(model.compositedVideo);
            this.sourceConfiguration(model.sourceConfiguration);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getMuxType() {
            return this.muxType;
        }

        public final void setMuxType(String muxType) {
            this.muxType = muxType;
        }

        @Override
        public final Builder muxType(String muxType) {
            this.muxType = muxType;
            return this;
        }

        @Override
        public final Builder muxType(LiveConnectorMuxType muxType) {
            this.muxType(muxType == null ? null : muxType.toString());
            return this;
        }

        public final CompositedVideoArtifactsConfiguration.Builder getCompositedVideo() {
            return this.compositedVideo != null ? this.compositedVideo.toBuilder() : null;
        }

        public final void setCompositedVideo(CompositedVideoArtifactsConfiguration.BuilderImpl compositedVideo) {
            this.compositedVideo = compositedVideo != null ? compositedVideo.build() : null;
        }

        @Override
        public final Builder compositedVideo(CompositedVideoArtifactsConfiguration compositedVideo) {
            this.compositedVideo = compositedVideo;
            return this;
        }

        public final SourceConfiguration.Builder getSourceConfiguration() {
            return this.sourceConfiguration != null ? this.sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(SourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        public final Builder sourceConfiguration(SourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public ChimeSdkMeetingLiveConnectorConfiguration build() {
            return new ChimeSdkMeetingLiveConnectorConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChimeSdkMeetingLiveConnectorConfiguration> {
        public Builder arn(String var1);

        public Builder muxType(String var1);

        public Builder muxType(LiveConnectorMuxType var1);

        public Builder compositedVideo(CompositedVideoArtifactsConfiguration var1);

        default public Builder compositedVideo(Consumer<CompositedVideoArtifactsConfiguration.Builder> compositedVideo) {
            return this.compositedVideo((CompositedVideoArtifactsConfiguration)((CompositedVideoArtifactsConfiguration.Builder)CompositedVideoArtifactsConfiguration.builder().applyMutation(compositedVideo)).build());
        }

        public Builder sourceConfiguration(SourceConfiguration var1);

        default public Builder sourceConfiguration(Consumer<SourceConfiguration.Builder> sourceConfiguration) {
            return this.sourceConfiguration((SourceConfiguration)((SourceConfiguration.Builder)SourceConfiguration.builder().applyMutation(sourceConfiguration)).build());
        }
    }
}

