/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the configuration settings for an Amazon Transcribe call analytics processor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmazonTranscribeCallAnalyticsProcessorConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AmazonTranscribeCallAnalyticsProcessorConfiguration.Builder, AmazonTranscribeCallAnalyticsProcessorConfiguration> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName").getter(getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::vocabularyName))
            .setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterName")
            .getter(getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::vocabularyFilterName))
            .setter(setter(Builder::vocabularyFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build())
            .build();

    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterMethod")
            .getter(getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::vocabularyFilterMethodAsString))
            .setter(setter(Builder::vocabularyFilterMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMethod").build())
            .build();

    private static final SdkField<String> LANGUAGE_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageModelName")
            .getter(getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::languageModelName))
            .setter(setter(Builder::languageModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageModelName").build()).build();

    private static final SdkField<Boolean> ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnablePartialResultsStabilization")
            .getter(getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::enablePartialResultsStabilization))
            .setter(setter(Builder::enablePartialResultsStabilization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePartialResultsStabilization")
                    .build()).build();

    private static final SdkField<String> PARTIAL_RESULTS_STABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartialResultsStability")
            .getter(getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::partialResultsStabilityAsString))
            .setter(setter(Builder::partialResultsStability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartialResultsStability").build())
            .build();

    private static final SdkField<String> CONTENT_IDENTIFICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentIdentificationType")
            .getter(getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::contentIdentificationTypeAsString))
            .setter(setter(Builder::contentIdentificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentIdentificationType").build())
            .build();

    private static final SdkField<String> CONTENT_REDACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentRedactionType")
            .getter(getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::contentRedactionTypeAsString))
            .setter(setter(Builder::contentRedactionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRedactionType").build())
            .build();

    private static final SdkField<String> PII_ENTITY_TYPES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PiiEntityTypes").getter(getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::piiEntityTypes))
            .setter(setter(Builder::piiEntityTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PiiEntityTypes").build()).build();

    private static final SdkField<Boolean> FILTER_PARTIAL_RESULTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FilterPartialResults")
            .getter(getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::filterPartialResults))
            .setter(setter(Builder::filterPartialResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterPartialResults").build())
            .build();

    private static final SdkField<PostCallAnalyticsSettings> POST_CALL_ANALYTICS_SETTINGS_FIELD = SdkField
            .<PostCallAnalyticsSettings> builder(MarshallingType.SDK_POJO).memberName("PostCallAnalyticsSettings")
            .getter(getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::postCallAnalyticsSettings))
            .setter(setter(Builder::postCallAnalyticsSettings)).constructor(PostCallAnalyticsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostCallAnalyticsSettings").build())
            .build();

    private static final SdkField<List<String>> CALL_ANALYTICS_STREAM_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CallAnalyticsStreamCategories")
            .getter(getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::callAnalyticsStreamCategories))
            .setter(setter(Builder::callAnalyticsStreamCategories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAnalyticsStreamCategories")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD,
            VOCABULARY_NAME_FIELD, VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD, LANGUAGE_MODEL_NAME_FIELD,
            ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD, PARTIAL_RESULTS_STABILITY_FIELD, CONTENT_IDENTIFICATION_TYPE_FIELD,
            CONTENT_REDACTION_TYPE_FIELD, PII_ENTITY_TYPES_FIELD, FILTER_PARTIAL_RESULTS_FIELD,
            POST_CALL_ANALYTICS_SETTINGS_FIELD, CALL_ANALYTICS_STREAM_CATEGORIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("LanguageCode", LANGUAGE_CODE_FIELD);
                    put("VocabularyName", VOCABULARY_NAME_FIELD);
                    put("VocabularyFilterName", VOCABULARY_FILTER_NAME_FIELD);
                    put("VocabularyFilterMethod", VOCABULARY_FILTER_METHOD_FIELD);
                    put("LanguageModelName", LANGUAGE_MODEL_NAME_FIELD);
                    put("EnablePartialResultsStabilization", ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD);
                    put("PartialResultsStability", PARTIAL_RESULTS_STABILITY_FIELD);
                    put("ContentIdentificationType", CONTENT_IDENTIFICATION_TYPE_FIELD);
                    put("ContentRedactionType", CONTENT_REDACTION_TYPE_FIELD);
                    put("PiiEntityTypes", PII_ENTITY_TYPES_FIELD);
                    put("FilterPartialResults", FILTER_PARTIAL_RESULTS_FIELD);
                    put("PostCallAnalyticsSettings", POST_CALL_ANALYTICS_SETTINGS_FIELD);
                    put("CallAnalyticsStreamCategories", CALL_ANALYTICS_STREAM_CATEGORIES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String languageCode;

    private final String vocabularyName;

    private final String vocabularyFilterName;

    private final String vocabularyFilterMethod;

    private final String languageModelName;

    private final Boolean enablePartialResultsStabilization;

    private final String partialResultsStability;

    private final String contentIdentificationType;

    private final String contentRedactionType;

    private final String piiEntityTypes;

    private final Boolean filterPartialResults;

    private final PostCallAnalyticsSettings postCallAnalyticsSettings;

    private final List<String> callAnalyticsStreamCategories;

    private AmazonTranscribeCallAnalyticsProcessorConfiguration(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.vocabularyName = builder.vocabularyName;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.languageModelName = builder.languageModelName;
        this.enablePartialResultsStabilization = builder.enablePartialResultsStabilization;
        this.partialResultsStability = builder.partialResultsStability;
        this.contentIdentificationType = builder.contentIdentificationType;
        this.contentRedactionType = builder.contentRedactionType;
        this.piiEntityTypes = builder.piiEntityTypes;
        this.filterPartialResults = builder.filterPartialResults;
        this.postCallAnalyticsSettings = builder.postCallAnalyticsSettings;
        this.callAnalyticsStreamCategories = builder.callAnalyticsStreamCategories;
    }

    /**
     * <p>
     * The language code in the configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link CallAnalyticsLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code in the configuration.
     * @see CallAnalyticsLanguageCode
     */
    public final CallAnalyticsLanguageCode languageCode() {
        return CallAnalyticsLanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code in the configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link CallAnalyticsLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code in the configuration.
     * @see CallAnalyticsLanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * Specifies the name of the custom vocabulary to use when processing a transcription. Note that vocabulary names
     * are case sensitive.
     * </p>
     * <p>
     * If the language of the specified custom vocabulary doesn't match the language identified in your media, the
     * custom vocabulary is not applied to your transcription.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a> in the
     * <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * Length Constraints: Minimum length of 1. Maximum length of 200.
     * </p>
     * 
     * @return Specifies the name of the custom vocabulary to use when processing a transcription. Note that vocabulary
     *         names are case sensitive.</p>
     *         <p>
     *         If the language of the specified custom vocabulary doesn't match the language identified in your media,
     *         the custom vocabulary is not applied to your transcription.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a> in
     *         the <i>Amazon Transcribe Developer Guide</i>.
     *         </p>
     *         <p>
     *         Length Constraints: Minimum length of 1. Maximum length of 200.
     */
    public final String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * Specifies the name of the custom vocabulary filter to use when processing a transcription. Note that vocabulary
     * filter names are case sensitive.
     * </p>
     * <p>
     * If the language of the specified custom vocabulary filter doesn't match the language identified in your media,
     * the vocabulary filter is not applied to your transcription.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering with
     * unwanted words</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * Length Constraints: Minimum length of 1. Maximum length of 200.
     * </p>
     * 
     * @return Specifies the name of the custom vocabulary filter to use when processing a transcription. Note that
     *         vocabulary filter names are case sensitive.</p>
     *         <p>
     *         If the language of the specified custom vocabulary filter doesn't match the language identified in your
     *         media, the vocabulary filter is not applied to your transcription.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary
     *         filtering with unwanted words</a> in the <i>Amazon Transcribe Developer Guide</i>.
     *         </p>
     *         <p>
     *         Length Constraints: Minimum length of 1. Maximum length of 200.
     */
    public final String vocabularyFilterName() {
        return vocabularyFilterName;
    }

    /**
     * <p>
     * Specifies how to apply a vocabulary filter to a transcript.
     * </p>
     * <p>
     * To replace words with <b>***</b>, choose <code>mask</code>.
     * </p>
     * <p>
     * To delete words, choose <code>remove</code>.
     * </p>
     * <p>
     * To flag words without changing them, choose <code>tag</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return Specifies how to apply a vocabulary filter to a transcript.</p>
     *         <p>
     *         To replace words with <b>***</b>, choose <code>mask</code>.
     *         </p>
     *         <p>
     *         To delete words, choose <code>remove</code>.
     *         </p>
     *         <p>
     *         To flag words without changing them, choose <code>tag</code>.
     * @see VocabularyFilterMethod
     */
    public final VocabularyFilterMethod vocabularyFilterMethod() {
        return VocabularyFilterMethod.fromValue(vocabularyFilterMethod);
    }

    /**
     * <p>
     * Specifies how to apply a vocabulary filter to a transcript.
     * </p>
     * <p>
     * To replace words with <b>***</b>, choose <code>mask</code>.
     * </p>
     * <p>
     * To delete words, choose <code>remove</code>.
     * </p>
     * <p>
     * To flag words without changing them, choose <code>tag</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return Specifies how to apply a vocabulary filter to a transcript.</p>
     *         <p>
     *         To replace words with <b>***</b>, choose <code>mask</code>.
     *         </p>
     *         <p>
     *         To delete words, choose <code>remove</code>.
     *         </p>
     *         <p>
     *         To flag words without changing them, choose <code>tag</code>.
     * @see VocabularyFilterMethod
     */
    public final String vocabularyFilterMethodAsString() {
        return vocabularyFilterMethod;
    }

    /**
     * <p>
     * Specifies the name of the custom language model to use when processing a transcription. Note that language model
     * names are case sensitive.
     * </p>
     * <p>
     * The language of the specified language model must match the language code specified in the transcription request.
     * If the languages don't match, the custom language model isn't applied. Language mismatches don't generate errors
     * or warnings.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language models</a> in
     * the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * 
     * @return Specifies the name of the custom language model to use when processing a transcription. Note that
     *         language model names are case sensitive.</p>
     *         <p>
     *         The language of the specified language model must match the language code specified in the transcription
     *         request. If the languages don't match, the custom language model isn't applied. Language mismatches don't
     *         generate errors or warnings.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language
     *         models</a> in the <i>Amazon Transcribe Developer Guide</i>.
     */
    public final String languageModelName() {
        return languageModelName;
    }

    /**
     * <p>
     * Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in
     * your output, but may impact accuracy. For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     * >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * 
     * @return Enables partial result stabilization for your transcription. Partial result stabilization can reduce
     *         latency in your output, but may impact accuracy. For more information, see <a href=
     *         "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     *         >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
     */
    public final Boolean enablePartialResultsStabilization() {
        return enablePartialResultsStabilization;
    }

    /**
     * <p>
     * Specifies the level of stability to use when you enable partial results stabilization (
     * <code>EnablePartialResultsStabilization</code>).
     * </p>
     * <p>
     * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     * >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #partialResultsStability} will return {@link PartialResultsStability#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #partialResultsStabilityAsString}.
     * </p>
     * 
     * @return Specifies the level of stability to use when you enable partial results stabilization (
     *         <code>EnablePartialResultsStabilization</code>).</p>
     *         <p>
     *         Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower
     *         accuracy.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     *         >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * @see PartialResultsStability
     */
    public final PartialResultsStability partialResultsStability() {
        return PartialResultsStability.fromValue(partialResultsStability);
    }

    /**
     * <p>
     * Specifies the level of stability to use when you enable partial results stabilization (
     * <code>EnablePartialResultsStabilization</code>).
     * </p>
     * <p>
     * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     * >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #partialResultsStability} will return {@link PartialResultsStability#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #partialResultsStabilityAsString}.
     * </p>
     * 
     * @return Specifies the level of stability to use when you enable partial results stabilization (
     *         <code>EnablePartialResultsStabilization</code>).</p>
     *         <p>
     *         Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower
     *         accuracy.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     *         >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * @see PartialResultsStability
     */
    public final String partialResultsStabilityAsString() {
        return partialResultsStability;
    }

    /**
     * <p>
     * Labels all personally identifiable information (PII) identified in your transcript.
     * </p>
     * <p>
     * Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is flagged
     * upon complete transcription of an audio segment.
     * </p>
     * <p>
     * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request.
     * If you do, your request returns a <code>BadRequestException</code>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting
     * or identifying personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return Labels all personally identifiable information (PII) identified in your transcript.</p>
     *         <p>
     *         Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
     *         flagged upon complete transcription of an audio segment.
     *         </p>
     *         <p>
     *         You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
     *         request. If you do, your request returns a <code>BadRequestException</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
     *         personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * @see ContentType
     */
    public final ContentType contentIdentificationType() {
        return ContentType.fromValue(contentIdentificationType);
    }

    /**
     * <p>
     * Labels all personally identifiable information (PII) identified in your transcript.
     * </p>
     * <p>
     * Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is flagged
     * upon complete transcription of an audio segment.
     * </p>
     * <p>
     * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request.
     * If you do, your request returns a <code>BadRequestException</code>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting
     * or identifying personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return Labels all personally identifiable information (PII) identified in your transcript.</p>
     *         <p>
     *         Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
     *         flagged upon complete transcription of an audio segment.
     *         </p>
     *         <p>
     *         You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
     *         request. If you do, your request returns a <code>BadRequestException</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
     *         personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * @see ContentType
     */
    public final String contentIdentificationTypeAsString() {
        return contentIdentificationType;
    }

    /**
     * <p>
     * Redacts all personally identifiable information (PII) identified in your transcript.
     * </p>
     * <p>
     * Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is redacted
     * upon complete transcription of an audio segment.
     * </p>
     * <p>
     * You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request.
     * If you do, your request returns a <code>BadRequestException</code>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting
     * or identifying personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentRedactionType} will return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #contentRedactionTypeAsString}.
     * </p>
     * 
     * @return Redacts all personally identifiable information (PII) identified in your transcript.</p>
     *         <p>
     *         Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
     *         redacted upon complete transcription of an audio segment.
     *         </p>
     *         <p>
     *         You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same
     *         request. If you do, your request returns a <code>BadRequestException</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
     *         personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * @see ContentType
     */
    public final ContentType contentRedactionType() {
        return ContentType.fromValue(contentRedactionType);
    }

    /**
     * <p>
     * Redacts all personally identifiable information (PII) identified in your transcript.
     * </p>
     * <p>
     * Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is redacted
     * upon complete transcription of an audio segment.
     * </p>
     * <p>
     * You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request.
     * If you do, your request returns a <code>BadRequestException</code>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting
     * or identifying personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentRedactionType} will return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #contentRedactionTypeAsString}.
     * </p>
     * 
     * @return Redacts all personally identifiable information (PII) identified in your transcript.</p>
     *         <p>
     *         Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
     *         redacted upon complete transcription of an audio segment.
     *         </p>
     *         <p>
     *         You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same
     *         request. If you do, your request returns a <code>BadRequestException</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
     *         personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
     * @see ContentType
     */
    public final String contentRedactionTypeAsString() {
        return contentRedactionType;
    }

    /**
     * <p>
     * Specifies the types of personally identifiable information (PII) to redact from a transcript. You can include as
     * many types as you'd like, or you can select <code>ALL</code>.
     * </p>
     * <p>
     * To include <code>PiiEntityTypes</code> in your Call Analytics request, you must also include
     * <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>, but you can't include both.
     * </p>
     * <p>
     * Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>,
     * <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>,
     * <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>, <code>NAME</code>, <code>PHONE</code>, <code>PIN</code>,
     * <code>SSN</code>, or <code>ALL</code>.
     * </p>
     * <p>
     * Length Constraints: Minimum length of 1. Maximum length of 300.
     * </p>
     * 
     * @return Specifies the types of personally identifiable information (PII) to redact from a transcript. You can
     *         include as many types as you'd like, or you can select <code>ALL</code>.</p>
     *         <p>
     *         To include <code>PiiEntityTypes</code> in your Call Analytics request, you must also include
     *         <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>, but you can't include both.
     *         </p>
     *         <p>
     *         Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>,
     *         <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>,
     *         <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>, <code>NAME</code>, <code>PHONE</code>,
     *         <code>PIN</code>, <code>SSN</code>, or <code>ALL</code>.
     *         </p>
     *         <p>
     *         Length Constraints: Minimum length of 1. Maximum length of 300.
     */
    public final String piiEntityTypes() {
        return piiEntityTypes;
    }

    /**
     * <p>
     * If true, <code>UtteranceEvents</code> with <code>IsPartial: true</code> are filtered out of the insights target.
     * </p>
     * 
     * @return If true, <code>UtteranceEvents</code> with <code>IsPartial: true</code> are filtered out of the insights
     *         target.
     */
    public final Boolean filterPartialResults() {
        return filterPartialResults;
    }

    /**
     * <p>
     * The settings for a post-call analysis task in an analytics configuration.
     * </p>
     * 
     * @return The settings for a post-call analysis task in an analytics configuration.
     */
    public final PostCallAnalyticsSettings postCallAnalyticsSettings() {
        return postCallAnalyticsSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the CallAnalyticsStreamCategories property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCallAnalyticsStreamCategories() {
        return callAnalyticsStreamCategories != null && !(callAnalyticsStreamCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * By default, all <code>CategoryEvents</code> are sent to the insights target. If this parameter is specified, only
     * included categories are sent to the insights target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCallAnalyticsStreamCategories} method.
     * </p>
     * 
     * @return By default, all <code>CategoryEvents</code> are sent to the insights target. If this parameter is
     *         specified, only included categories are sent to the insights target.
     */
    public final List<String> callAnalyticsStreamCategories() {
        return callAnalyticsStreamCategories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(languageModelName());
        hashCode = 31 * hashCode + Objects.hashCode(enablePartialResultsStabilization());
        hashCode = 31 * hashCode + Objects.hashCode(partialResultsStabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentIdentificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentRedactionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(piiEntityTypes());
        hashCode = 31 * hashCode + Objects.hashCode(filterPartialResults());
        hashCode = 31 * hashCode + Objects.hashCode(postCallAnalyticsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasCallAnalyticsStreamCategories() ? callAnalyticsStreamCategories() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonTranscribeCallAnalyticsProcessorConfiguration)) {
            return false;
        }
        AmazonTranscribeCallAnalyticsProcessorConfiguration other = (AmazonTranscribeCallAnalyticsProcessorConfiguration) obj;
        return Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(vocabularyName(), other.vocabularyName())
                && Objects.equals(vocabularyFilterName(), other.vocabularyFilterName())
                && Objects.equals(vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString())
                && Objects.equals(languageModelName(), other.languageModelName())
                && Objects.equals(enablePartialResultsStabilization(), other.enablePartialResultsStabilization())
                && Objects.equals(partialResultsStabilityAsString(), other.partialResultsStabilityAsString())
                && Objects.equals(contentIdentificationTypeAsString(), other.contentIdentificationTypeAsString())
                && Objects.equals(contentRedactionTypeAsString(), other.contentRedactionTypeAsString())
                && Objects.equals(piiEntityTypes(), other.piiEntityTypes())
                && Objects.equals(filterPartialResults(), other.filterPartialResults())
                && Objects.equals(postCallAnalyticsSettings(), other.postCallAnalyticsSettings())
                && hasCallAnalyticsStreamCategories() == other.hasCallAnalyticsStreamCategories()
                && Objects.equals(callAnalyticsStreamCategories(), other.callAnalyticsStreamCategories());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AmazonTranscribeCallAnalyticsProcessorConfiguration")
                .add("LanguageCode", languageCodeAsString())
                .add("VocabularyName", vocabularyName())
                .add("VocabularyFilterName", vocabularyFilterName())
                .add("VocabularyFilterMethod", vocabularyFilterMethodAsString())
                .add("LanguageModelName", languageModelName())
                .add("EnablePartialResultsStabilization", enablePartialResultsStabilization())
                .add("PartialResultsStability", partialResultsStabilityAsString())
                .add("ContentIdentificationType", contentIdentificationTypeAsString())
                .add("ContentRedactionType", contentRedactionTypeAsString())
                .add("PiiEntityTypes", piiEntityTypes())
                .add("FilterPartialResults", filterPartialResults())
                .add("PostCallAnalyticsSettings", postCallAnalyticsSettings())
                .add("CallAnalyticsStreamCategories", hasCallAnalyticsStreamCategories() ? callAnalyticsStreamCategories() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "VocabularyFilterName":
            return Optional.ofNullable(clazz.cast(vocabularyFilterName()));
        case "VocabularyFilterMethod":
            return Optional.ofNullable(clazz.cast(vocabularyFilterMethodAsString()));
        case "LanguageModelName":
            return Optional.ofNullable(clazz.cast(languageModelName()));
        case "EnablePartialResultsStabilization":
            return Optional.ofNullable(clazz.cast(enablePartialResultsStabilization()));
        case "PartialResultsStability":
            return Optional.ofNullable(clazz.cast(partialResultsStabilityAsString()));
        case "ContentIdentificationType":
            return Optional.ofNullable(clazz.cast(contentIdentificationTypeAsString()));
        case "ContentRedactionType":
            return Optional.ofNullable(clazz.cast(contentRedactionTypeAsString()));
        case "PiiEntityTypes":
            return Optional.ofNullable(clazz.cast(piiEntityTypes()));
        case "FilterPartialResults":
            return Optional.ofNullable(clazz.cast(filterPartialResults()));
        case "PostCallAnalyticsSettings":
            return Optional.ofNullable(clazz.cast(postCallAnalyticsSettings()));
        case "CallAnalyticsStreamCategories":
            return Optional.ofNullable(clazz.cast(callAnalyticsStreamCategories()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AmazonTranscribeCallAnalyticsProcessorConfiguration, T> g) {
        return obj -> g.apply((AmazonTranscribeCallAnalyticsProcessorConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmazonTranscribeCallAnalyticsProcessorConfiguration> {
        /**
         * <p>
         * The language code in the configuration.
         * </p>
         * 
         * @param languageCode
         *        The language code in the configuration.
         * @see CallAnalyticsLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAnalyticsLanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code in the configuration.
         * </p>
         * 
         * @param languageCode
         *        The language code in the configuration.
         * @see CallAnalyticsLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAnalyticsLanguageCode
         */
        Builder languageCode(CallAnalyticsLanguageCode languageCode);

        /**
         * <p>
         * Specifies the name of the custom vocabulary to use when processing a transcription. Note that vocabulary
         * names are case sensitive.
         * </p>
         * <p>
         * If the language of the specified custom vocabulary doesn't match the language identified in your media, the
         * custom vocabulary is not applied to your transcription.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a> in the
         * <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * <p>
         * Length Constraints: Minimum length of 1. Maximum length of 200.
         * </p>
         * 
         * @param vocabularyName
         *        Specifies the name of the custom vocabulary to use when processing a transcription. Note that
         *        vocabulary names are case sensitive.</p>
         *        <p>
         *        If the language of the specified custom vocabulary doesn't match the language identified in your
         *        media, the custom vocabulary is not applied to your transcription.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>
         *        in the <i>Amazon Transcribe Developer Guide</i>.
         *        </p>
         *        <p>
         *        Length Constraints: Minimum length of 1. Maximum length of 200.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * Specifies the name of the custom vocabulary filter to use when processing a transcription. Note that
         * vocabulary filter names are case sensitive.
         * </p>
         * <p>
         * If the language of the specified custom vocabulary filter doesn't match the language identified in your
         * media, the vocabulary filter is not applied to your transcription.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering
         * with unwanted words</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * <p>
         * Length Constraints: Minimum length of 1. Maximum length of 200.
         * </p>
         * 
         * @param vocabularyFilterName
         *        Specifies the name of the custom vocabulary filter to use when processing a transcription. Note that
         *        vocabulary filter names are case sensitive.</p>
         *        <p>
         *        If the language of the specified custom vocabulary filter doesn't match the language identified in
         *        your media, the vocabulary filter is not applied to your transcription.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary
         *        filtering with unwanted words</a> in the <i>Amazon Transcribe Developer Guide</i>.
         *        </p>
         *        <p>
         *        Length Constraints: Minimum length of 1. Maximum length of 200.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterName(String vocabularyFilterName);

        /**
         * <p>
         * Specifies how to apply a vocabulary filter to a transcript.
         * </p>
         * <p>
         * To replace words with <b>***</b>, choose <code>mask</code>.
         * </p>
         * <p>
         * To delete words, choose <code>remove</code>.
         * </p>
         * <p>
         * To flag words without changing them, choose <code>tag</code>.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        Specifies how to apply a vocabulary filter to a transcript.</p>
         *        <p>
         *        To replace words with <b>***</b>, choose <code>mask</code>.
         *        </p>
         *        <p>
         *        To delete words, choose <code>remove</code>.
         *        </p>
         *        <p>
         *        To flag words without changing them, choose <code>tag</code>.
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(String vocabularyFilterMethod);

        /**
         * <p>
         * Specifies how to apply a vocabulary filter to a transcript.
         * </p>
         * <p>
         * To replace words with <b>***</b>, choose <code>mask</code>.
         * </p>
         * <p>
         * To delete words, choose <code>remove</code>.
         * </p>
         * <p>
         * To flag words without changing them, choose <code>tag</code>.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        Specifies how to apply a vocabulary filter to a transcript.</p>
         *        <p>
         *        To replace words with <b>***</b>, choose <code>mask</code>.
         *        </p>
         *        <p>
         *        To delete words, choose <code>remove</code>.
         *        </p>
         *        <p>
         *        To flag words without changing them, choose <code>tag</code>.
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod);

        /**
         * <p>
         * Specifies the name of the custom language model to use when processing a transcription. Note that language
         * model names are case sensitive.
         * </p>
         * <p>
         * The language of the specified language model must match the language code specified in the transcription
         * request. If the languages don't match, the custom language model isn't applied. Language mismatches don't
         * generate errors or warnings.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language
         * models</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param languageModelName
         *        Specifies the name of the custom language model to use when processing a transcription. Note that
         *        language model names are case sensitive.</p>
         *        <p>
         *        The language of the specified language model must match the language code specified in the
         *        transcription request. If the languages don't match, the custom language model isn't applied. Language
         *        mismatches don't generate errors or warnings.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language
         *        models</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageModelName(String languageModelName);

        /**
         * <p>
         * Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency
         * in your output, but may impact accuracy. For more information, see <a href=
         * "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         * >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param enablePartialResultsStabilization
         *        Enables partial result stabilization for your transcription. Partial result stabilization can reduce
         *        latency in your output, but may impact accuracy. For more information, see <a href=
         *        "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         *        >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePartialResultsStabilization(Boolean enablePartialResultsStabilization);

        /**
         * <p>
         * Specifies the level of stability to use when you enable partial results stabilization (
         * <code>EnablePartialResultsStabilization</code>).
         * </p>
         * <p>
         * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower
         * accuracy.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         * >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param partialResultsStability
         *        Specifies the level of stability to use when you enable partial results stabilization (
         *        <code>EnablePartialResultsStabilization</code>).</p>
         *        <p>
         *        Low stability provides the highest accuracy. High stability transcribes faster, but with slightly
         *        lower accuracy.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         *        >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @see PartialResultsStability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartialResultsStability
         */
        Builder partialResultsStability(String partialResultsStability);

        /**
         * <p>
         * Specifies the level of stability to use when you enable partial results stabilization (
         * <code>EnablePartialResultsStabilization</code>).
         * </p>
         * <p>
         * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower
         * accuracy.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         * >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param partialResultsStability
         *        Specifies the level of stability to use when you enable partial results stabilization (
         *        <code>EnablePartialResultsStabilization</code>).</p>
         *        <p>
         *        Low stability provides the highest accuracy. High stability transcribes faster, but with slightly
         *        lower accuracy.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         *        >Partial-result stabilization</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @see PartialResultsStability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartialResultsStability
         */
        Builder partialResultsStability(PartialResultsStability partialResultsStability);

        /**
         * <p>
         * Labels all personally identifiable information (PII) identified in your transcript.
         * </p>
         * <p>
         * Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
         * flagged upon complete transcription of an audio segment.
         * </p>
         * <p>
         * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
         * request. If you do, your request returns a <code>BadRequestException</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         * personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param contentIdentificationType
         *        Labels all personally identifiable information (PII) identified in your transcript.</p>
         *        <p>
         *        Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code>
         *        is flagged upon complete transcription of an audio segment.
         *        </p>
         *        <p>
         *        You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
         *        request. If you do, your request returns a <code>BadRequestException</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         *        personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentIdentificationType(String contentIdentificationType);

        /**
         * <p>
         * Labels all personally identifiable information (PII) identified in your transcript.
         * </p>
         * <p>
         * Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
         * flagged upon complete transcription of an audio segment.
         * </p>
         * <p>
         * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
         * request. If you do, your request returns a <code>BadRequestException</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         * personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param contentIdentificationType
         *        Labels all personally identifiable information (PII) identified in your transcript.</p>
         *        <p>
         *        Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code>
         *        is flagged upon complete transcription of an audio segment.
         *        </p>
         *        <p>
         *        You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
         *        request. If you do, your request returns a <code>BadRequestException</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         *        personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentIdentificationType(ContentType contentIdentificationType);

        /**
         * <p>
         * Redacts all personally identifiable information (PII) identified in your transcript.
         * </p>
         * <p>
         * Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is redacted
         * upon complete transcription of an audio segment.
         * </p>
         * <p>
         * You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same
         * request. If you do, your request returns a <code>BadRequestException</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         * personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param contentRedactionType
         *        Redacts all personally identifiable information (PII) identified in your transcript.</p>
         *        <p>
         *        Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
         *        redacted upon complete transcription of an audio segment.
         *        </p>
         *        <p>
         *        You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same
         *        request. If you do, your request returns a <code>BadRequestException</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         *        personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentRedactionType(String contentRedactionType);

        /**
         * <p>
         * Redacts all personally identifiable information (PII) identified in your transcript.
         * </p>
         * <p>
         * Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is redacted
         * upon complete transcription of an audio segment.
         * </p>
         * <p>
         * You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same
         * request. If you do, your request returns a <code>BadRequestException</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         * personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * </p>
         * 
         * @param contentRedactionType
         *        Redacts all personally identifiable information (PII) identified in your transcript.</p>
         *        <p>
         *        Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
         *        redacted upon complete transcription of an audio segment.
         *        </p>
         *        <p>
         *        You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same
         *        request. If you do, your request returns a <code>BadRequestException</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         *        personally identifiable information</a> in the <i>Amazon Transcribe Developer Guide</i>.
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentRedactionType(ContentType contentRedactionType);

        /**
         * <p>
         * Specifies the types of personally identifiable information (PII) to redact from a transcript. You can include
         * as many types as you'd like, or you can select <code>ALL</code>.
         * </p>
         * <p>
         * To include <code>PiiEntityTypes</code> in your Call Analytics request, you must also include
         * <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>, but you can't include both.
         * </p>
         * <p>
         * Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>,
         * <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>,
         * <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>, <code>NAME</code>, <code>PHONE</code>, <code>PIN</code>, <code>SSN</code>, or <code>ALL</code>.
         * </p>
         * <p>
         * Length Constraints: Minimum length of 1. Maximum length of 300.
         * </p>
         * 
         * @param piiEntityTypes
         *        Specifies the types of personally identifiable information (PII) to redact from a transcript. You can
         *        include as many types as you'd like, or you can select <code>ALL</code>.</p>
         *        <p>
         *        To include <code>PiiEntityTypes</code> in your Call Analytics request, you must also include
         *        <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>, but you can't include
         *        both.
         *        </p>
         *        <p>
         *        Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>,
         *        <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>, <code>NAME</code>, <code>PHONE</code>,
         *        <code>PIN</code>, <code>SSN</code>, or <code>ALL</code>.
         *        </p>
         *        <p>
         *        Length Constraints: Minimum length of 1. Maximum length of 300.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder piiEntityTypes(String piiEntityTypes);

        /**
         * <p>
         * If true, <code>UtteranceEvents</code> with <code>IsPartial: true</code> are filtered out of the insights
         * target.
         * </p>
         * 
         * @param filterPartialResults
         *        If true, <code>UtteranceEvents</code> with <code>IsPartial: true</code> are filtered out of the
         *        insights target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPartialResults(Boolean filterPartialResults);

        /**
         * <p>
         * The settings for a post-call analysis task in an analytics configuration.
         * </p>
         * 
         * @param postCallAnalyticsSettings
         *        The settings for a post-call analysis task in an analytics configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postCallAnalyticsSettings(PostCallAnalyticsSettings postCallAnalyticsSettings);

        /**
         * <p>
         * The settings for a post-call analysis task in an analytics configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link PostCallAnalyticsSettings.Builder}
         * avoiding the need to create one manually via {@link PostCallAnalyticsSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PostCallAnalyticsSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #postCallAnalyticsSettings(PostCallAnalyticsSettings)}.
         * 
         * @param postCallAnalyticsSettings
         *        a consumer that will call methods on {@link PostCallAnalyticsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postCallAnalyticsSettings(PostCallAnalyticsSettings)
         */
        default Builder postCallAnalyticsSettings(Consumer<PostCallAnalyticsSettings.Builder> postCallAnalyticsSettings) {
            return postCallAnalyticsSettings(PostCallAnalyticsSettings.builder().applyMutation(postCallAnalyticsSettings).build());
        }

        /**
         * <p>
         * By default, all <code>CategoryEvents</code> are sent to the insights target. If this parameter is specified,
         * only included categories are sent to the insights target.
         * </p>
         * 
         * @param callAnalyticsStreamCategories
         *        By default, all <code>CategoryEvents</code> are sent to the insights target. If this parameter is
         *        specified, only included categories are sent to the insights target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callAnalyticsStreamCategories(Collection<String> callAnalyticsStreamCategories);

        /**
         * <p>
         * By default, all <code>CategoryEvents</code> are sent to the insights target. If this parameter is specified,
         * only included categories are sent to the insights target.
         * </p>
         * 
         * @param callAnalyticsStreamCategories
         *        By default, all <code>CategoryEvents</code> are sent to the insights target. If this parameter is
         *        specified, only included categories are sent to the insights target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callAnalyticsStreamCategories(String... callAnalyticsStreamCategories);
    }

    static final class BuilderImpl implements Builder {
        private String languageCode;

        private String vocabularyName;

        private String vocabularyFilterName;

        private String vocabularyFilterMethod;

        private String languageModelName;

        private Boolean enablePartialResultsStabilization;

        private String partialResultsStability;

        private String contentIdentificationType;

        private String contentRedactionType;

        private String piiEntityTypes;

        private Boolean filterPartialResults;

        private PostCallAnalyticsSettings postCallAnalyticsSettings;

        private List<String> callAnalyticsStreamCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonTranscribeCallAnalyticsProcessorConfiguration model) {
            languageCode(model.languageCode);
            vocabularyName(model.vocabularyName);
            vocabularyFilterName(model.vocabularyFilterName);
            vocabularyFilterMethod(model.vocabularyFilterMethod);
            languageModelName(model.languageModelName);
            enablePartialResultsStabilization(model.enablePartialResultsStabilization);
            partialResultsStability(model.partialResultsStability);
            contentIdentificationType(model.contentIdentificationType);
            contentRedactionType(model.contentRedactionType);
            piiEntityTypes(model.piiEntityTypes);
            filterPartialResults(model.filterPartialResults);
            postCallAnalyticsSettings(model.postCallAnalyticsSettings);
            callAnalyticsStreamCategories(model.callAnalyticsStreamCategories);
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(CallAnalyticsLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getVocabularyFilterName() {
            return vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        public final Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final String getLanguageModelName() {
            return languageModelName;
        }

        public final void setLanguageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
        }

        @Override
        public final Builder languageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
            return this;
        }

        public final Boolean getEnablePartialResultsStabilization() {
            return enablePartialResultsStabilization;
        }

        public final void setEnablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
        }

        @Override
        public final Builder enablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
            return this;
        }

        public final String getPartialResultsStability() {
            return partialResultsStability;
        }

        public final void setPartialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
        }

        @Override
        public final Builder partialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
            return this;
        }

        @Override
        public final Builder partialResultsStability(PartialResultsStability partialResultsStability) {
            this.partialResultsStability(partialResultsStability == null ? null : partialResultsStability.toString());
            return this;
        }

        public final String getContentIdentificationType() {
            return contentIdentificationType;
        }

        public final void setContentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
        }

        @Override
        public final Builder contentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
            return this;
        }

        @Override
        public final Builder contentIdentificationType(ContentType contentIdentificationType) {
            this.contentIdentificationType(contentIdentificationType == null ? null : contentIdentificationType.toString());
            return this;
        }

        public final String getContentRedactionType() {
            return contentRedactionType;
        }

        public final void setContentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
        }

        @Override
        public final Builder contentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
            return this;
        }

        @Override
        public final Builder contentRedactionType(ContentType contentRedactionType) {
            this.contentRedactionType(contentRedactionType == null ? null : contentRedactionType.toString());
            return this;
        }

        public final String getPiiEntityTypes() {
            return piiEntityTypes;
        }

        public final void setPiiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
        }

        @Override
        public final Builder piiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
            return this;
        }

        public final Boolean getFilterPartialResults() {
            return filterPartialResults;
        }

        public final void setFilterPartialResults(Boolean filterPartialResults) {
            this.filterPartialResults = filterPartialResults;
        }

        @Override
        public final Builder filterPartialResults(Boolean filterPartialResults) {
            this.filterPartialResults = filterPartialResults;
            return this;
        }

        public final PostCallAnalyticsSettings.Builder getPostCallAnalyticsSettings() {
            return postCallAnalyticsSettings != null ? postCallAnalyticsSettings.toBuilder() : null;
        }

        public final void setPostCallAnalyticsSettings(PostCallAnalyticsSettings.BuilderImpl postCallAnalyticsSettings) {
            this.postCallAnalyticsSettings = postCallAnalyticsSettings != null ? postCallAnalyticsSettings.build() : null;
        }

        @Override
        public final Builder postCallAnalyticsSettings(PostCallAnalyticsSettings postCallAnalyticsSettings) {
            this.postCallAnalyticsSettings = postCallAnalyticsSettings;
            return this;
        }

        public final Collection<String> getCallAnalyticsStreamCategories() {
            if (callAnalyticsStreamCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return callAnalyticsStreamCategories;
        }

        public final void setCallAnalyticsStreamCategories(Collection<String> callAnalyticsStreamCategories) {
            this.callAnalyticsStreamCategories = CategoryNameListCopier.copy(callAnalyticsStreamCategories);
        }

        @Override
        public final Builder callAnalyticsStreamCategories(Collection<String> callAnalyticsStreamCategories) {
            this.callAnalyticsStreamCategories = CategoryNameListCopier.copy(callAnalyticsStreamCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callAnalyticsStreamCategories(String... callAnalyticsStreamCategories) {
            callAnalyticsStreamCategories(Arrays.asList(callAnalyticsStreamCategories));
            return this;
        }

        @Override
        public AmazonTranscribeCallAnalyticsProcessorConfiguration build() {
            return new AmazonTranscribeCallAnalyticsProcessorConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
