/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the artifacts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArtifactsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ArtifactsConfiguration.Builder, ArtifactsConfiguration> {
    private static final SdkField<AudioArtifactsConfiguration> AUDIO_FIELD = SdkField
            .<AudioArtifactsConfiguration> builder(MarshallingType.SDK_POJO).memberName("Audio")
            .getter(getter(ArtifactsConfiguration::audio)).setter(setter(Builder::audio))
            .constructor(AudioArtifactsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audio").build()).build();

    private static final SdkField<VideoArtifactsConfiguration> VIDEO_FIELD = SdkField
            .<VideoArtifactsConfiguration> builder(MarshallingType.SDK_POJO).memberName("Video")
            .getter(getter(ArtifactsConfiguration::video)).setter(setter(Builder::video))
            .constructor(VideoArtifactsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()).build();

    private static final SdkField<ContentArtifactsConfiguration> CONTENT_FIELD = SdkField
            .<ContentArtifactsConfiguration> builder(MarshallingType.SDK_POJO).memberName("Content")
            .getter(getter(ArtifactsConfiguration::content)).setter(setter(Builder::content))
            .constructor(ContentArtifactsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<CompositedVideoArtifactsConfiguration> COMPOSITED_VIDEO_FIELD = SdkField
            .<CompositedVideoArtifactsConfiguration> builder(MarshallingType.SDK_POJO).memberName("CompositedVideo")
            .getter(getter(ArtifactsConfiguration::compositedVideo)).setter(setter(Builder::compositedVideo))
            .constructor(CompositedVideoArtifactsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositedVideo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_FIELD, VIDEO_FIELD,
            CONTENT_FIELD, COMPOSITED_VIDEO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Audio", AUDIO_FIELD);
                    put("Video", VIDEO_FIELD);
                    put("Content", CONTENT_FIELD);
                    put("CompositedVideo", COMPOSITED_VIDEO_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final AudioArtifactsConfiguration audio;

    private final VideoArtifactsConfiguration video;

    private final ContentArtifactsConfiguration content;

    private final CompositedVideoArtifactsConfiguration compositedVideo;

    private ArtifactsConfiguration(BuilderImpl builder) {
        this.audio = builder.audio;
        this.video = builder.video;
        this.content = builder.content;
        this.compositedVideo = builder.compositedVideo;
    }

    /**
     * <p>
     * The configuration for the audio artifacts.
     * </p>
     * 
     * @return The configuration for the audio artifacts.
     */
    public final AudioArtifactsConfiguration audio() {
        return audio;
    }

    /**
     * <p>
     * The configuration for the video artifacts.
     * </p>
     * 
     * @return The configuration for the video artifacts.
     */
    public final VideoArtifactsConfiguration video() {
        return video;
    }

    /**
     * <p>
     * The configuration for the content artifacts.
     * </p>
     * 
     * @return The configuration for the content artifacts.
     */
    public final ContentArtifactsConfiguration content() {
        return content;
    }

    /**
     * <p>
     * Enables video compositing.
     * </p>
     * 
     * @return Enables video compositing.
     */
    public final CompositedVideoArtifactsConfiguration compositedVideo() {
        return compositedVideo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audio());
        hashCode = 31 * hashCode + Objects.hashCode(video());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(compositedVideo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactsConfiguration)) {
            return false;
        }
        ArtifactsConfiguration other = (ArtifactsConfiguration) obj;
        return Objects.equals(audio(), other.audio()) && Objects.equals(video(), other.video())
                && Objects.equals(content(), other.content()) && Objects.equals(compositedVideo(), other.compositedVideo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArtifactsConfiguration").add("Audio", audio()).add("Video", video()).add("Content", content())
                .add("CompositedVideo", compositedVideo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Audio":
            return Optional.ofNullable(clazz.cast(audio()));
        case "Video":
            return Optional.ofNullable(clazz.cast(video()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "CompositedVideo":
            return Optional.ofNullable(clazz.cast(compositedVideo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ArtifactsConfiguration, T> g) {
        return obj -> g.apply((ArtifactsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArtifactsConfiguration> {
        /**
         * <p>
         * The configuration for the audio artifacts.
         * </p>
         * 
         * @param audio
         *        The configuration for the audio artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audio(AudioArtifactsConfiguration audio);

        /**
         * <p>
         * The configuration for the audio artifacts.
         * </p>
         * This is a convenience method that creates an instance of the {@link AudioArtifactsConfiguration.Builder}
         * avoiding the need to create one manually via {@link AudioArtifactsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudioArtifactsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #audio(AudioArtifactsConfiguration)}.
         * 
         * @param audio
         *        a consumer that will call methods on {@link AudioArtifactsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audio(AudioArtifactsConfiguration)
         */
        default Builder audio(Consumer<AudioArtifactsConfiguration.Builder> audio) {
            return audio(AudioArtifactsConfiguration.builder().applyMutation(audio).build());
        }

        /**
         * <p>
         * The configuration for the video artifacts.
         * </p>
         * 
         * @param video
         *        The configuration for the video artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder video(VideoArtifactsConfiguration video);

        /**
         * <p>
         * The configuration for the video artifacts.
         * </p>
         * This is a convenience method that creates an instance of the {@link VideoArtifactsConfiguration.Builder}
         * avoiding the need to create one manually via {@link VideoArtifactsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoArtifactsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #video(VideoArtifactsConfiguration)}.
         * 
         * @param video
         *        a consumer that will call methods on {@link VideoArtifactsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #video(VideoArtifactsConfiguration)
         */
        default Builder video(Consumer<VideoArtifactsConfiguration.Builder> video) {
            return video(VideoArtifactsConfiguration.builder().applyMutation(video).build());
        }

        /**
         * <p>
         * The configuration for the content artifacts.
         * </p>
         * 
         * @param content
         *        The configuration for the content artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(ContentArtifactsConfiguration content);

        /**
         * <p>
         * The configuration for the content artifacts.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContentArtifactsConfiguration.Builder}
         * avoiding the need to create one manually via {@link ContentArtifactsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentArtifactsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #content(ContentArtifactsConfiguration)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link ContentArtifactsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(ContentArtifactsConfiguration)
         */
        default Builder content(Consumer<ContentArtifactsConfiguration.Builder> content) {
            return content(ContentArtifactsConfiguration.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * Enables video compositing.
         * </p>
         * 
         * @param compositedVideo
         *        Enables video compositing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compositedVideo(CompositedVideoArtifactsConfiguration compositedVideo);

        /**
         * <p>
         * Enables video compositing.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CompositedVideoArtifactsConfiguration.Builder} avoiding the need to create one manually via
         * {@link CompositedVideoArtifactsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompositedVideoArtifactsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #compositedVideo(CompositedVideoArtifactsConfiguration)}.
         * 
         * @param compositedVideo
         *        a consumer that will call methods on {@link CompositedVideoArtifactsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compositedVideo(CompositedVideoArtifactsConfiguration)
         */
        default Builder compositedVideo(Consumer<CompositedVideoArtifactsConfiguration.Builder> compositedVideo) {
            return compositedVideo(CompositedVideoArtifactsConfiguration.builder().applyMutation(compositedVideo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AudioArtifactsConfiguration audio;

        private VideoArtifactsConfiguration video;

        private ContentArtifactsConfiguration content;

        private CompositedVideoArtifactsConfiguration compositedVideo;

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactsConfiguration model) {
            audio(model.audio);
            video(model.video);
            content(model.content);
            compositedVideo(model.compositedVideo);
        }

        public final AudioArtifactsConfiguration.Builder getAudio() {
            return audio != null ? audio.toBuilder() : null;
        }

        public final void setAudio(AudioArtifactsConfiguration.BuilderImpl audio) {
            this.audio = audio != null ? audio.build() : null;
        }

        @Override
        public final Builder audio(AudioArtifactsConfiguration audio) {
            this.audio = audio;
            return this;
        }

        public final VideoArtifactsConfiguration.Builder getVideo() {
            return video != null ? video.toBuilder() : null;
        }

        public final void setVideo(VideoArtifactsConfiguration.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(VideoArtifactsConfiguration video) {
            this.video = video;
            return this;
        }

        public final ContentArtifactsConfiguration.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(ContentArtifactsConfiguration.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(ContentArtifactsConfiguration content) {
            this.content = content;
            return this;
        }

        public final CompositedVideoArtifactsConfiguration.Builder getCompositedVideo() {
            return compositedVideo != null ? compositedVideo.toBuilder() : null;
        }

        public final void setCompositedVideo(CompositedVideoArtifactsConfiguration.BuilderImpl compositedVideo) {
            this.compositedVideo = compositedVideo != null ? compositedVideo.build() : null;
        }

        @Override
        public final Builder compositedVideo(CompositedVideoArtifactsConfiguration compositedVideo) {
            this.compositedVideo = compositedVideo;
            return this;
        }

        @Override
        public ArtifactsConfiguration build() {
            return new ArtifactsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
