/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration for compositing video artifacts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompositedVideoArtifactsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CompositedVideoArtifactsConfiguration.Builder, CompositedVideoArtifactsConfiguration> {
    private static final SdkField<String> LAYOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Layout")
            .getter(getter(CompositedVideoArtifactsConfiguration::layoutAsString)).setter(setter(Builder::layout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layout").build()).build();

    private static final SdkField<String> RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Resolution").getter(getter(CompositedVideoArtifactsConfiguration::resolutionAsString))
            .setter(setter(Builder::resolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resolution").build()).build();

    private static final SdkField<GridViewConfiguration> GRID_VIEW_CONFIGURATION_FIELD = SdkField
            .<GridViewConfiguration> builder(MarshallingType.SDK_POJO).memberName("GridViewConfiguration")
            .getter(getter(CompositedVideoArtifactsConfiguration::gridViewConfiguration))
            .setter(setter(Builder::gridViewConfiguration)).constructor(GridViewConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GridViewConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYOUT_FIELD,
            RESOLUTION_FIELD, GRID_VIEW_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Layout", LAYOUT_FIELD);
                    put("Resolution", RESOLUTION_FIELD);
                    put("GridViewConfiguration", GRID_VIEW_CONFIGURATION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String layout;

    private final String resolution;

    private final GridViewConfiguration gridViewConfiguration;

    private CompositedVideoArtifactsConfiguration(BuilderImpl builder) {
        this.layout = builder.layout;
        this.resolution = builder.resolution;
        this.gridViewConfiguration = builder.gridViewConfiguration;
    }

    /**
     * <p>
     * The layout setting, such as <code>GridView</code> in the configuration object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #layout} will
     * return {@link LayoutOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #layoutAsString}.
     * </p>
     * 
     * @return The layout setting, such as <code>GridView</code> in the configuration object.
     * @see LayoutOption
     */
    public final LayoutOption layout() {
        return LayoutOption.fromValue(layout);
    }

    /**
     * <p>
     * The layout setting, such as <code>GridView</code> in the configuration object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #layout} will
     * return {@link LayoutOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #layoutAsString}.
     * </p>
     * 
     * @return The layout setting, such as <code>GridView</code> in the configuration object.
     * @see LayoutOption
     */
    public final String layoutAsString() {
        return layout;
    }

    /**
     * <p>
     * The video resolution setting in the configuration object. Default: HD at 1280 x 720. FHD resolution: 1920 x 1080.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolution} will
     * return {@link ResolutionOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolutionAsString}.
     * </p>
     * 
     * @return The video resolution setting in the configuration object. Default: HD at 1280 x 720. FHD resolution: 1920
     *         x 1080.
     * @see ResolutionOption
     */
    public final ResolutionOption resolution() {
        return ResolutionOption.fromValue(resolution);
    }

    /**
     * <p>
     * The video resolution setting in the configuration object. Default: HD at 1280 x 720. FHD resolution: 1920 x 1080.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolution} will
     * return {@link ResolutionOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolutionAsString}.
     * </p>
     * 
     * @return The video resolution setting in the configuration object. Default: HD at 1280 x 720. FHD resolution: 1920
     *         x 1080.
     * @see ResolutionOption
     */
    public final String resolutionAsString() {
        return resolution;
    }

    /**
     * <p>
     * The <code>GridView</code> configuration setting.
     * </p>
     * 
     * @return The <code>GridView</code> configuration setting.
     */
    public final GridViewConfiguration gridViewConfiguration() {
        return gridViewConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(layoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gridViewConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositedVideoArtifactsConfiguration)) {
            return false;
        }
        CompositedVideoArtifactsConfiguration other = (CompositedVideoArtifactsConfiguration) obj;
        return Objects.equals(layoutAsString(), other.layoutAsString())
                && Objects.equals(resolutionAsString(), other.resolutionAsString())
                && Objects.equals(gridViewConfiguration(), other.gridViewConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompositedVideoArtifactsConfiguration").add("Layout", layoutAsString())
                .add("Resolution", resolutionAsString()).add("GridViewConfiguration", gridViewConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Layout":
            return Optional.ofNullable(clazz.cast(layoutAsString()));
        case "Resolution":
            return Optional.ofNullable(clazz.cast(resolutionAsString()));
        case "GridViewConfiguration":
            return Optional.ofNullable(clazz.cast(gridViewConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CompositedVideoArtifactsConfiguration, T> g) {
        return obj -> g.apply((CompositedVideoArtifactsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompositedVideoArtifactsConfiguration> {
        /**
         * <p>
         * The layout setting, such as <code>GridView</code> in the configuration object.
         * </p>
         * 
         * @param layout
         *        The layout setting, such as <code>GridView</code> in the configuration object.
         * @see LayoutOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayoutOption
         */
        Builder layout(String layout);

        /**
         * <p>
         * The layout setting, such as <code>GridView</code> in the configuration object.
         * </p>
         * 
         * @param layout
         *        The layout setting, such as <code>GridView</code> in the configuration object.
         * @see LayoutOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayoutOption
         */
        Builder layout(LayoutOption layout);

        /**
         * <p>
         * The video resolution setting in the configuration object. Default: HD at 1280 x 720. FHD resolution: 1920 x
         * 1080.
         * </p>
         * 
         * @param resolution
         *        The video resolution setting in the configuration object. Default: HD at 1280 x 720. FHD resolution:
         *        1920 x 1080.
         * @see ResolutionOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolutionOption
         */
        Builder resolution(String resolution);

        /**
         * <p>
         * The video resolution setting in the configuration object. Default: HD at 1280 x 720. FHD resolution: 1920 x
         * 1080.
         * </p>
         * 
         * @param resolution
         *        The video resolution setting in the configuration object. Default: HD at 1280 x 720. FHD resolution:
         *        1920 x 1080.
         * @see ResolutionOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolutionOption
         */
        Builder resolution(ResolutionOption resolution);

        /**
         * <p>
         * The <code>GridView</code> configuration setting.
         * </p>
         * 
         * @param gridViewConfiguration
         *        The <code>GridView</code> configuration setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gridViewConfiguration(GridViewConfiguration gridViewConfiguration);

        /**
         * <p>
         * The <code>GridView</code> configuration setting.
         * </p>
         * This is a convenience method that creates an instance of the {@link GridViewConfiguration.Builder} avoiding
         * the need to create one manually via {@link GridViewConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GridViewConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #gridViewConfiguration(GridViewConfiguration)}.
         * 
         * @param gridViewConfiguration
         *        a consumer that will call methods on {@link GridViewConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gridViewConfiguration(GridViewConfiguration)
         */
        default Builder gridViewConfiguration(Consumer<GridViewConfiguration.Builder> gridViewConfiguration) {
            return gridViewConfiguration(GridViewConfiguration.builder().applyMutation(gridViewConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String layout;

        private String resolution;

        private GridViewConfiguration gridViewConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CompositedVideoArtifactsConfiguration model) {
            layout(model.layout);
            resolution(model.resolution);
            gridViewConfiguration(model.gridViewConfiguration);
        }

        public final String getLayout() {
            return layout;
        }

        public final void setLayout(String layout) {
            this.layout = layout;
        }

        @Override
        public final Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        @Override
        public final Builder layout(LayoutOption layout) {
            this.layout(layout == null ? null : layout.toString());
            return this;
        }

        public final String getResolution() {
            return resolution;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        @Override
        public final Builder resolution(ResolutionOption resolution) {
            this.resolution(resolution == null ? null : resolution.toString());
            return this;
        }

        public final GridViewConfiguration.Builder getGridViewConfiguration() {
            return gridViewConfiguration != null ? gridViewConfiguration.toBuilder() : null;
        }

        public final void setGridViewConfiguration(GridViewConfiguration.BuilderImpl gridViewConfiguration) {
            this.gridViewConfiguration = gridViewConfiguration != null ? gridViewConfiguration.build() : null;
        }

        @Override
        public final Builder gridViewConfiguration(GridViewConfiguration gridViewConfiguration) {
            this.gridViewConfiguration = gridViewConfiguration;
            return this;
        }

        @Override
        public CompositedVideoArtifactsConfiguration build() {
            return new CompositedVideoArtifactsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
