/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the Kinesis video stream pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisVideoStreamPoolSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisVideoStreamPoolSummary.Builder, KinesisVideoStreamPoolSummary> {
    private static final SdkField<String> POOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolName").getter(getter(KinesisVideoStreamPoolSummary::poolName)).setter(setter(Builder::poolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()).build();

    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(KinesisVideoStreamPoolSummary::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<String> POOL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolArn").getter(getter(KinesisVideoStreamPoolSummary::poolArn)).setter(setter(Builder::poolArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_NAME_FIELD,
            POOL_ID_FIELD, POOL_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("PoolName", POOL_NAME_FIELD);
                    put("PoolId", POOL_ID_FIELD);
                    put("PoolArn", POOL_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String poolName;

    private final String poolId;

    private final String poolArn;

    private KinesisVideoStreamPoolSummary(BuilderImpl builder) {
        this.poolName = builder.poolName;
        this.poolId = builder.poolId;
        this.poolArn = builder.poolArn;
    }

    /**
     * <p>
     * The name of the video stream pool.
     * </p>
     * 
     * @return The name of the video stream pool.
     */
    public final String poolName() {
        return poolName;
    }

    /**
     * <p>
     * The ID of the video stream pool.
     * </p>
     * 
     * @return The ID of the video stream pool.
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * The ARN of the video stream pool.
     * </p>
     * 
     * @return The ARN of the video stream pool.
     */
    public final String poolArn() {
        return poolArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(poolName());
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(poolArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisVideoStreamPoolSummary)) {
            return false;
        }
        KinesisVideoStreamPoolSummary other = (KinesisVideoStreamPoolSummary) obj;
        return Objects.equals(poolName(), other.poolName()) && Objects.equals(poolId(), other.poolId())
                && Objects.equals(poolArn(), other.poolArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisVideoStreamPoolSummary").add("PoolName", poolName()).add("PoolId", poolId())
                .add("PoolArn", poolArn() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolName":
            return Optional.ofNullable(clazz.cast(poolName()));
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "PoolArn":
            return Optional.ofNullable(clazz.cast(poolArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KinesisVideoStreamPoolSummary, T> g) {
        return obj -> g.apply((KinesisVideoStreamPoolSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisVideoStreamPoolSummary> {
        /**
         * <p>
         * The name of the video stream pool.
         * </p>
         * 
         * @param poolName
         *        The name of the video stream pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolName(String poolName);

        /**
         * <p>
         * The ID of the video stream pool.
         * </p>
         * 
         * @param poolId
         *        The ID of the video stream pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * The ARN of the video stream pool.
         * </p>
         * 
         * @param poolArn
         *        The ARN of the video stream pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolArn(String poolArn);
    }

    static final class BuilderImpl implements Builder {
        private String poolName;

        private String poolId;

        private String poolArn;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisVideoStreamPoolSummary model) {
            poolName(model.poolName);
            poolId(model.poolId);
            poolArn(model.poolArn);
        }

        public final String getPoolName() {
            return poolName;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getPoolArn() {
            return poolArn;
        }

        public final void setPoolArn(String poolArn) {
            this.poolArn = poolArn;
        }

        @Override
        public final Builder poolArn(String poolArn) {
            this.poolArn = poolArn;
            return this;
        }

        @Override
        public KinesisVideoStreamPoolSummary build() {
            return new KinesisVideoStreamPoolSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
