/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the pipeline element.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaInsightsPipelineElementStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaInsightsPipelineElementStatus.Builder, MediaInsightsPipelineElementStatus> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(MediaInsightsPipelineElementStatus::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(MediaInsightsPipelineElementStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Type", TYPE_FIELD);
                    put("Status", STATUS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String status;

    private MediaInsightsPipelineElementStatus(BuilderImpl builder) {
        this.type = builder.type;
        this.status = builder.status;
    }

    /**
     * <p>
     * The type of status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MediaInsightsPipelineConfigurationElementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of status.
     * @see MediaInsightsPipelineConfigurationElementType
     */
    public final MediaInsightsPipelineConfigurationElementType type() {
        return MediaInsightsPipelineConfigurationElementType.fromValue(type);
    }

    /**
     * <p>
     * The type of status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MediaInsightsPipelineConfigurationElementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of status.
     * @see MediaInsightsPipelineConfigurationElementType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The element's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MediaPipelineElementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The element's status.
     * @see MediaPipelineElementStatus
     */
    public final MediaPipelineElementStatus status() {
        return MediaPipelineElementStatus.fromValue(status);
    }

    /**
     * <p>
     * The element's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MediaPipelineElementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The element's status.
     * @see MediaPipelineElementStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaInsightsPipelineElementStatus)) {
            return false;
        }
        MediaInsightsPipelineElementStatus other = (MediaInsightsPipelineElementStatus) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaInsightsPipelineElementStatus").add("Type", typeAsString()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MediaInsightsPipelineElementStatus, T> g) {
        return obj -> g.apply((MediaInsightsPipelineElementStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaInsightsPipelineElementStatus> {
        /**
         * <p>
         * The type of status.
         * </p>
         * 
         * @param type
         *        The type of status.
         * @see MediaInsightsPipelineConfigurationElementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaInsightsPipelineConfigurationElementType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of status.
         * </p>
         * 
         * @param type
         *        The type of status.
         * @see MediaInsightsPipelineConfigurationElementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaInsightsPipelineConfigurationElementType
         */
        Builder type(MediaInsightsPipelineConfigurationElementType type);

        /**
         * <p>
         * The element's status.
         * </p>
         * 
         * @param status
         *        The element's status.
         * @see MediaPipelineElementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineElementStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The element's status.
         * </p>
         * 
         * @param status
         *        The element's status.
         * @see MediaPipelineElementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineElementStatus
         */
        Builder status(MediaPipelineElementStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaInsightsPipelineElementStatus model) {
            type(model.type);
            status(model.status);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MediaInsightsPipelineConfigurationElementType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MediaPipelineElementStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public MediaInsightsPipelineElementStatus build() {
            return new MediaInsightsPipelineElementStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
