/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the configuration for a presenter-only video tile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PresenterOnlyConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PresenterOnlyConfiguration.Builder, PresenterOnlyConfiguration> {
    private static final SdkField<String> PRESENTER_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PresenterPosition").getter(getter(PresenterOnlyConfiguration::presenterPositionAsString))
            .setter(setter(Builder::presenterPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresenterPosition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRESENTER_POSITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("PresenterPosition", PRESENTER_POSITION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String presenterPosition;

    private PresenterOnlyConfiguration(BuilderImpl builder) {
        this.presenterPosition = builder.presenterPosition;
    }

    /**
     * <p>
     * Defines the position of the presenter video tile. Default: <code>TopRight</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #presenterPosition}
     * will return {@link PresenterPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #presenterPositionAsString}.
     * </p>
     * 
     * @return Defines the position of the presenter video tile. Default: <code>TopRight</code>.
     * @see PresenterPosition
     */
    public final PresenterPosition presenterPosition() {
        return PresenterPosition.fromValue(presenterPosition);
    }

    /**
     * <p>
     * Defines the position of the presenter video tile. Default: <code>TopRight</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #presenterPosition}
     * will return {@link PresenterPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #presenterPositionAsString}.
     * </p>
     * 
     * @return Defines the position of the presenter video tile. Default: <code>TopRight</code>.
     * @see PresenterPosition
     */
    public final String presenterPositionAsString() {
        return presenterPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(presenterPositionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PresenterOnlyConfiguration)) {
            return false;
        }
        PresenterOnlyConfiguration other = (PresenterOnlyConfiguration) obj;
        return Objects.equals(presenterPositionAsString(), other.presenterPositionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PresenterOnlyConfiguration").add("PresenterPosition", presenterPositionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PresenterPosition":
            return Optional.ofNullable(clazz.cast(presenterPositionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PresenterOnlyConfiguration, T> g) {
        return obj -> g.apply((PresenterOnlyConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PresenterOnlyConfiguration> {
        /**
         * <p>
         * Defines the position of the presenter video tile. Default: <code>TopRight</code>.
         * </p>
         * 
         * @param presenterPosition
         *        Defines the position of the presenter video tile. Default: <code>TopRight</code>.
         * @see PresenterPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PresenterPosition
         */
        Builder presenterPosition(String presenterPosition);

        /**
         * <p>
         * Defines the position of the presenter video tile. Default: <code>TopRight</code>.
         * </p>
         * 
         * @param presenterPosition
         *        Defines the position of the presenter video tile. Default: <code>TopRight</code>.
         * @see PresenterPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PresenterPosition
         */
        Builder presenterPosition(PresenterPosition presenterPosition);
    }

    static final class BuilderImpl implements Builder {
        private String presenterPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(PresenterOnlyConfiguration model) {
            presenterPosition(model.presenterPosition);
        }

        public final String getPresenterPosition() {
            return presenterPosition;
        }

        public final void setPresenterPosition(String presenterPosition) {
            this.presenterPosition = presenterPosition;
        }

        @Override
        public final Builder presenterPosition(String presenterPosition) {
            this.presenterPosition = presenterPosition;
            return this;
        }

        @Override
        public final Builder presenterPosition(PresenterPosition presenterPosition) {
            this.presenterPosition(presenterPosition == null ? null : presenterPosition.toString());
            return this;
        }

        @Override
        public PresenterOnlyConfiguration build() {
            return new PresenterOnlyConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
