/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A representation of an asynchronous request to perform speaker search analysis on a media insights pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpeakerSearchTask implements SdkPojo, Serializable,
        ToCopyableBuilder<SpeakerSearchTask.Builder, SpeakerSearchTask> {
    private static final SdkField<String> SPEAKER_SEARCH_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpeakerSearchTaskId").getter(getter(SpeakerSearchTask::speakerSearchTaskId))
            .setter(setter(Builder::speakerSearchTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeakerSearchTaskId").build())
            .build();

    private static final SdkField<String> SPEAKER_SEARCH_TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpeakerSearchTaskStatus").getter(getter(SpeakerSearchTask::speakerSearchTaskStatusAsString))
            .setter(setter(Builder::speakerSearchTaskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeakerSearchTaskStatus").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(SpeakerSearchTask::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(SpeakerSearchTask::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEAKER_SEARCH_TASK_ID_FIELD,
            SPEAKER_SEARCH_TASK_STATUS_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SpeakerSearchTaskId", SPEAKER_SEARCH_TASK_ID_FIELD);
                    put("SpeakerSearchTaskStatus", SPEAKER_SEARCH_TASK_STATUS_FIELD);
                    put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
                    put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String speakerSearchTaskId;

    private final String speakerSearchTaskStatus;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private SpeakerSearchTask(BuilderImpl builder) {
        this.speakerSearchTaskId = builder.speakerSearchTaskId;
        this.speakerSearchTaskStatus = builder.speakerSearchTaskStatus;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    /**
     * <p>
     * The speaker search task ID.
     * </p>
     * 
     * @return The speaker search task ID.
     */
    public final String speakerSearchTaskId() {
        return speakerSearchTaskId;
    }

    /**
     * <p>
     * The status of the speaker search task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #speakerSearchTaskStatus} will return {@link MediaPipelineTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #speakerSearchTaskStatusAsString}.
     * </p>
     * 
     * @return The status of the speaker search task.
     * @see MediaPipelineTaskStatus
     */
    public final MediaPipelineTaskStatus speakerSearchTaskStatus() {
        return MediaPipelineTaskStatus.fromValue(speakerSearchTaskStatus);
    }

    /**
     * <p>
     * The status of the speaker search task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #speakerSearchTaskStatus} will return {@link MediaPipelineTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #speakerSearchTaskStatusAsString}.
     * </p>
     * 
     * @return The status of the speaker search task.
     * @see MediaPipelineTaskStatus
     */
    public final String speakerSearchTaskStatusAsString() {
        return speakerSearchTaskStatus;
    }

    /**
     * <p>
     * The time at which a speaker search task was created.
     * </p>
     * 
     * @return The time at which a speaker search task was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time at which a speaker search task was updated.
     * </p>
     * 
     * @return The time at which a speaker search task was updated.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(speakerSearchTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(speakerSearchTaskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpeakerSearchTask)) {
            return false;
        }
        SpeakerSearchTask other = (SpeakerSearchTask) obj;
        return Objects.equals(speakerSearchTaskId(), other.speakerSearchTaskId())
                && Objects.equals(speakerSearchTaskStatusAsString(), other.speakerSearchTaskStatusAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpeakerSearchTask").add("SpeakerSearchTaskId", speakerSearchTaskId())
                .add("SpeakerSearchTaskStatus", speakerSearchTaskStatusAsString()).add("CreatedTimestamp", createdTimestamp())
                .add("UpdatedTimestamp", updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpeakerSearchTaskId":
            return Optional.ofNullable(clazz.cast(speakerSearchTaskId()));
        case "SpeakerSearchTaskStatus":
            return Optional.ofNullable(clazz.cast(speakerSearchTaskStatusAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SpeakerSearchTask, T> g) {
        return obj -> g.apply((SpeakerSearchTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpeakerSearchTask> {
        /**
         * <p>
         * The speaker search task ID.
         * </p>
         * 
         * @param speakerSearchTaskId
         *        The speaker search task ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speakerSearchTaskId(String speakerSearchTaskId);

        /**
         * <p>
         * The status of the speaker search task.
         * </p>
         * 
         * @param speakerSearchTaskStatus
         *        The status of the speaker search task.
         * @see MediaPipelineTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineTaskStatus
         */
        Builder speakerSearchTaskStatus(String speakerSearchTaskStatus);

        /**
         * <p>
         * The status of the speaker search task.
         * </p>
         * 
         * @param speakerSearchTaskStatus
         *        The status of the speaker search task.
         * @see MediaPipelineTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineTaskStatus
         */
        Builder speakerSearchTaskStatus(MediaPipelineTaskStatus speakerSearchTaskStatus);

        /**
         * <p>
         * The time at which a speaker search task was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which a speaker search task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time at which a speaker search task was updated.
         * </p>
         * 
         * @param updatedTimestamp
         *        The time at which a speaker search task was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String speakerSearchTaskId;

        private String speakerSearchTaskStatus;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(SpeakerSearchTask model) {
            speakerSearchTaskId(model.speakerSearchTaskId);
            speakerSearchTaskStatus(model.speakerSearchTaskStatus);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
        }

        public final String getSpeakerSearchTaskId() {
            return speakerSearchTaskId;
        }

        public final void setSpeakerSearchTaskId(String speakerSearchTaskId) {
            this.speakerSearchTaskId = speakerSearchTaskId;
        }

        @Override
        public final Builder speakerSearchTaskId(String speakerSearchTaskId) {
            this.speakerSearchTaskId = speakerSearchTaskId;
            return this;
        }

        public final String getSpeakerSearchTaskStatus() {
            return speakerSearchTaskStatus;
        }

        public final void setSpeakerSearchTaskStatus(String speakerSearchTaskStatus) {
            this.speakerSearchTaskStatus = speakerSearchTaskStatus;
        }

        @Override
        public final Builder speakerSearchTaskStatus(String speakerSearchTaskStatus) {
            this.speakerSearchTaskStatus = speakerSearchTaskStatus;
            return this;
        }

        @Override
        public final Builder speakerSearchTaskStatus(MediaPipelineTaskStatus speakerSearchTaskStatus) {
            this.speakerSearchTaskStatus(speakerSearchTaskStatus == null ? null : speakerSearchTaskStatus.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        @Override
        public SpeakerSearchTask build() {
            return new SpeakerSearchTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
